/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.servlet;

import com.plusmpm.database.files.OpenedFile;
import com.plusmpm.database.files.OpenedFilesManager;
import com.plusmpm.util.Authorization;
import com.plusmpm.util.HttpHeaders;
import com.plusmpm.util.Tools;
import com.suncode.pwfl.archive.DocumentSearchCache;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.util.io.FileEncodingUtils;
import com.suncode.pwfl.workflow.archiver.ZipArchiverManager;
import com.suncode.pwfl.workflow.cipher.CipherManager;
import com.suncode.pwfl.workflow.support.MSWordFileCustomProperties;
import com.suncode.pwfl.workflow.support.OpenedFileContext;
import com.suncode.pwfl.workflow.support.ReadFileEventManager;
import com.suncode.pwfl.workflow.support.ViewFileEventManager;
import com.suncode.pwfl.workflow.support.exception.ReadFileEventException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.log4j.Logger;

public class ShowFileServlet
extends HttpServlet {
    private static final long serialVersionUID = -8199364500994102894L;
    public static Logger log = Logger.getLogger(ShowFileServlet.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.info((Object)"****************************** ShowFileServlet.doGet ********************");
        String browserUserAgent = request.getHeader("user-agent");
        InputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        ServletOutputStream servletOutputStream = null;
        File file = null;
        String processId = request.getParameter("processId");
        String activityId = request.getParameter("activityId");
        String processRightKey = request.getParameter("processRightKey");
        try {
            HttpSession httpSession = request.getSession(false);
            String userName = (String)httpSession.getAttribute("username");
            String fileName = null;
            String fileId = request.getParameter("fileId");
            if (!StringUtils.isBlank((CharSequence)fileId)) {
                boolean hasRightsToNewestVersion;
                boolean hasRights = ((DocumentSearchCache)SpringContext.getBean(DocumentSearchCache.class)).containsFileIdForUser(userName, Long.valueOf(fileId)) || Authorization.hasRightsToReadFile((String)userName, (Long)Long.valueOf(fileId), (String)processRightKey);
                WfFile workflowFile = ServiceFactory.getFileService().getFile(new Long(fileId), new String[]{"documentClass", "version"});
                Long newestVersionFileId = workflowFile.getVersion().getNewestFile().getId();
                boolean bl = hasRightsToNewestVersion = ((DocumentSearchCache)SpringContext.getBean(DocumentSearchCache.class)).containsFileIdForUser(userName, newestVersionFileId) || Authorization.hasRightsToReadFile((String)userName, (Long)newestVersionFileId, (String)processRightKey);
                if (hasRights || hasRightsToNewestVersion) {
                    String orgFileName = workflowFile.getFileName();
                    String fileFullPath = workflowFile.getFullPath();
                    file = new File(fileFullPath);
                    if (file.exists() && file.canRead()) {
                        String mimeType = Tools.MIMETYPES_FILE_TYPE_MAP.getContentType(orgFileName.toLowerCase());
                        if (StringUtils.isNotBlank((CharSequence)userName) && (mimeType.compareTo("application/msword") == 0 || mimeType.compareTo("application/vnd.openxmlformats-officedocument.wordprocessingml.document") == 0)) {
                            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                            String sessionId = httpSession.getId();
                            Date dateOfOpen = dateFormat.parse(dateFormat.format(new Date()));
                            OpenedFile openedFile = OpenedFilesManager.isOpen((Long)Long.valueOf(fileId), (String)userName, (String)sessionId);
                            if (openedFile == null) {
                                openedFile = new OpenedFile();
                                openedFile.setFileId(Long.valueOf(fileId));
                                openedFile.setUsername(userName);
                                openedFile.setFileName(orgFileName);
                                openedFile.setSessionId(sessionId);
                                openedFile.setDateOfOpen(dateOfOpen);
                                OpenedFilesManager.save((OpenedFile)openedFile);
                            } else {
                                openedFile.setDateOfOpen(dateOfOpen);
                                OpenedFilesManager.update((OpenedFile)openedFile);
                            }
                        }
                        if (!mimeType.equalsIgnoreCase("application/pdf") || browserUserAgent.contains("Mac OS X") || browserUserAgent.contains("Macintosh")) {
                            response.setContentType(mimeType);
                        }
                        fileInputStream = new FileInputStream(file);
                        fileInputStream = ZipArchiverManager.uncompress((InputStream)fileInputStream, (WfFile)workflowFile);
                        fileInputStream = CipherManager.decryptFile((InputStream)fileInputStream, (WfFile)workflowFile);
                        fileInputStream = MSWordFileCustomProperties.addProperties((InputStream)fileInputStream, (WfFile)workflowFile);
                        OpenedFileContext fileContext = ReadFileEventManager.execute((InputStream)fileInputStream, (WfFile)workflowFile, (String)mimeType, (String)processId, (String)activityId, (String)userName);
                        fileContext = ViewFileEventManager.execute((OpenedFileContext)fileContext);
                        fileInputStream = fileContext.getInputStream();
                        bufferedInputStream = new BufferedInputStream(fileInputStream);
                        response.setHeader("Content-Disposition", HttpHeaders.getContentDisposition((String)(FilenameUtils.getBaseName((String)orgFileName) + "." + fileContext.getExtension()), (boolean)true));
                        response.setContentType(fileContext.getMimeType());
                        response.setContentLength(bufferedInputStream.available());
                        if ("application/xhtml+xml".equalsIgnoreCase(mimeType)) {
                            Charset xmlEncoding = FileEncodingUtils.detectXmlEncoding((InputStream)bufferedInputStream);
                            response.setCharacterEncoding(xmlEncoding.name());
                        }
                        servletOutputStream = response.getOutputStream();
                        IOUtils.write((byte[])IOUtils.toByteArray((InputStream)bufferedInputStream), (OutputStream)servletOutputStream);
                        servletOutputStream.flush();
                        if (fileContext.getInputStream() != null) {
                            fileContext.getInputStream().close();
                        }
                    } else {
                        log.warn((Object)("Plik: " + fileName + " (id: " + fileId + " ) nie istnieje lub nie mozna go odczytac."));
                    }
                } else {
                    log.warn((Object)("Brak praw do wy\u015bwietlenia dokumentu - u\u017cytkownik: " + userName));
                    response.setContentType("text/html;UTF-8");
                    servletOutputStream = response.getOutputStream();
                    String msg = "<link rel=\"stylesheet\" type=\"text/css\" media=\"screen\" href=\"" + request.getContextPath() + "/resources/css/pwfl_blue.css\" /><div id=\"message-cloud\" class=\"message-box warning\" style=\"display: flex;\"><div class=\"message-box-icon-wrapper\"><div class=\"message-box-icon\"></div></div><p>" + MessageHelper.getMessage((String)"Brak_uprawnien") + "</p></div>";
                    IOUtils.write((String)msg, (OutputStream)servletOutputStream, (Charset)StandardCharsets.UTF_8);
                    servletOutputStream.flush();
                }
            }
        }
        catch (ReadFileEventException ex) {
            log.warn((Object)ex.getMessage());
            response.setContentType("text/plain");
            servletOutputStream = response.getOutputStream();
            IOUtils.write((byte[])ex.getMessage().getBytes(), (OutputStream)servletOutputStream);
            servletOutputStream.flush();
        }
        catch (Exception e) {
            if (e.getClass().getName().equals("org.apache.catalina.connector.ClientAbortException")) {
                log.info((Object)("The user probably has closed the browser window \n" + ExceptionUtils.getStackTrace((Throwable)e)));
            } else {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        finally {
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
            }
            catch (IOException ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
            try {
                if (servletOutputStream != null) {
                    servletOutputStream.close();
                }
            }
            catch (IOException ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.info((Object)"****************************** ShowFileServlet.doPost ********************");
        this.doGet(request, response);
    }
}

