Ext.ux.plusmpm.scheduledtasks.ParametersContainer = function (config) {
  config = Ext.apply(
    {
      labelWidth: 250,
      layout: {
        type: 'form',
        trackLabels: true,
      },
      fieldsSpace: 5,
      defaults: {
        labelWidth: 250,
        anchor: '100%',
        allowBlank: false,
      },
    },
    config
  );

  Ext.ux.plusmpm.scheduledtasks.ParametersContainer.superclass.constructor.call(this, config);
};

Ext.extend(Ext.ux.plusmpm.scheduledtasks.ParametersContainer, Ext.Container, {
  initComponent: function () {
    Ext.ux.plusmpm.scheduledtasks.ParametersContainer.superclass.initComponent.call(this);
  },

  buildParameters: function (componentTaskId) {
    this.removeAll(true);

    if (PW.ScheduledTasks.contains(componentTaskId)) {
      var formScript = PW.ScheduledTasks.get(componentTaskId);
      formScript.buildParams.call(
        formScript,
        new Ext.ux.plusmpm.scheduledtasks.DynamicFormApi({
          form: this,
          parametersBuilder: this.parametersBuilder,
          window: this.window,
        })
      );
    } else {
      this.parametersBuilder.eachParam(function (componentParamId, definition) {
        this.addParameter(definition);
      }, this);
    }
  },

  addParameter: function (paramDefinition) {
    var lastPosition = this.items.length;

    var parameterCmpConfig = this.parametersBuilder.createParameter(paramDefinition);
    this.insertParameterCmp(lastPosition, parameterCmpConfig, paramDefinition);
  },

  insertParameterCmp: function (position, paramCmpConfig, paramDefinition) {
    var insertedCmp = this.insertSimpleCmp(position, paramCmpConfig);
    this.parametersBuilder.refreshLabel(this, insertedCmp, paramDefinition);

    return insertedCmp;
  },

  insertSimpleCmp: function (position, cmpConfig) {
    if (this.isRow) {
      if (position !== 0) {
        cmpConfig.margins = '0 0 0 ' + this.fieldsSpace;
      } else if (this.getParametersCount() > 0) {
        cmpConfig.margins = '0 0 0 0';
        this.items.items[0].margins = '0 0 0 ' + this.fieldsSpace;
      }
    }

    var insertedCmp = this.insert(position, cmpConfig);

    if (!this.editable) {
      insertedCmp.setDisabled(true);
    }

    return insertedCmp;
  },

  getParametersCount: function () {
    return this.items.length;
  },

  setDisabled: function (disabled) {
    this.items.each(function (item) {
      item.setDisabled(disabled);
    }, this);
  },
});
Ext.reg('st_parameterscontainer', Ext.ux.plusmpm.scheduledtasks.ParametersContainer);
