(function(Ext) {
    
    Ext.define('Suncode.datasourcemanager.component.JsonImportWindow', {
        extend: 'Ext.window.Window',
        xtype: 'jsonimportwindow',
        
        title: PW.t('datasources-import-title'),
        width: 500,
        modal: true,
        frame: false,
        layout: 'fit',

        initComponent: function () {
            this.items = [{
                xtype: 'form',
                layout: 'form',
                frame: false,
                border: false,
                bodyPadding: 10,
                defaults: {
                    labelWidth: 150
                },
                items: [{
                    xtype: 'filefield',
                    name: 'file',
                    regex: new RegExp('.json$', 'i'),
                    fieldLabel: PW.t('fileNameText'),
                    buttonText: '',
                    allowBlank: false,
                    // bez tego rozjezdza sie na IE forma
                    padding: '0px 1px 0px 0px'
                },{
                    xtype: 'checkbox',
                    name: 'overwrite',
                    fieldLabel: PW.t('Nadpisz_istniejace_zrodla_danych'),
                }]
            }];
            
            this.buttons = [{
                text: PW.t('importuj'),
                handler: this.onImportClick,
                scope: this
            }, {
                text: PW.t('cancel'),
                handler: this.close,
                scope: this
            }];
            
            this.callParent(arguments);
        },

        onImportClick: function(){
            var form = this.down('form');
            this.fireEvent('jsonimport', this, form);
        }
    });

})(Ext4);
