Ext.namespace('Ext.suncode.dashboard');

var messages = Suncode.context('dashboard').messages;

var FIX_X = window.localStorage.hasOwnProperty('dockMenu') && window.localStorage.getItem('dockMenu') === 'true' ? 280 : 68;
var GADGET_MARGIN = 20;
var HEADER_HEIGHT = 40;
var BORDER_HIDDEN_CLASS = 'border-hidden';
var HEADER_HIDDEN_CLASS = 'header-hidden';
var RESIZER_HIDDEN_CLASS = 'resizer-hidden';

Ext.suncode.dashboard.Gadget = Ext.extend(Ext.Panel, {
  settingsMenu: undefined,

  valid: true,

  contentFrame: undefined,

  xProxy: undefined,

  yProxy: undefined,
  floating: true,
  collapsible: true,
  animCollapse: false,
  autoScroll: false,
  shadow: false,

  //dzięki temu ext wykorzystany do tworzenia ciała gadżetu w iframe poprawnię się renderuje, gdy gadżet jest zwinięty
  hideMode: 'offsets',

  listeners: {
    afterrender: function (target) {
      if (!target.gadget.available) {
        target.tools.maximize.setVisible(false);
      }
      if (target.gadget.borderHidden && target.dashboard.find('itemId', 'toolbar')[0].find('id', 'edit')[0].pressed === false) {
        target.addClass(BORDER_HIDDEN_CLASS);
        target.addClass(HEADER_HIDDEN_CLASS);
      }
      if (target.dashboard.find('itemId', 'toolbar')[0].find('id', 'edit')[0].pressed === false) {
        target.dd.lock();
        target.addClass('custom-cursor');
        target.settingsMenu.find('itemId', 'autoheight')[0].setDisabled(true);
      } else {
        target.dashboard.getLayoutManager().activateResizer(target);
        if (!target.valid) {
          target.settingsMenu.find('itemId', 'autoheight')[0].setDisabled(true);
        }
      }
      target.setInitWidth();
      target.setInitHeight();

      if (target.valid) {
        target.loadGadgetContent();
      } else {
        target.settingsMenu.find('itemId', 'refresh')[0].setDisabled(true);
      }

      target.getEl().setStyle('z-index', '100');

      if (target.gadget.layout.collapsed === true) {
        target.collapse();
      }

      if (target.tools.toggle) {
        target.tools.toggle.addClass('dvnt-icon-minus-square');
      }
    },
    collapse: function (target) {
      target.tools.toggle.removeClass('dvnt-icon-minus-square');
      target.tools.toggle.addClass('dvnt-icon-plus-square');
      if (target.tools.toggle.disabled) {
        target.expand();
      } else {
        target.dashboard.getLayoutManager().recalculatePositions();
      }

      if (!Ext.isEmpty(target.gadget.gadgetProperties)) {
        target.settingsMenu.find('itemId', 'edit')[0].setDisabled(true);
      }
    },

    expand: function (target) {
      target.tools.toggle.removeClass('dvnt-icon-plus-square');
      target.tools.toggle.addClass('dvnt-icon-minus-square');

      if (target.aHeight === true) {
        target.setAutoHeight();
      }

      if (this.maximizingInProgress != true) {
        target.dashboard.getLayoutManager().recalculatePositions();
      }

      if (!Ext.isEmpty(target.gadget.gadgetProperties)) {
        target.settingsMenu.find('itemId', 'edit')[0].setDisabled(false);
      }
    },
  },
  draggable: {
    insertProxy: false,

    target: undefined,
    siblings: undefined,

    startDrag: function (x, y) {
      target = this.dragData.panel;
      comp = new Ext.Panel({
        itemId: 'emptyComponent',
        floating: true,
        bodyCfg: {
          tag: 'div',
          cls: 'target-place',
        },
      });
      var ghost = this.proxy.getEl();
      if (target.el.hasClass(BORDER_HIDDEN_CLASS)) ghost.dom.addClassName('x-panel-ghost ' + BORDER_HIDDEN_CLASS);
      comp.setSize(ghost.getWidth(), ghost.getHeight());
      comp.setPosition(ghost.getLeft(true), ghost.getTop(true));
      target.ownerCt.add(comp);
      target.ownerCt.doLayout();
      siblings = target.dashboard.getLayoutManager().getSiblings(target);
    },

    onDrag: function (e) {
      var ghost = this.proxy.getEl(),
        properX = target.dashboard.getLayoutManager().getDraggedX(ghost);

      target.dashboard.getLayoutManager().alignmentToNet(properX, target, false);
      target.dashboard.getLayoutManager().setDraggedY(target, ghost);

      if (comp.getPosition()[0] !== target.xProxy || comp.getPosition()[1] !== target.yProxy) {
        comp.setPosition(target.xProxy, target.yProxy);

        target.dashboard.getLayoutManager().setSiblingsPosition(siblings, comp);

        target.dashboard.getLayoutManager().setDashboardHeight();
      }
    },

    endDrag: function (e) {
      comp.destroy();
      target.setPosition(target.xProxy, target.yProxy > 105 ? (target.yProxy += GADGET_MARGIN) : target.yProxy);
      target.dashboard.getLayoutManager().recalculatePositions();
    },
  },

  tools: [
    {
      id: 'maximize',
      handler: function (event, toolEl, gadget) {
        if (!toolEl.disabled) {
          gadget.maximizeGadget(gadget, false);
        }
      },
    },
    {
      id: 'restore',
      hidden: true,
      handler: function (event, toolEl, gadget) {
        gadget.restoreGadget(gadget, false);
      },
    },
    {
      id: 'gear',
      qtip: 'Menu',
      handler: function (event, toolEl, gadget) {
        gadget.settingsMenu.show(toolEl);
      },
    },
  ],

  constructor: function (config) {
    this.dashboard = Ext.suncode.dashboard.Dashboard.instance;
    this.gadget = config;
    this.id = 'gadget-portlet-' + this.gadget.id;
    if (this.gadget.layout.positionX == undefined) {
      this.gadget.layout.positionX = 0;
    }
    if (this.gadget.layout.order == undefined) {
      this.gadget.layout.order = this.dashboard.gadgetArea.items.length;
    }
    if (this.gadget.layout.width == undefined) {
      this.gadget.layout.width = 4;
    }
    if (this.gadget.layout.height == undefined) {
      this.gadget.layout.height = -1;
    }
    this.title = messages('gadget.missing');

    if (this.gadget.available === false) {
      // nie znaleziono gadżetu np. wtyczka została odinstalowana
      this.valid = false;

      config = Ext.apply({
        id: this.id,
        frame: true,
        html:
          '<br/><br/><br/><br/><div id="gadgetmissing"><p style="font-size:16px;line-height:24px;">' +
          messages('gadget.missing') +
          '.</p><p style="font-size:14px;">' +
          messages('gadget.missing.contact') +
          '.</p></div>',
      });
    } else {
      this.title = this.gadget.title ? this.gadget.title : this.gadget.name;

      config = Ext.apply({
        id: this.id,
        layout: 'card',
        activeItem: 0,
        style: 'margin-right: 20px; minWidth: 5vw; minHeight: 5vw;',
        items: [
          {
            xtype: 'box',
            cls: 'gadget-content',
            ref: 'contentFrame',
            autoEl: {
              tag: 'iframe',
              frameBorder: 0,
              width: '100%',
              height: '100%',
            },
            listeners: {
              scope: this,
              afterRender: function (frame) {
                frame.getEl().on(
                  'load',
                  function (e, t, o) {
                    this.onFrameContentLoaded();

                    if (this.aHeight === true) {
                      if (this.collapsed === true) {
                        this.wasCollapsed = true;
                        this.expand();
                      } else {
                        this.wasCollapsed = false;
                      }
                      this.setAutoHeight();
                      if (this.wasCollapsed === true) {
                        this.collapse();
                      }
                    }

                    this.dashboard.getLayoutManager().recalculatePositions();

                    this.saveAudit();
                    this.dashboard.increaseGadgetsLoaded();
                  },
                  this
                );
              },
            },
          },
        ],
      });
    }
    Ext.suncode.dashboard.Gadget.superclass.constructor.call(this, config);
  },

  onFrameContentLoaded: function () {
    this.frameLoadMask.hide();
  },

  initComponent: function () {
    var gadgetArea = this.dashboard.gadgetArea;

    this.x = this.gadget.layout.positionX * gadgetArea.net + gadgetArea.getPosition()[0];

    Ext.suncode.dashboard.Gadget.superclass.initComponent.call(this);

    if (this.gadget.configurationScript) {
      this.propertiesForm = new Ext.suncode.dashboard.PropertiesForm({
        gadget: this.gadget,
        listeners: {
          scope: this,
          save: this.hidePropertiesForm,
          cancel: this.hidePropertiesForm,
        },
      });
      this.add(this.propertiesForm);
    }

    this.setupSettingsMenu();
  },

  showPropertiesForm: function (force) {
    var borderHidden = this.gadget.borderHidden;

    if (!this.propertiesForm && borderHidden) {
      this.addClass(BORDER_HIDDEN_CLASS);
      this.setHeight(this.dashboard.gadgetArea.net + GADGET_MARGIN);
      this.setWidthAfterResize();
      return;
    } else if (!this.propertiesForm) {
      return;
    }

    this.propertiesForm.forceChange = force;
    if (this.aHeight === false || borderHidden) {
      this.beforeEditHeight = this.getHeight();
      this.beforeEditWidth = this.getWidth();
    }
    this.getLayout().setActiveItem(1);
    this.dashboard.gadgetArea.doLayout();
    this.autoHeight = true;
    this.setHeight('auto');
    this.dashboard.getLayoutManager().recalculatePositions();
    this.settingsMenu.find('itemId', 'autoheight')[0].setChecked(true);

    if (borderHidden) {
      this.maximizeGadget(this, true);
      this.removeClass(HEADER_HIDDEN_CLASS);
      this.addClass(BORDER_HIDDEN_CLASS);
      this.addClass(RESIZER_HIDDEN_CLASS);
      this.dashboard.setAddGadgetAndSaveButtonDisabled(true);
    }
  },

  hidePropertiesForm: function (refresh) {
    var borderHidden = this.gadget.borderHidden;
    if (this.getLayout().activeItem !== null) {
      this.getLayout().setActiveItem(0); // pokaż gadżet
    }

    if (borderHidden && this.beforeEditHeight !== undefined && this.beforeEditWidth !== undefined) {
      this.setHeight(this.beforeEditHeight);
      this.setWidth(this.beforeEditWidth);
      this.autoHeight = false;
      this.aHeight = false;
    }

    if (this.aHeight === false) {
      this.autoHeight = false;
      this.settingsMenu.find('itemId', 'autoheight')[0].setChecked(false);
    } else if (!borderHidden) {
      this.setAutoHeight();
    }

    if (refresh) {
      this.loadGadgetContent();
    }

    if (borderHidden) {
      this.removeClass(RESIZER_HIDDEN_CLASS);
      this.restoreGadget(this, true);
      this.dashboard.setAddGadgetAndSaveButtonDisabled(false);
    } else {
      this.setWidthAfterResize();
      this.dashboard.getLayoutManager().recalculatePositions();
    }
  },

  setWidthAndHeightByNetSize: function (netWidth) {
    this.setWidth(this.dashboard.gadgetArea.net * netWidth - GADGET_MARGIN - 1);
    this.setHeight(this.dashboard.gadgetArea.net * netWidth + GADGET_MARGIN - 1);
    this.doLayout();
    this.dashboard.getLayoutManager().recalculatePositions();
  },

  beforeResizer: function (oResizable, e) {
    this.oldHeight = this.getHeight();
  },

  onResizer: function (oResizable, iWidth, iHeight, e) {
    if (this.oldHeight !== iHeight) {
      this.aHeight = false;
      this.autoHeight = false;
      this.settingsMenu.find('itemId', 'autoheight')[0].setChecked(false);

      this.setHeight(iHeight - 2);
    } else {
      if (this.aHeight === true) {
        this.setAutoHeight();
      }
    }
    this.setWidth(iWidth);
    this.dashboard.getLayoutManager().alignmentToNet(this.x, this, true);
    this.setPosition(this.xProxy, this.y);
    this.setWidthAfterResize();
    this.dashboard.getLayoutManager().recalculatePositions();
  },

  setWidthAfterResize: function () {
    var dashboard = this.ownerCt,
      net = dashboard.net,
      div = Math.floor((this.x - FIX_X + this.getWidth()) / net),
      mod = ((this.x + this.getWidth()) % net) - FIX_X;

    if (mod > net / 2) {
      div = div + 1;
    }

    this.setWidth(div * net + dashboard.getPosition()[0] - this.x - 1 - GADGET_MARGIN);

    if (this.gadget.borderHidden) this.restoreGadget(this, true, true);
  },

  setInitWidth: function () {
    var net = this.ownerCt.net,
      initWidth = this.gadget.layout.width * net - 1;

    this.setWidth(initWidth - GADGET_MARGIN);
  },

  setInitHeight: function () {
    var initHeight = this.gadget.layout.height;

    if (this.valid == false) {
      initHeight = 250;
    }

    if (initHeight === -1) {
      this.setHeight(300);
      this.aHeight = true;
      this.settingsMenu.find('itemId', 'autoheight')[0].setChecked(true);
    } else {
      this.aHeight = false;
      this.setHeight(initHeight);
    }
  },

  setAutoHeight: function () {
    if (this.gadget.borderHidden && this.gadget.layout.height === -1) return;
    //robimy to po to, żeby m.in. w Chrome dobrze odczytywało wysokosc iframe, gdy cały panel ma wysokosc większą niż oryginalna wysokosc iframe
    this.setHeight(0);
    this.doLayout();
    var frame = this.contentFrame;
    frame.setHeight('auto');

    var doc = frame.el.dom.contentDocument;

    //obejście dla gadżetu ulubione - Firefox i Edge
    var simpleTileElement = doc.body.getElementsByClassName('simpleTile')[0];

    //pobieramy wysokosc iframe, działa na wszystkich przegladarkach
    var h = Math.max(
      doc.body.scrollHeight,
      doc.documentElement.scrollHeight,
      doc.body.offsetHeight,
      doc.documentElement.offsetHeight,
      doc.body.clientHeight,
      doc.documentElement.clientHeight,
      simpleTileElement !== undefined ? simpleTileElement.scrollHeight : 0
    );

    if (doc.documentElement.scrollWidth > doc.body.scrollWidth) {
      //jest scroll poziomy
      frame.setHeight(h + 25);
    } else {
      frame.setHeight(h + 5);
    }

    this.setHeight('auto');
    this.autoHeight = false;
    this.setHeight(this.getHeight() - 4);

    if (this.getHeight() > jQuery(window).height() * 0.75) {
      //usunięte w ramach MODPLWRKFL-517
      //ucina okienko jeśli jest większe od rozmiaru ekranu
      //this.setHeight(jQuery(window).height() * 0.75);
      if (this.isMaxized && this.maximizingInProgress == false) {
        this.setWidth(this.ownerCt.getWidth());
      }
      this.doLayout();
    }
  },

  loadGadgetContent: function (params) {
    if (!this.frameLoadMask) {
      this.frameLoadMask = new Ext.LoadMask(this.body, { msg: messages('gadget.loading') });
    }
    this.frameLoadMask.show();

    // usunięcie wszystkich listenerów rezise (dodanych tlyko przez api)
    if (this.hasListener('bodyresize')) {
      this.events['bodyresize'].clearListeners();
    }

    //umożliwienie odświeżenia gadżetu z przekazaniem zdefiniowanych prametrów
    var sParams = '';
    if (params) {
      for (var i in params) {
        if (params.hasOwnProperty(i)) {
          sParams += '&' + i + '=' + params[i];
        }
      }
    }

    var url = 'ShowGadget.do?gadget=' + this.gadget.id + '&decorator=none';
    url += '&url=' + encodeURIComponent(this.gadget.url);
    url += sParams;

    this.contentFrame.getEl().set({
      src: url,
    });
  },

  setupSettingsMenu: function () {
    var gadget = this,
      menuItems = [],
      isOwner = gadget.dashboard.isOwner,
      borderHidden = gadget.gadget.borderHidden;
    // opcje edycji
    if (this.propertiesForm && isOwner) {
      menuItems.push({
        text: messages('gadget.edit'),
        itemId: 'edit',
        iconCls: 'dvnt-icon-edit column-action-item-icon',
        cls: 'column-action-item-a',
        scope: this,
        handler: this.showPropertiesForm,
      });
    }

    menuItems.push({
      text: messages('gadget.delete'),
      itemId: 'delete',
      iconCls: 'dvnt-icon-delete column-action-item-icon',
      cls: 'column-action-item-a',
      hidden: !isOwner,
      scope: this,
      handler: function () {
        this.dashboard.getLayoutManager().removeGadget(this.gadget.id, this);
      },
    });
    menuItems.push({
      text: messages('gadget.refresh'),
      itemId: 'refresh',
      iconCls: 'dvnt-icon-rotation-right column-action-item-icon',
      cls: 'column-action-item-a',
      scope: this,
      handler: function () {
        this.loadGadgetContent();
      },
    });
    menuItems.push({
      xtype: 'menucheckitem',
      itemId: 'autoheight',
      iconCls: 'column-action-item-icon',
      cls: 'column-action-item-a',
      text: messages('gadget.autoheight'),
      hidden: !isOwner || borderHidden,
      handler: function (checkbox) {
        if (checkbox.checked === false) {
          gadget.aHeight = true;
          if (gadget.items.indexOf(gadget.getLayout().activeItem) === 0) {
            gadget.setAutoHeight();
          } else {
            gadget.setHeight('auto');
          }

          gadget.dashboard.getLayoutManager().recalculatePositions();
        } else {
          gadget.aHeight = false;
          gadget.autoHeight = false;
          gadget.setHeight(gadget.getHeight());
        }
      },
      listeners: {
        afterrender: function (checkbox) {
          if (checkbox.isVisible() && gadget.autoHeight === true) {
            checkbox.setValue(true);
          }
        },
      },
    });

    this.settingsMenu = new Ext.menu.Menu({
      cls: 'column-action-icon-content',
      items: menuItems,
    });
  },

  maximizeGadget: function (gadget, borderHidden) {
    gadget.maximizingInProgress = true;
    gadget.dashboard.getLayoutManager().hideSiblings(gadget);
    if (gadget.collapsed === true) {
      gadget.wasCollapsed = true;
      gadget.expand();
    } else {
      gadget.wasCollapsed = false;
    }
    gadget.positionX = gadget.getPosition()[0];
    gadget.positionY = gadget.getPosition()[1];
    gadget.oldHeight = gadget.getHeight();
    gadget.oldWidth = gadget.getWidth();
    gadget.setPosition(gadget.ownerCt.getPosition()[0], gadget.ownerCt.getPosition()[1]);
    gadget.setWidth(gadget.ownerCt.getWidth() - GADGET_MARGIN);
    gadget.doLayout();
    window.scrollTo(0, 0);
    gadget.oldAHeight = gadget.aHeight;
    gadget.aHeight = true;
    gadget.setAutoHeight();

    gadget.tools.maximize.setVisible(false);
    gadget.tools.toggle.addClass('disabled-tool');
    gadget.tools.toggle.disabled = true;
    if (!borderHidden) gadget.tools.restore.setVisible(true);

    gadget.dashboard.find('itemId', 'toolbar')[0].find('id', 'edit')[0].setDisabled(true);
    gadget.dashboard.getLayoutManager().setDashboardHeight();
    gadget.isMaxized = true;
    gadget.maximizingInProgress = false;
  },

  restoreGadget: function (gadget, borderHidden, fromResize) {
    gadget.setPosition(gadget.positionX, gadget.positionY);
    if (this.gadget.layout.height !== -1 && !fromResize) {
      gadget.setWidth(gadget.oldWidth);
    }
    gadget.isMaxized = false;
    if (!borderHidden) {
      gadget.doLayout();
    }
    gadget.aHeight = gadget.oldAHeight;
    if (gadget.aHeight === true) {
      gadget.setAutoHeight();
    } else if (!borderHidden) {
      gadget.setHeight(gadget.oldHeight);
    }

    gadget.dashboard.getLayoutManager().showSiblings(gadget);

    gadget.tools.restore.setVisible(false);
    gadget.tools.toggle.removeClass('disabled-tool');
    gadget.tools.toggle.disabled = false;
    if (!borderHidden) gadget.tools.maximize.setVisible(true);

    if (gadget.dashboard.isOwner) {
      gadget.dashboard.find('itemId', 'toolbar')[0].find('id', 'edit')[0].setDisabled(false);
    }

    if (gadget.wasCollapsed === true) {
      gadget.collapse();
    }

    gadget.dashboard.getLayoutManager().recalculatePositions();

    // fix wysokości gadżetu bez obramowania i z możliwością edycji przed zapisaem layoutu dashboardu
    if (borderHidden && gadget.gadget.configurationScript !== null && gadget.gadget.layout.height === -1) {
      gadget.setHeight(gadget.getHeight() - 12);
    }
  },

  setProperPosition: function () {
    var position = this.getProperPosition();
    this.gadget.layout.positionX = position;
  },

  getProperPosition: function () {
    var posX = this.getPosition()[0];
    var areaPosX = this.dashboard.gadgetArea.getPosition()[0];
    var net = this.dashboard.gadgetArea.net;
    var position = Math.round((posX - areaPosX) / net);

    return position;
  },

  setProperWidth: function () {
    var width = this.getProperWidth();
    this.gadget.layout.width = width;
  },

  getProperWidth: function () {
    var width = Math.round(this.getWidth() / this.dashboard.gadgetArea.net);

    return width;
  },

  setProperHeight: function () {
    if (this.collapsed === true) {
      this.wasCollapsed = true;
      this.expand();
    } else {
      this.wasCollapsed = false;
    }
    if (this.aHeight == true) {
      this.gadget.layout.height = -1;
    } else {
      this.gadget.layout.height = this.getHeight();
    }
    if (this.wasCollapsed === true) {
      this.collapse();
    }
  },

  setOrder: function (order) {
    this.gadget.layout.order = order;
  },

  // synchronizacja definicji gadżetu
  sync: function (gadget) {
    var me = this;

    me.gadget.properties = gadget.properties;
    me.gadget.generateDate = gadget.generateDate;
  },

  saveAudit: function () {
    Ext.Ajax.request({
      scope: this,
      url: 'api/gadget/audit',
      method: 'POST',
      params: {
        gadgetId: this.gadget.id,
        started: this.gadget.generateDate,
      },
      failure: function (response, options) {
        PW.Logger.error('Audit save error status:' + response.status + ' response: ' + response.responseText);
      },
    });
  },
});

Ext.reg('dashboard-gadget', Ext.suncode.dashboard.Gadget);
