(function (Ext) {
  Ext.define('Favourites.settings.view.Editor', {
    extend: 'Ext.form.Panel',
    xtype: 'favourites-editor',
    requires: ['Favourites.settings.view.FavouriteElements'],

    layout: {
      type: 'vbox',
      align: 'stretch',
    },
    trackResetOnLoad: true,
    bodyPadding: 10,

    initComponent: function () {
      var me = this;

      Ext.apply(me, {
        items: [
          {
            xtype: 'container',
            layout: 'hbox',
            height: 80,
            defaults: {
              xtype: 'textfield',
              labelAlign: 'top',
            },
            items: [
              {
                name: 'name',
                style: 'margin-right: 10px',
                fieldLabel: Favourites.I18N.m('name'),
                allowBlank: false,
                flex: 1,
              },
              {
                name: 'description',
                fieldLabel: Favourites.I18N.m('description'),
                flex: 2,
              },
            ],
          },
          {
            xtype: 'fieldcontainer',
            fieldLabel: Favourites.I18N.m('favourites'),
            labelAlign: 'top',
            padding: '0 0 5 0',
            layout: 'fit',
            flex: 1,
            items: [
              {
                xtype: 'favourite-elementsgrid',
              },
            ],
          },
        ],
        dockedItems: [
          {
            xtype: 'toolbar',
            dock: 'bottom',
            items: [
              '->',
              {
                text: Favourites.I18N.m('save'),
                iconCls: 'dvnt-icon-save',
                handler: me.save,
                scope: me,
              },
              {
                text: Favourites.I18N.m('cancel'),
                iconCls: 'dvnt-icon-x-circle',
                handler: me.cancel,
                scope: me,
              },
            ],
          },
        ],
      });

      me.callParent(arguments);
      me.grid = me.down('favourite-elementsgrid');
    },

    edit: function (set) {
      var me = this,
        copy,
        fav;

      // stworzenie kopii rekordu
      copy = Ext.create('Favourites.model.FavouritesSet', set.getData());
      set.favourites().each(function (record) {
        fav = Ext.create('Favourites.model.Favourite', record.getData());
        copy.favourites().add(fav);
      });

      // zapis oryginału i kopii
      me.originalRecord = set;
      me.record = copy;

      // wczytanie rekordu
      me.loadRecord(copy);
      me.grid.reconfigure(copy.favourites());
    },

    save: function () {
      var me = this,
        set = me.record,
        original = me.originalRecord;

      me.updateRecord(set);
      set.save({
        success: function (updatedSet) {
          original.beginEdit();
          original.copyFrom(updatedSet);
          original.endEdit();

          PW.ui.Message.success(Favourites.I18N.m('settings.sets.saved.info'));
        },
      });
    },

    cancel: function (silent) {
      var me = this;

      if (me.isDirty()) {
        if (silent) {
          me.getForm().reset(true);
          me.grid.reset();
        } else {
          Ext.Msg.confirm(
            Favourites.I18N.m('settings.editor.cancel.confirm.title'),
            Favourites.I18N.m('settings.editor.cancel.confirm.msg'),
            function (button) {
              if (button === 'yes') {
                me.getForm().reset(true);
                me.grid.reset();
              }
            }
          );
        }
      }
    },

    isDirty: function () {
      return this.callParent(arguments) || this.grid.isDirty();
    },
  });
})(window.Ext4);
