<%@ page import="org.apache.commons.lang3.StringUtils" %>
<%@ page import="org.springframework.context.i18n.LocaleContextHolder" %>
<%@ page import="com.suncode.pwfl.experimental.Experimental" %>
<%@ page import="com.suncode.pwfl.util.SpringContext" %>
<%@ page import="com.suncode.pwfl.experimental.ExperimentalFeature" %>
<%@ taglib uri="/tags/struts-bean" prefix="bean" %>
<%@ taglib uri="/tags/struts-html" prefix="html" %>
<%@ taglib uri="/tags/struts-logic" prefix="logic" %>
<%@ taglib uri="/tags/struts-tiles" prefix="tiles" %>
<%@ taglib uri="/tags/c" prefix="c" %>
<%@page language="Java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ taglib uri="http://displaytag.sf.net" prefix="display" %>

<head>
    <jsp:include page="/pages/util/head_resources.jsp"></jsp:include>
    <script src="${pageContext.request.contextPath}/scripts/dashboard/api/gadget-api.js" type="text/javascript"></script>

    <link rel="stylesheet" href="style/ajax-tooltip.css" media="screen" type="text/css">
    <link rel="stylesheet" type="text/css" media="all" href="style/calendar-system.css" title="win2k-cold-1" />

    <!-- Skrypt do zarządzania LocalStorage. Wykorzystywany jest przez dodatek umożliwiający rozszerzanie kolumn. -->
    <script type="text/javascript" src="resources/lib/local-storage/store.min.js"></script>

    <!-- Załadowanie dodatku umożliwiającego rozszerzanie kolumn tabeli -->
    <link rel="stylesheet" type="text/css" href="resources/lib/jquery-plugins/jquery-resizable-columns/jquery.resizableColumns.css" />
    <script type="text/javascript" src="resources/lib/jquery-plugins/jquery-resizable-columns/ie8support.min.js"></script>
    <script type="text/javascript" src="resources/lib/jquery-plugins/jquery-resizable-columns/jquery.resizableColumns.min.js"></script>
    <link rel="stylesheet" type="text/css" href="resources/lib/jquery-plugins/floatingScroll/jquery.floatingscroll.css" />
    <script type="text/javascript" src="resources/lib/jquery-plugins/floatingScroll/jquery.floatingscroll.min.js"></script>

    <script type="text/javascript" src="scripts/Ajax/wz_tooltip.js"></script>
    <script type="text/javascript" src="scripts/calendar.js"></script>
    <script type="text/javascript" src="scripts/lang/calendar-<%=LocaleContextHolder.getLocale().getLanguage()%>.js"></script>
    <script type="text/javascript" src="scripts/calendar-setup.js"></script>
    <script type="text/javascript" src="scripts/searchSelectize.js"></script>
    <script type="text/javascript" src="scripts/cookies.js"></script>

    <script type="text/javascript" src="scripts/process-search-documents/preview.js"></script>
    <script type="text/javascript" src="scripts/process-search-documents/attach.js"></script>


    <%
        Experimental experimental = SpringContext.getBean( Experimental.class );
    %>

    <% if(experimental.hasFeature( ExperimentalFeature.NEW_DASHBOARD )) {%>
    <style>
        body,
        html {
            height: fit-content;
            max-height: 100vh;
        }
    </style>
    <% } %>

</head>

<div id="views-gadget"></div>

<script type="text/javascript">
  window.PW.ui.Message = top.PW.ui.Message
  window.gadgetId = '${gadgetId}'
  window.newDashboard = true
  window.isGadget = true

  <% if(!experimental.hasFeature( ExperimentalFeature.NEW_DASHBOARD )) {%>
  var gadgetObj = ${gadget};
  gadgetObj.generateDate = '${generateDate}';
  Gadget.bind({
    id: '${gadgetId}',
    gadget: gadgetObj
  });

  window.newDashboard = false
  <% } %>

  jQuery.ajax({
    url: "${pageContext.request.contextPath}/resources/js/dist/gadget/views-gadget.js",
    dataType: 'script',
    async: true
  });
</script>
