/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.support.struts;

import com.suncode.pwfl.translation.SystemTranslationService;
import com.suncode.pwfl.translation.TranslatorScope;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.web.support.struts.SpringMessageResourcesFactory;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import org.apache.struts.util.MessageResources;
import org.apache.struts.util.MessageResourcesFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;
import org.springframework.util.Assert;

public class SpringMessageResources
extends MessageResources {
    private final SystemTranslationService systemTranslationsService = (SystemTranslationService)SpringContext.getBean(SystemTranslationService.class);
    private final MessageSource messageSource;

    public SpringMessageResources(MessageSource messageSource, SpringMessageResourcesFactory factory, String config, boolean returnNull) {
        super((MessageResourcesFactory)factory, config, returnNull);
        Assert.notNull((Object)messageSource);
        this.messageSource = messageSource;
    }

    public String getMessage(Locale locale, String key) {
        return this.getMessage(locale, key, new Object[0]);
    }

    public String getMessage(Locale locale, String key, Object[] args) {
        Locale finalLocale = locale != null ? locale : this.defaultLocale;
        String formatKey = this.messageKey(finalLocale, key);
        return this.systemTranslationsService.findTranslation("plusworkflow", key, finalLocale, TranslatorScope.SERVER).map(translationEntry -> {
            String fixedTranslation = this.fixValue(translationEntry.getValue());
            MessageFormat translationFormat = new MessageFormat(this.escape(fixedTranslation));
            return translationFormat.format(args);
        }).orElseGet(() -> {
            MessageFormat format;
            HashMap hashMap = this.formats;
            synchronized (hashMap) {
                format = (MessageFormat)this.formats.get(formatKey);
                if (format == null) {
                    String formatString = this.getInternalFormat(finalLocale, key);
                    if (formatString == null) {
                        if (this.returnNull) {
                            return null;
                        }
                        return "???" + formatKey + "???";
                    }
                    format = new MessageFormat(this.escape(formatString));
                    this.formats.put(formatKey, format);
                }
            }
            return format.format(args);
        });
    }

    private String getInternalFormat(Locale locale, String key) {
        try {
            String msg = this.messageSource.getMessage(key, null, locale);
            return msg != null ? this.fixValue(msg) : "";
        }
        catch (NoSuchMessageException e) {
            return null;
        }
    }

    private String fixValue(String value) {
        return value.replace("'", "&#39").replace("\"", "&#34");
    }
}

