/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.support;

import com.suncode.pwfl.archive.DocumentClassIndex;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.IndexPattern;
import com.suncode.pwfl.archive.IndexType;
import com.suncode.pwfl.translation.configElements.TranslatedFieldType;
import com.suncode.pwfl.web.dto.archive.DocumentClassIndexDto;
import com.suncode.pwfl.web.dto.archive.DocumentClassIndexPatternDto;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DocumentClassIndexMapper {
    @Autowired
    private DocumentClassService documentClassService;

    public DocumentClassIndex toEntity(DocumentClassIndexDto documentClassIndexDto) {
        String description = documentClassIndexDto.getDescription() != null ? documentClassIndexDto.getDescription().trim() : "";
        List<Object> patterns = new LinkedList();
        if (documentClassIndexDto.getIndexPatterns() != null) {
            patterns = documentClassIndexDto.getIndexPatterns().stream().map(pattern -> IndexPattern.builder().id(pattern.getId()).pattern(pattern.getPattern()).replacement(pattern.getReplace()).isRegex(pattern.getIsRegex()).build()).collect(Collectors.toList());
        }
        String values = documentClassIndexDto.getValues() == null || documentClassIndexDto.getValues().isEmpty() ? null : StringUtils.join(documentClassIndexDto.getValues(), (String)"\n");
        DocumentClassIndex entity = DocumentClassIndex.builder().id(documentClassIndexDto.getId()).name(documentClassIndexDto.getName().trim()).description(description).type(IndexType.getType((String)documentClassIndexDto.getType())).orderId(documentClassIndexDto.getOrderId()).values(values).patterns(patterns).build();
        patterns.forEach(pattern -> pattern.setIndex(entity));
        return entity;
    }

    public DocumentClassIndexDto toDocumentClassIndexDto(DocumentClassIndex entity) {
        String translatedName = StringUtils.isNotBlank((CharSequence)entity.getTranslatedName()) ? entity.getTranslatedName() : this.documentClassService.getDocumentClassIndexTranslation(entity.getId(), TranslatedFieldType.NAME);
        String translatedDescription = StringUtils.isNotBlank((CharSequence)entity.getTranslatedDescription()) ? entity.getTranslatedDescription() : this.documentClassService.getDocumentClassIndexTranslation(entity.getId(), TranslatedFieldType.DESCRIPTION);
        List<DocumentClassIndexPatternDto> patternsDto = entity.getPatterns().stream().map(pattern -> DocumentClassIndexPatternDto.builder().id(pattern.getId()).pattern(pattern.getPattern()).replace(pattern.getReplacement()).isRegex(pattern.getIsRegex()).build()).collect(Collectors.toList());
        LinkedList<String> values = new LinkedList();
        if (entity.getValues() != null) {
            values = Arrays.asList(entity.getValues().split("\n"));
        }
        return DocumentClassIndexDto.builder().id(entity.getId()).name(entity.getName()).translatedName(translatedName).description(entity.getDescription()).translatedDescription(translatedDescription).type(entity.getType().toString()).orderId(entity.getOrderId()).indexPatterns(patternsDto).values(values).build();
    }
}

