/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.security.internal;

import com.plusmpm.security.WorkflowPrincipal;
import com.plusmpm.security.authentication.AbstractAuthenticator;
import com.plusmpm.security.authentication.Authenticator;
import com.plusmpm.security.authentication.AuthenticatorFactory;
import com.suncode.pwfl.administration.user.Domain;
import com.suncode.pwfl.administration.user.DomainService;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.administration.user.security.PasswordPolicyProfile;
import com.suncode.pwfl.administration.user.security.captcha.service.CaptchaService;
import com.suncode.pwfl.administration.user.security.service.BlockedUserService;
import com.suncode.pwfl.administration.user.security.service.PasswordPolicyResolverService;
import com.suncode.pwfl.administration.user.security.service.SelfUnblockUserService;
import com.suncode.pwfl.administration.user.security.service.UserPasswordHistoryService;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.license.LicenseVerificator;
import com.suncode.pwfl.license.exceptions.NextSessionNotAllowedException;
import com.suncode.pwfl.web.security.UserAuthorization;
import com.suncode.pwfl.web.security.UserAuthorizationResult;
import com.suncode.pwfl.web.security.exception.BlockedUserException;
import com.suncode.pwfl.web.security.exception.CaptchaRequiredException;
import com.suncode.pwfl.web.security.exception.ChangePasswordRequiredException;
import com.suncode.pwfl.web.security.exception.PasswordExpiredException;
import com.suncode.pwfl.web.security.exception.PasswordProfileRequirementsException;
import com.suncode.pwfl.web.security.exception.UserAuthorizationException;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserAuthorizationImpl
implements UserAuthorization {
    private static final Logger log = LoggerFactory.getLogger(UserAuthorizationImpl.class);
    @Autowired
    private UserService userService;
    @Autowired
    private DomainService ds;
    @Autowired
    private CaptchaService captchaService;
    @Autowired
    private BlockedUserService blockedUserService;
    @Autowired
    private PasswordPolicyResolverService passwordProfileResolver;
    @Autowired
    private SelfUnblockUserService selfUnblockUserService;
    @Autowired
    private UserPasswordHistoryService passwordHistoryService;

    @Override
    public String authorizeUser(String userName, String password, HttpSession session) {
        return this.authorizeUser(userName, password, null, session);
    }

    @Override
    public String authorizeUser(String userName, String password, Long domainId, HttpSession session) {
        return this.authorizeUser(userName, password, domainId, session, false);
    }

    @Override
    public String authorizeUser(String userName, String password, Long domainId, HttpSession session, boolean rest) {
        return this.authorizeUserWithMetaResult(userName, password, domainId, session, rest, false).getUserId();
    }

    @Override
    public UserAuthorizationResult authorizeUserWithMetaResult(String userName, String password, Long domainId, HttpSession session, boolean rest, boolean isMobile) {
        return this.authorizeUserWithMetaResult(userName, password, domainId, session, null, rest, isMobile);
    }

    @Override
    public UserAuthorizationResult authorizeUserWithMetaResult(String userName, String password, Long domainId, HttpServletRequest request, boolean rest, boolean isMobile) {
        return this.authorizeUserWithMetaResult(userName, password, domainId, null, request, rest, isMobile);
    }

    private UserAuthorizationResult authorizeUserWithMetaResult(String userName, String password, Long domainId, HttpSession session, HttpServletRequest request, boolean rest, boolean isMobile) {
        AbstractAuthenticator.InternalAuthenticationResult authenticationResult;
        WorkflowPrincipal principal;
        String licenseValidationMessage;
        boolean licenseValidationError;
        String userId = this.getUserId(userName, domainId);
        if (session == null && request == null) {
            throw new IllegalArgumentException(MessageHelper.getMessage((String)"Wymagany_parametr_sesji_lub_zapytania"));
        }
        if (request != null) {
            session = request.getSession();
        }
        if ((licenseValidationError = StringUtils.isNotEmpty((CharSequence)(licenseValidationMessage = LicenseVerificator.validateOnLogin()))) && !userId.equals("admin")) {
            String msg = MessageHelper.getMessage((String)"Wystapil_problem_z_licencja_systemu") + ". " + MessageHelper.getMessage((String)"Skontaktuj_sie_z_administratorem_systemu") + ".";
            log.warn("Wyst\u0105pi\u0142 problem z licencj\u0105 systemu: {}", (Object)licenseValidationMessage);
            return new UserAuthorizationResult(msg, null);
        }
        if (!LicenseVerificator.isNextSessionAllowed()) {
            NextSessionNotAllowedException exception = new NextSessionNotAllowedException();
            log.info(exception.getMessageTranslated());
            log.warn("Limit zalogowanych u\u017cytkownik\u00f3w wykorzystany.");
            return new UserAuthorizationResult(exception.getMessageTranslated(), null);
        }
        if (domainId == null) {
            principal = new WorkflowPrincipal(userName, password);
        } else {
            Domain domain = this.ds.getDomain(domainId);
            principal = new WorkflowPrincipal(userName, password, domain.getId().toString(), domain.getDomainName());
        }
        principal.setMobile(isMobile);
        Authenticator authenticator = AuthenticatorFactory.getAuthenticator((WorkflowPrincipal)principal, (HttpSession)session);
        if (domainId == null) {
            if (this.captchaService.requireCaptcha(session)) {
                String msg = "Captcha is required for current session";
                log.info(msg);
                throw new CaptchaRequiredException(msg);
            }
            if (this.captchaService.requireCaptcha(userId)) {
                String msg = "Captcha is required for user " + userId;
                log.info(msg);
                throw new CaptchaRequiredException(msg);
            }
            User user = this.userService.getUser(userId, new String[]{"groups"});
            if (user != null) {
                if (user.isOnlySsoLogin()) {
                    log.error("User " + user.getUserName() + " can only log in using SSO login");
                    throw new UserAuthorizationException();
                }
                Optional optionalProfile = this.passwordProfileResolver.getForUser(user);
                log.info("Checking if user {} is blocked", (Object)userId);
                if (this.blockedUserService.isUserBlocked(user)) {
                    String msg = "User " + userId + " is blocked";
                    log.warn(msg);
                    if (((PasswordPolicyProfile)optionalProfile.get()).getSendUnblockingEmail().booleanValue() || userId.equals("admin")) {
                        new Thread(() -> {
                            try {
                                this.selfUnblockUserService.sendSelfUnblockEmail(user);
                            }
                            catch (Exception ex) {
                                log.error("Error while sending self unblock email to user " + userId, (Throwable)ex);
                            }
                        }).start();
                    }
                    throw new BlockedUserException(msg);
                }
                if (optionalProfile.isPresent()) {
                    PasswordPolicyProfile passwordProfile = (PasswordPolicyProfile)optionalProfile.get();
                    if (user.getPassword().equals(this.userService.hashPassword(password))) {
                        if (!this.passwordHistoryService.findLast(user.getObjectId()).isPresent() && passwordProfile.getForcePassChange().booleanValue()) {
                            String msg = "This is the first login for the user " + userId + ". The password must be changed when logging in for the first time";
                            log.warn(msg);
                            session.setAttribute("changePasswordUser", (Object)userId);
                            throw new ChangePasswordRequiredException(msg);
                        }
                        log.info("Checking requirements with current password for user {}", (Object)userId);
                        try {
                            this.passwordProfileResolver.validatePasswordFulfillingRequirements(passwordProfile, password);
                        }
                        catch (IllegalArgumentException ex) {
                            String msg = "Current password for user " + userId + " is not fulfilling password profile requirements";
                            log.warn(msg);
                            session.setAttribute("changePasswordUser", (Object)userId);
                            throw new PasswordProfileRequirementsException(msg);
                        }
                    }
                    log.info("Checking password expiration for user {}", (Object)userId);
                    if (this.passwordHistoryService.hasExpiredPassword(passwordProfile, user)) {
                        String msg = "User " + userId + " has expired password";
                        log.warn(msg);
                        session.setAttribute("changePasswordUser", (Object)userId);
                        throw new PasswordExpiredException(msg);
                    }
                }
            } else {
                log.warn("User {} not found", (Object)userId);
                throw new UserAuthorizationException();
            }
        }
        if ((authenticationResult = authenticator.authenticate()).authenticated()) {
            HttpSession httpSession = session = request != null ? authenticationResult.registrateInSession(request) : authenticationResult.registrateInSession();
            if (domainId == null) {
                this.blockedUserService.invalidateFailedLogins(userId);
                this.captchaService.invalidateFailedLogins(session.getId(), userId, rest);
            }
            log.info("Uwierzytelnienie u\u017cytkownika: " + userName + " w domenie: " + domainId + " powiod\u0142o si\u0119.");
            return new UserAuthorizationResult(userId, authenticationResult.getAuthenticationMethod());
        }
        if (domainId == null) {
            this.blockedUserService.registerFailedLoginAttempt(userId);
            this.captchaService.registerFailedLoginAttempt(session.getId(), userId, rest);
        }
        log.warn("Uwierzytelnienie u\u017cytkownika: " + userName + " w domenie: " + domainId + " nie powiod\u0142o si\u0119.");
        throw new UserAuthorizationException(authenticationResult.getAuthenticationMethod());
    }

    public String getUserId(String userName, Long domainId) {
        if (domainId == null) {
            return userName;
        }
        Domain domain = this.ds.getDomain(domainId);
        return domain.getDomainName() + "/" + userName;
    }
}

