/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.gadget.lastActivity;

import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.audit.AuditCoreService;
import com.suncode.pwfl.audit.FilterConfigCore;
import com.suncode.pwfl.audit.detailName.AuditDetailNameService;
import com.suncode.pwfl.dashboard.internal.gadget.lastActivity.LastActivityAuditBlacklist;
import com.suncode.pwfl.dashboard.internal.gadget.lastActivity.LastActivityDto;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.SortDirection;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/lastActivity"})
public class LastActivityController {
    @Autowired
    private AuditCoreService auditCoreService;
    @Autowired
    private AuditDetailNameService auditDetailNameService;

    @ResponseBody
    @RequestMapping(value={"/audits"}, method={RequestMethod.GET})
    public List<LastActivityDto> getAudits(@RequestParam(required=false, defaultValue="7") Integer periodDays, @RequestParam(required=false, defaultValue="10000") Integer limit) {
        FilterConfigCore filterConfigCore = FilterConfigCore.builder().userId(UserContext.current().getUser().getUserName()).auditTypesBlackList(true).auditTypes(LastActivityAuditBlacklist.BLACKLISTED_AUDITS).auditSuccess(Boolean.valueOf(true)).auditStartedFrom(Instant.now().minus(periodDays.intValue(), ChronoUnit.DAYS).toEpochMilli()).build();
        CountedResult auditDtoCoreCountedResult = this.auditCoreService.getAudits(filterConfigCore, Integer.valueOf(0), limit, "auditStarted", SortDirection.DESC);
        return auditDtoCoreCountedResult.getData().stream().map(audit -> LastActivityDto.builder().name(this.auditDetailNameService.getAuditDetailName(audit)).date(new Date(audit.getAuditStarted())).build()).collect(Collectors.toList());
    }
}

