/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.certificates.fetchers;

import com.suncode.pwfl.certificates.exceptions.CertificateScanException;
import com.suncode.pwfl.web.controller.api.certificates.fetchers.CertificateFetcherBase;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.io.IOUtils;

public class CertificateFetcherSimple
extends CertificateFetcherBase {
    public CertificateFetcherSimple(String host, int port) {
        super(host, port);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Certificate[] tryFetch(int timeout) {
        Certificate[] certificateArray;
        SSLSocket sslSocket = null;
        try {
            SSLSocketFactory ssf = this.getInsecureSocketFactory();
            sslSocket = (SSLSocket)ssf.createSocket();
            sslSocket.connect(new InetSocketAddress(this.host, this.port), timeout);
            sslSocket.setSoTimeout(timeout);
            sslSocket.startHandshake();
            certificateArray = sslSocket.getSession().getPeerCertificates();
        }
        catch (KeyManagementException e) {
            try {
                throw new CertificateScanException("Could not create SSL socket", (Throwable)e);
                catch (NoSuchAlgorithmException e2) {
                    throw new CertificateScanException("Unknown secure algorithm", (Throwable)e2);
                }
                catch (SocketTimeoutException e3) {
                    throw new CertificateScanException("Target host is unreachable", (Throwable)e3);
                }
                catch (IOException e4) {
                    throw new CertificateScanException("Error occurred during estabilishing connection", (Throwable)e4);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(sslSocket);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Socket)sslSocket);
        return certificateArray;
    }
}

