/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.administration.user.security;

import com.suncode.pwfl.administration.user.UserGroup;
import com.suncode.pwfl.administration.user.UserGroupFinder;
import com.suncode.pwfl.administration.user.security.DefaultPasswordPolicyProfile;
import com.suncode.pwfl.administration.user.security.PasswordPolicyProfile;
import com.suncode.pwfl.administration.user.security.domain.GlobalPasswordPolicyProfile;
import com.suncode.pwfl.administration.user.security.domain.UserPasswordPolicyProfile;
import com.suncode.pwfl.administration.user.security.service.PasswordPolicyService;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.transaction.TransactionManagerFactory;
import com.suncode.pwfl.web.controller.api.administration.user.security.PasswordPolicyProfileAssignmentsDto;
import com.suncode.pwfl.web.controller.api.administration.user.security.ProfileAssignmentDto;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.security.exception.NotFullRightsException;
import com.suncode.pwfl.web.support.ajax.RestResult;
import java.beans.ConstructorProperties;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"password/policy"})
public class PasswordPolicyAssignmentsController {
    private static final Logger log = LoggerFactory.getLogger(PasswordPolicyAssignmentsController.class);
    private final PasswordPolicyService passwordPolicyService;
    private final UserGroupFinder groupFinder;
    private final AuthorizationHelper authorizationHelper;
    private final MessageHelperBean messageHelper;

    @ResponseBody
    @RequestMapping(value={"assignments/global"}, method={RequestMethod.GET})
    public ProfileAssignmentDto getGlobalAssignment() {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        GlobalPasswordPolicyProfile globalProfile = this.passwordPolicyService.getGlobalProfile();
        ProfileAssignmentDto result = new ProfileAssignmentDto();
        if (globalProfile != null) {
            if (globalProfile.getDefaultProfile() != null) {
                result.setDefaultProfile(true);
                result.setProfileKey(globalProfile.getDefaultProfile().getProfile().getProfileKey());
                result.setProfileName(globalProfile.getDefaultProfile().getProfile().getName());
            } else {
                result.setProfileId(globalProfile.getUserProfile().getId());
                result.setProfileName(PasswordPolicyProfile.getName((long)globalProfile.getUserProfile().getId()));
            }
        } else {
            result.setNotAssigned(true);
        }
        return result;
    }

    @ResponseBody
    @RequestMapping(value={"assignments"}, method={RequestMethod.GET})
    public List<ProfileAssignmentDto> getAllAssignments() {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        List<ProfileAssignmentDto> assignmentsListDto = this.getUserAndDefaultProfileAssignments();
        this.fillGroups(assignmentsListDto);
        assignmentsListDto.sort(Comparator.comparingLong(ProfileAssignmentDto::getGroupId));
        return assignmentsListDto;
    }

    public void fillGroups(List<ProfileAssignmentDto> assignmentsListDto) {
        this.groupFinder.getAll(new String[0]).forEach(group -> {
            Optional<ProfileAssignmentDto> foundAssignment = assignmentsListDto.stream().filter(assignment -> assignment.getGroupId().equals(group.getObjectId())).findFirst();
            if (!foundAssignment.isPresent()) {
                assignmentsListDto.add(ProfileAssignmentDto.builder().groupId(group.getObjectId()).groupName(group.getName()).build());
            }
        });
    }

    private List<ProfileAssignmentDto> getUserAndDefaultProfileAssignments() {
        List userProfilesAssignments = this.passwordPolicyService.getAllUserAssignments();
        List defaultAssignments = this.passwordPolicyService.getAllDefaultAssignments();
        LinkedList<ProfileAssignmentDto> result = new LinkedList<ProfileAssignmentDto>();
        result.addAll(userProfilesAssignments.stream().map(assignmentEntity -> {
            Long id = assignmentEntity.getId();
            UserGroup group = assignmentEntity.getGroup();
            UserPasswordPolicyProfile policyProfile = assignmentEntity.getUserProfile();
            return ProfileAssignmentDto.builder().id(id).defaultProfile(false).profileName(PasswordPolicyProfile.getName((long)policyProfile.getId())).groupId(group.getObjectId()).groupName(group.getName()).profileId(policyProfile.getId()).profileKey(policyProfile.getProfileKey()).build();
        }).collect(Collectors.toList()));
        result.addAll(defaultAssignments.stream().map(defaultAssignmentEntity -> {
            Long id = defaultAssignmentEntity.getId();
            UserGroup group = defaultAssignmentEntity.getGroup();
            DefaultPasswordPolicyProfile defaultProfile = defaultAssignmentEntity.getDefaultProfile();
            return ProfileAssignmentDto.builder().id(id).defaultProfile(true).profileName(defaultProfile.getProfile().getName()).groupId(group.getObjectId()).groupName(group.getName()).profileKey(defaultProfile.getProfile().getProfileKey()).build();
        }).collect(Collectors.toList()));
        return result;
    }

    @ResponseStatus(value=HttpStatus.OK)
    @RequestMapping(value={"assignments/update"}, method={RequestMethod.POST})
    public void updateAssignments(HttpServletRequest request, final @RequestBody PasswordPolicyProfileAssignmentsDto profileAssignments) {
        AuditBuilder profilesAssignedAudit = AuditBuilder.getInstance().type(AuditTypes.AUDIT_PASSWORD_PROFILES_ASSIGNED).params(profileAssignments.getAuditParams());
        this.authorizationHelper.assertFullAdministrationRights(() -> profilesAssignedAudit.buildFailure(request));
        try {
            TransactionTemplate template = new TransactionTemplate(TransactionManagerFactory.getHibernateTransactionManager());
            template.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus arg0) {
                    PasswordPolicyAssignmentsController.this.updateGroupsAssignments(profileAssignments.getGroupsAssignment());
                    PasswordPolicyAssignmentsController.this.updateGlobalAssignment(profileAssignments.getGlobalProfile());
                }
            });
            request.setAttribute("audit", (Object)profilesAssignedAudit.success(true).build());
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            request.setAttribute("audit", (Object)profilesAssignedAudit.success(false).build());
            throw ex;
        }
    }

    private void updateGroupsAssignments(List<ProfileAssignmentDto> groupsAssignments) {
        groupsAssignments.stream().filter(ProfileAssignmentDto::getNotAssigned).forEach(assignment -> this.passwordPolicyService.removeProfileForGroup(assignment.getGroupId()));
        groupsAssignments.stream().filter(assignment -> assignment.getNotAssigned() == false).filter(ProfileAssignmentDto::getDefaultProfile).forEach(assignment -> this.passwordPolicyService.assignDefaultProfileForGroup(assignment.getGroupId(), DefaultPasswordPolicyProfile.valueOf((String)assignment.getProfileKey())));
        groupsAssignments.stream().filter(assignment -> assignment.getNotAssigned() == false).filter(assignment -> assignment.getDefaultProfile() == false).forEach(assignment -> this.passwordPolicyService.assignUserProfileForGroup(assignment.getGroupId(), assignment.getProfileId()));
    }

    private void updateGlobalAssignment(ProfileAssignmentDto global) {
        if (global.getNotAssigned().booleanValue()) {
            this.passwordPolicyService.removeGlobalProfile();
        } else {
            DefaultPasswordPolicyProfile defaultProfile = null;
            UserPasswordPolicyProfile userProfile = null;
            if (global.getDefaultProfile().booleanValue()) {
                defaultProfile = DefaultPasswordPolicyProfile.valueOf((String)global.getProfileKey());
            } else {
                userProfile = this.passwordPolicyService.get(global.getProfileId());
            }
            this.passwordPolicyService.assignGlobalProfile(defaultProfile, userProfile);
        }
    }

    @ExceptionHandler(value={NotFullRightsException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public RestResult handleNotFullRightsException(NotFullRightsException e) {
        log.info(this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
        return new RestResult(false, this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
    }

    @ConstructorProperties(value={"passwordPolicyService", "groupFinder", "authorizationHelper", "messageHelper"})
    @Autowired
    public PasswordPolicyAssignmentsController(PasswordPolicyService passwordPolicyService, UserGroupFinder groupFinder, AuthorizationHelper authorizationHelper, MessageHelperBean messageHelper) {
        this.passwordPolicyService = passwordPolicyService;
        this.groupFinder = groupFinder;
        this.authorizationHelper = authorizationHelper;
        this.messageHelper = messageHelper;
    }
}

