/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.administration.user;

import com.plusmpm.struts.action.ShowGetsUsersAction;
import com.plusmpm.util.UserInfo;
import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.administration.structure.OrganizationalUnit;
import com.suncode.pwfl.administration.structure.OrganizationalUnitFinder;
import com.suncode.pwfl.administration.substitution.SubstitutionHook;
import com.suncode.pwfl.administration.user.UserFinder;
import com.suncode.pwfl.hook.HookRegistry;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.util.DtoComparator;
import com.suncode.pwfl.util.Paginator;
import com.suncode.pwfl.web.controller.api.administration.user.UserQueryParameters;
import com.suncode.pwfl.web.dto.administration.user.BasicUserInfoDto;
import com.suncode.pwfl.web.support.UserCriteriaHelper;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.hibernate.Criteria;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SubstituteFinder {
    private static final Logger log = LoggerFactory.getLogger(SubstituteFinder.class);
    @Autowired
    private HookRegistry hookRegistry;
    @Autowired
    private UserFinder userFinder;
    @Autowired
    private UserCriteriaHelper userCriteriaHelper;
    @Autowired
    private OrganizationalUnitFinder organizationalUnitFinder;

    public CountedResult<BasicUserInfoDto> findSubstitutesForUser(UserQueryParameters userQueryParameters, String username, String substitutedUsername, int start, int limit, String sortBy, SortDirection sortDirection) {
        List users = ((SubstitutionHook)this.hookRegistry.invoke(SubstitutionHook.class)).getSubstitutes(username, substitutedUsername);
        if (users != null) {
            List userInfoDtos = users.stream().map(BasicUserInfoDto::fromEntity).filter(user -> this.userMatchesQueryParameters((BasicUserInfoDto)user, userQueryParameters) && !user.getUserName().equals(substitutedUsername)).sorted((Comparator<BasicUserInfoDto>)DtoComparator.of(BasicUserInfoDto.class, (String)sortBy, (SortDirection)sortDirection).withIgnoreCase(true)).collect(Collectors.toList());
            return Paginator.forAll(userInfoDtos).viewPageByOffset(Integer.valueOf(start), Integer.valueOf(limit));
        }
        String userListType = SystemProperties.getString((DefinedSystemParameter)DefinedSystemParameter.DELEGATION_USERLISTTYPE);
        ArrayList<UserInfo> userInfos = ShowGetsUsersAction.getDelegationUserList(null, username, substitutedUsername, null, userListType);
        if (userInfos != null) {
            List infoDtos = userInfos.stream().map(userInfo -> BasicUserInfoDto.builder().userName(userInfo.getM_sUserName()).firstName(userInfo.getM_sUserFirstName()).lastName(userInfo.getM_sUserLastName()).build()).filter(user -> this.userMatchesQueryParameters((BasicUserInfoDto)user, userQueryParameters) && !user.getUserName().equals(substitutedUsername)).sorted((Comparator<BasicUserInfoDto>)DtoComparator.of(BasicUserInfoDto.class, (String)sortBy, (SortDirection)sortDirection).withIgnoreCase(true)).collect(Collectors.toList());
            return Paginator.forAll(infoDtos).viewPageByOffset(Integer.valueOf(start), Integer.valueOf(limit));
        }
        if (userListType.equalsIgnoreCase("ouUsers")) {
            return this.getSameOrganizationalUnitUsers(userQueryParameters, substitutedUsername, sortBy, sortDirection, start, limit);
        }
        return this.getFilteredUsers(userQueryParameters, substitutedUsername, start, limit, sortBy, sortDirection);
    }

    private boolean userMatchesQueryParameters(BasicUserInfoDto user, UserQueryParameters userQueryParameters) {
        String query = userQueryParameters.getQuery().trim().toLowerCase();
        String firstNameQuery = userQueryParameters.getFirstNameQuery().trim().toLowerCase();
        String lastNameQuery = userQueryParameters.getLastNameQuery().trim().toLowerCase();
        if (query.isEmpty() && firstNameQuery.isEmpty() && lastNameQuery.isEmpty()) {
            return true;
        }
        return !query.isEmpty() && user.getUserName().trim().toLowerCase().contains(query) || !firstNameQuery.isEmpty() && user.getFirstName().trim().toLowerCase().contains(firstNameQuery) || !lastNameQuery.isEmpty() && user.getLastName().trim().toLowerCase().contains(lastNameQuery);
    }

    private CountedResult<BasicUserInfoDto> getSameOrganizationalUnitUsers(UserQueryParameters userQueryParameters, String substitutedUsername, String sortBy, SortDirection sortDirection, int start, int limit) {
        List organizationalUnits = this.organizationalUnitFinder.findByUserName(substitutedUsername, new String[0]).stream().map(OrganizationalUnit::getId).collect(Collectors.toList());
        if (organizationalUnits.isEmpty()) {
            return new CountedResult(0L, new ArrayList());
        }
        DetachedCriteria countCriteria = this.userCriteriaHelper.createQueryCriteria(userQueryParameters.getQuery(), userQueryParameters.getFirstNameQuery(), userQueryParameters.getLastNameQuery());
        countCriteria.add(Restrictions.neOrIsNotNull((String)"userName", (Object)substitutedUsername));
        countCriteria.createAlias("positions", "positions");
        countCriteria.createAlias("positions.organizationalUnit", "positions.organizationalUnit");
        countCriteria.add(Restrictions.in((String)"positions.organizationalUnit.id", organizationalUnits));
        countCriteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        long total = this.userFinder.count(countCriteria);
        DetachedCriteria queryCriteria = this.userCriteriaHelper.createQueryCriteria(userQueryParameters.getQuery(), userQueryParameters.getFirstNameQuery(), userQueryParameters.getLastNameQuery());
        queryCriteria.add(Restrictions.neOrIsNotNull((String)"userName", (Object)substitutedUsername));
        queryCriteria.createAlias("positions", "positions");
        queryCriteria.createAlias("positions.organizationalUnit", "positions.organizationalUnit");
        queryCriteria.add(Restrictions.in((String)"positions.organizationalUnit.id", organizationalUnits));
        queryCriteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        queryCriteria.addOrder(sortDirection == SortDirection.ASC ? Order.asc((String)sortBy) : Order.desc((String)sortBy));
        List foundUsers = this.userFinder.findByCriteria(queryCriteria, Integer.valueOf(start), Integer.valueOf(limit)).stream().map(BasicUserInfoDto::fromEntity).collect(Collectors.toList());
        return new CountedResult(total, foundUsers);
    }

    private CountedResult<BasicUserInfoDto> getFilteredUsers(UserQueryParameters userQueryParameters, String substitutedUsername, int start, int limit, String sortBy, SortDirection sortDirection) {
        DetachedCriteria countCriteria = this.userCriteriaHelper.createQueryCriteria(userQueryParameters.getQuery(), userQueryParameters.getFirstNameQuery(), userQueryParameters.getLastNameQuery());
        countCriteria.add(Restrictions.neOrIsNotNull((String)"userName", (Object)substitutedUsername));
        long total = this.userFinder.count(countCriteria);
        DetachedCriteria queryCriteria = this.userCriteriaHelper.createQueryCriteria(userQueryParameters.getQuery(), userQueryParameters.getFirstNameQuery(), userQueryParameters.getLastNameQuery());
        queryCriteria.add(Restrictions.neOrIsNotNull((String)"userName", (Object)substitutedUsername));
        queryCriteria.addOrder(sortDirection == SortDirection.ASC ? Order.asc((String)sortBy) : Order.desc((String)sortBy));
        List foundUsers = this.userFinder.findByCriteria(queryCriteria, Integer.valueOf(start), Integer.valueOf(limit)).stream().map(BasicUserInfoDto::fromEntity).collect(Collectors.toList());
        return new CountedResult(total, foundUsers);
    }
}

