/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.administration.position;

import com.google.common.collect.ImmutableMap;
import com.suncode.pwfl.administration.structure.RoleFinder;
import com.suncode.pwfl.administration.structure.RoleService;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.export.extension.ExportExtension;
import com.suncode.pwfl.export.model.ExportColumn;
import com.suncode.pwfl.export.model.ExportColumnBuilder;
import com.suncode.pwfl.export.model.ExportModel;
import com.suncode.pwfl.export.service.ExportService;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.util.DtoComparator;
import com.suncode.pwfl.util.Paginator;
import com.suncode.pwfl.web.dto.administration.RoleDto;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.security.exception.NotFullRightsException;
import com.suncode.pwfl.web.support.ajax.RestResult;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.management.relation.RoleNotFoundException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"roles"})
public class RoleController {
    private static final Logger log = LoggerFactory.getLogger(RoleController.class);
    private final RoleFinder roleFinder;
    private final ExportService exportService;
    private final RoleService roleService;
    private final AuthorizationHelper authorizationHelper;
    private final MessageHelperBean messageHelper;

    @ResponseBody
    @RequestMapping(value={"all"})
    public List<RoleDto> getAll() {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        return this.roleFinder.getAll(new String[0]).stream().map(RoleDto::fromDomain).collect(Collectors.toList());
    }

    @ResponseBody
    @RequestMapping(value={"query"})
    public CountedResult<RoleDto> getRoles(@RequestParam(required=false) String name, @RequestParam(required=false) String packageId, @RequestParam(required=false) String processDefId, @RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit, @RequestParam(required=false, defaultValue="roleName") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        List roleDtos = this.roleFinder.findRoles(name, packageId, processDefId).stream().map(RoleDto::translatedFromDomain).sorted((Comparator<RoleDto>)DtoComparator.of(RoleDto.class, (String)sortBy, (SortDirection)sortDirection)).collect(Collectors.toList());
        return Paginator.forAll(roleDtos).viewPageByOffset(start, limit);
    }

    @ResponseBody
    @RequestMapping(value={"position/{id}"})
    public CountedResult<RoleDto> getRolesForPosition(@PathVariable Long id, @RequestParam(required=false, defaultValue="roleName") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        List roles = this.roleService.getRolesForPosition(id, sortBy, sortDirection).stream().map(RoleDto::translatedFromDomain).collect(Collectors.toList());
        return new CountedResult((long)roles.size(), roles);
    }

    @RequestMapping(value={"export/{extension}"}, method={RequestMethod.GET})
    public void export(HttpServletResponse response, @RequestParam Long id, @PathVariable String extension, @RequestParam(required=false, defaultValue="roleName") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) throws IOException {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        List<RoleDto> roles = this.roleService.getRolesForPosition(id, sortBy, sortDirection).stream().map(RoleDto::translatedFromDomain).collect(Collectors.toList());
        List<ExportColumn> columns = Arrays.asList(this.buildExportColumn(this.messageHelper.getMessage("Role"), roles, RoleDto::getRoleName), this.buildExportColumn(this.messageHelper.getMessage("Pakiet"), roles, RoleDto::getPackageId), this.buildExportColumn(this.messageHelper.getMessage("Proces"), roles, RoleDto::getProcessDefId), this.buildExportColumn(this.messageHelper.getMessage("Id"), roles, roleDto -> String.valueOf(roleDto.getId())));
        ExportModel model = ExportModel.builder().title(this.messageHelper.getMessage("Role")).columns(columns).build();
        ExportExtension extensionEnum = ExportExtension.valueOf((String)extension.toUpperCase());
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"export.%s\"", extensionEnum.getExtension()));
        this.exportService.export(model, extensionEnum, (OutputStream)response.getOutputStream());
    }

    private ExportColumn buildExportColumn(String name, List<RoleDto> data, Function<RoleDto, String> supplier) {
        return ExportColumnBuilder.create().name(name).data(data).by(supplier).build();
    }

    @RequestMapping(value={"position/{positionId}/role/{roleId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public RestResult detachRole(HttpServletRequest request, @PathVariable Long positionId, @PathVariable Long roleId) throws RoleNotFoundException {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_ROLE_FROM_POSITION).params((Map)ImmutableMap.of((Object)"positionId", (Object)positionId, (Object)"roleId", (Object)roleId));
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        if (this.roleService.getRole(roleId) == null) {
            auditBuilder.buildFailure(request);
            throw new RoleNotFoundException("Nie_znaleziono_roli_o_podanym_id");
        }
        try {
            this.roleService.detachRole(positionId, roleId);
            auditBuilder.buildSuccess(request);
            return new RestResult(true);
        }
        catch (Exception e) {
            auditBuilder.buildFailure(request);
            throw e;
        }
    }

    @RequestMapping(value={"position/{positionId}/role/{roleId}"}, method={RequestMethod.PUT})
    @ResponseBody
    public RestResult attachRole(HttpServletRequest request, @PathVariable Long positionId, @PathVariable Long roleId) throws RoleNotFoundException {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_ADD_ROLE_TO_POSITION).params((Map)ImmutableMap.of((Object)"positionId", (Object)positionId, (Object)"roleId", (Object)roleId));
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        if (this.roleService.getRole(roleId) == null) {
            auditBuilder.buildFailure(request);
            throw new RoleNotFoundException("Nie_znaleziono_roli_o_podanym_id");
        }
        try {
            this.roleService.addRole(positionId, roleId);
            auditBuilder.buildSuccess(request);
            return new RestResult(true);
        }
        catch (Exception e) {
            auditBuilder.buildFailure(request);
            throw e;
        }
    }

    @ExceptionHandler(value={RoleNotFoundException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public RestResult handleRoleNotFoundException(RoleNotFoundException e) {
        return new RestResult(false, e.getMessage());
    }

    @ExceptionHandler(value={NotFullRightsException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public RestResult handleNotFullRightsException(NotFullRightsException e) {
        log.info(this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
        return new RestResult(false, this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
    }

    @ConstructorProperties(value={"roleFinder", "exportService", "roleService", "authorizationHelper", "messageHelper"})
    @Autowired
    public RoleController(RoleFinder roleFinder, ExportService exportService, RoleService roleService, AuthorizationHelper authorizationHelper, MessageHelperBean messageHelper) {
        this.roleFinder = roleFinder;
        this.exportService = exportService;
        this.roleService = roleService;
        this.authorizationHelper = authorizationHelper;
        this.messageHelper = messageHelper;
    }
}

