/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.administration.email;

import com.google.common.collect.ImmutableMap;
import com.suncode.pwfl.administration.email.oauth.client.OAuth2Client;
import com.suncode.pwfl.administration.email.oauth.client.OAuth2ClientService;
import com.suncode.pwfl.administration.email.oauth.connection.OAuth2ConnectionService;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.search.Sorter;
import com.suncode.pwfl.web.dto.administration.email.OAuth2ClientDto;
import com.suncode.pwfl.web.dto.administration.email.OAuth2ConnectionDto;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/oauth/clients"})
public class OAuth2ClientController {
    @Autowired
    private OAuth2ClientService oAuth2ClientService;
    @Autowired
    private AuthorizationHelper authorizationHelper;
    @Autowired
    private OAuth2ConnectionService oAuth2ConnectionService;

    @ResponseBody
    @RequestMapping(value={""}, method={RequestMethod.GET})
    public List<OAuth2ClientDto> getAll() {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        return this.oAuth2ClientService.getAll(new String[]{"connections"}).stream().map(OAuth2ClientDto::new).collect(Collectors.toList());
    }

    @ResponseBody
    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET})
    public ResponseEntity<OAuth2ClientDto> get(@PathVariable Long id) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        OAuth2Client oAuth2Client = (OAuth2Client)this.oAuth2ClientService.get((Serializable)id, new String[]{"connections"});
        if (oAuth2Client == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity((Object)new OAuth2ClientDto(oAuth2Client), HttpStatus.OK);
    }

    @ResponseBody
    @RequestMapping(value={""}, method={RequestMethod.POST})
    public OAuth2ClientDto newClient(@RequestBody OAuth2ClientDto oAuth2ClientDto, HttpServletRequest request) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_ADD_OAUTH2_CLIENT);
        this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)auditBuilder.buildFailure()));
        auditBuilder.params((Map)this.clientAuditParamsBuilder(oAuth2ClientDto).build());
        try {
            OAuth2Client oAuth2Client = oAuth2ClientDto.toEntity();
            this.oAuth2ClientService.save((Object)oAuth2Client);
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
            return new OAuth2ClientDto(oAuth2Client);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    @ResponseBody
    @RequestMapping(value={""}, method={RequestMethod.PATCH})
    public void update(@RequestBody OAuth2ClientDto oAuth2ClientDto, HttpServletRequest request) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_UPDATE_OAUTH2_CLIENT);
        this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)auditBuilder.buildFailure()));
        try {
            OAuth2Client oAuth2Client = (OAuth2Client)this.oAuth2ClientService.get((Serializable)oAuth2ClientDto.getId(), new String[]{"connections"});
            auditBuilder.params((Map)this.clientChangeAuditParamsBuilder(oAuth2Client, oAuth2ClientDto).build());
            List oAuth2Connections = oAuth2Client.getConnections();
            OAuth2Client oAuth2ClientNew = oAuth2ClientDto.toEntity();
            oAuth2ClientNew.setConnections(oAuth2Connections);
            this.oAuth2ClientService.update((Object)oAuth2ClientNew);
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    @ResponseBody
    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE})
    public ResponseEntity<?> delete(@PathVariable Long id, HttpServletRequest request) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_OAUTH2_CLIENT);
        this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)auditBuilder.buildFailure()));
        auditBuilder.params((Map)ImmutableMap.of((Object)"OAUTH2_CLIENT_ID", (Object)id));
        try {
            OAuth2Client oAuth2Client = (OAuth2Client)this.oAuth2ClientService.get((Serializable)id, new String[]{"connections"});
            if (this.oAuth2ConnectionService.hasConnectionInUse(oAuth2Client)) {
                request.setAttribute("audit", (Object)auditBuilder.buildFailure());
                return new ResponseEntity(HttpStatus.BAD_REQUEST);
            }
            this.oAuth2ClientService.delete((Object)oAuth2Client);
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
            return new ResponseEntity(HttpStatus.OK);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    @ResponseBody
    @RequestMapping(value={"/{id}/connections"}, method={RequestMethod.GET})
    public CountedResult<OAuth2ConnectionDto> getClientConnections(@PathVariable Long id, @RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit, @RequestParam(required=false) String orderBy, @RequestParam(required=false, defaultValue="ASC") SortDirection orderDirection) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        Sorter sorter = new Sorter(orderBy, orderDirection);
        CountedResult countedConnections = this.oAuth2ConnectionService.getByClientId(id.longValue(), start.intValue(), limit.intValue(), sorter);
        List connectionDtos = countedConnections.getData().stream().map(OAuth2ConnectionDto::new).collect(Collectors.toList());
        return new CountedResult(countedConnections.getTotal(), connectionDtos);
    }

    private ImmutableMap.Builder<String, Object> clientAuditParamsBuilder(OAuth2ClientDto oAuth2ClientDto) {
        return ImmutableMap.builder().put((Object)"OAUTH2_CLIENT_NAME", (Object)Objects.toString(oAuth2ClientDto.getName(), "")).put((Object)"OAUTH2_AUTHENTICATION_METHOD", (Object)Objects.toString(oAuth2ClientDto.getAuthenticationMethod(), "")).put((Object)"OAUTH2_CLIENT_CLIENT_ID", (Object)Objects.toString(oAuth2ClientDto.getClientId(), "")).put((Object)"OAUTH2_CLIENT_SCOPE", (Object)Objects.toString(oAuth2ClientDto.getScope(), "")).put((Object)"OAUTH2_CLIENT_AUTHORIZATION_URL", (Object)Objects.toString(oAuth2ClientDto.getAuthorizationUrl(), "")).put((Object)"OAUTH2_CLIENT_TOKEN_URL", (Object)Objects.toString(oAuth2ClientDto.getTokenUrl(), ""));
    }

    private ImmutableMap.Builder<String, Object> clientChangeAuditParamsBuilder(OAuth2Client oldClient, OAuth2ClientDto newClient) {
        return ImmutableMap.builder().put((Object)"OAUTH2_CLIENT_ID", (Object)this.generateChangeString(oldClient.getId(), newClient.getId())).put((Object)"OAUTH2_AUTHENTICATION_METHOD", (Object)this.generateChangeString(oldClient.getAuthenticationMethod(), newClient.getAuthenticationMethod())).put((Object)"OAUTH2_CLIENT_NAME", (Object)this.generateChangeString(oldClient.getName(), newClient.getName())).put((Object)"OAUTH2_CLIENT_CLIENT_ID", (Object)this.generateChangeString(oldClient.getClientId(), newClient.getClientId())).put((Object)"OAUTH2_CLIENT_SCOPE", (Object)this.generateChangeString(oldClient.getScope(), newClient.getScope())).put((Object)"OAUTH2_CLIENT_AUTHORIZATION_URL", (Object)this.generateChangeString(oldClient.getAuthorizationUrl(), newClient.getAuthorizationUrl())).put((Object)"OAUTH2_CLIENT_TOKEN_URL", (Object)this.generateChangeString(oldClient.getTokenUrl(), newClient.getTokenUrl()));
    }

    private String generateChangeString(Object oldValue, Object newValue) {
        String oldValueString = Objects.toString(oldValue, "");
        String newValueString = Objects.toString(newValue, "");
        return oldValueString + ";" + newValueString;
    }
}

