/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.servlet.scheduledTasks;

import com.google.gson.Gson;
import com.plusmpm.database.hibernate.HibernateUtil;
import com.plusmpm.database.scheduledTasks.ScheduledTaskCategory;
import com.plusmpm.database.scheduledTasks.ScheduledTasksTable;
import com.plusmpm.database.scheduledTasks.dao.ScheduledTaskCategoryDAO;
import com.plusmpm.database.scheduledTasks.dao.ScheduledTasksTableDAO;
import com.plusmpm.i18n.I18N;
import com.plusmpm.util.Tools;
import com.plusmpm.util.json.extjs.gson.GsonFactory;
import com.suncode.pwfl.administration.scheduledtask.service.ScheduledTaskService;
import com.suncode.pwfl.translation.configElements.TranslatedFieldType;
import com.suncode.pwfl.util.SpringContext;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class ScheduledTasksCategoryServlet
extends HttpServlet {
    private static Logger log = Logger.getLogger(ScheduledTasksCategoryServlet.class);
    private static final long serialVersionUID = -8003673466980837513L;

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("application/json");
        I18N i18n = new I18N(req);
        List categories = ScheduledTaskCategoryDAO.get((ScheduledTaskCategory)new ScheduledTaskCategory(), (int)0, (int)0);
        ScheduledTaskService scheduledTaskService = (ScheduledTaskService)SpringContext.getBean(ScheduledTaskService.class);
        for (ScheduledTaskCategory category : categories) {
            category.setName(scheduledTaskService.getScheduledTaskCategoryTranslation(category.getId(), TranslatedFieldType.NAME));
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("categories", categories);
        result.put("total", categories.size());
        Gson gson = GsonFactory.getGsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
        resp.getWriter().write(gson.toJson(result));
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String taskId = req.getParameter("task");
        String catId = req.getParameter("categoryId");
        String cat = req.getParameter("category");
        Session session = HibernateUtil.getSession();
        Transaction transaction = null;
        try {
            ScheduledTasksTable task;
            transaction = session.beginTransaction();
            ScheduledTaskCategory newCategory = null;
            if (Tools.isNullOrEmpty((String)catId)) {
                if (!Tools.isNullOrEmpty((String)cat)) {
                    newCategory = new ScheduledTaskCategory(cat);
                    ScheduledTaskCategoryDAO.save((Session)session, (ScheduledTaskCategory)newCategory);
                }
            } else {
                newCategory = ScheduledTaskCategoryDAO.get((Session)session, (Long)Long.valueOf(catId));
            }
            Long oldCategoryId = (task = ScheduledTasksTableDAO.get((Session)session, (Long)Long.valueOf(taskId))).getCategory() == null ? null : task.getCategory().getId();
            task.setCategory(newCategory);
            session.flush();
            if (oldCategoryId != null) {
                ScheduledTaskCategoryDAO.deleteIfEmpty((Session)session, (Long)oldCategoryId);
            }
            transaction.commit();
        }
        catch (Exception e) {
            try {
                transaction.rollback();
            }
            catch (Exception e1) {
                log.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
            resp.setStatus(500);
        }
    }
}

