/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.servlet.plugins;

import com.plusmpm.util.plugin.Plugin;
import com.plusmpm.util.plugin.PluginConstants;
import com.plusmpm.util.plugin.PluginManager;
import com.suncode.pwfl.audit.AuditWrapper;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class InstallPluginServlet
extends HttpServlet {
    private static final Logger LOG = Logger.getLogger(InstallPluginServlet.class);
    private static final long serialVersionUID = -7704974508845750445L;

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HttpSession session = req.getSession(false);
        if (session != null && session.getAttribute("username") != null) {
            boolean success = false;
            String pluginId = null;
            PrintWriter printWriter = null;
            try {
                resp.setContentType("text/html");
                resp.setCharacterEncoding("UTF-8");
                ServletFileUpload servletFileUpload = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory(0x1400000, PluginConstants.LIBRARIES_DIR));
                List parsedRequest = servletFileUpload.parseRequest(req);
                File plugin = null;
                for (FileItem fileItem : parsedRequest) {
                    if (fileItem.isFormField()) continue;
                    plugin = new File(PluginConstants.LIBRARIES_DIR, FilenameUtils.getName((String)fileItem.getName()));
                    fileItem.write(plugin);
                    break;
                }
                Plugin installedPlugin = PluginManager.getInstance().install(plugin);
                success = true;
                pluginId = installedPlugin.getConfiguration().getId();
                printWriter = resp.getWriter();
                printWriter.print("{success:true}");
                req.setAttribute("audit", (Object)InstallPluginServlet.buildAudit(success, pluginId));
                if (printWriter != null) {
                    printWriter.close();
                }
            }
            catch (Exception e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                printWriter = resp.getWriter();
                printWriter.print("{success:false,msg:\"" + e.getMessage() + "; " + (e.getCause() != null ? e.getCause().getMessage() : "") + "\"}");
            }
            finally {
                req.setAttribute("audit", (Object)InstallPluginServlet.buildAudit(success, pluginId));
                if (printWriter != null) {
                    printWriter.close();
                }
            }
        }
    }

    private static AuditWrapper buildAudit(boolean success, String pluginId) {
        AuditBuilder builder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_INSTALL_MODULE).success(success);
        if (pluginId != null) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("pluginId", pluginId);
            builder.params(params);
        }
        return builder.build();
    }
}

