/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.services;

import com.plusmpm.database.DBManagement;
import com.plusmpm.database.DomainTable;
import com.plusmpm.database.files.DocumentVersionInfo;
import com.plusmpm.database.files.DocumentVersions;
import com.plusmpm.database.files.OpenedFile;
import com.plusmpm.database.files.OpenedFilesManager;
import com.plusmpm.ini.INIFile;
import com.plusmpm.ldap.LDAPManager;
import com.plusmpm.services.IWordAddInService;
import com.plusmpm.util.PlusWorkflow;
import com.plusmpm.util.Tools;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.archive.WfFileVersion;
import com.suncode.pwfl.archive.util.DocumentDefinition;
import com.suncode.pwfl.util.ComponentFactory;
import com.suncode.pwfl.util.QueryExecutor;
import com.suncode.pwfl.util.ServiceFactory;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.enhydra.shark.Shark;
import org.hibernate.FetchMode;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;

public class WordAddInServiceImpl
implements IWordAddInService {
    public static Logger log = Logger.getLogger(WordAddInServiceImpl.class);

    @Override
    public boolean ValidateLogin(String userName, String password) {
        log.trace((Object)("************ ValidateLogin(userName=" + userName + ", password) ************"));
        return this.ValidateLoginWithDomain(userName, password, null);
    }

    @Override
    public boolean ValidateLoginWithDomain(String userName, String password, String domain) {
        log.trace((Object)("************ ValidateLoginWithDomain(userName=" + userName + ", password, domain=" + domain + ") ************"));
        boolean validateSuccess = false;
        try {
            log.info((Object)("ValidateLoginWithDomain:" + userName + " " + domain));
            this.InitializeShark();
            if (domain == null || domain.compareToIgnoreCase("Plus Workflow") == 0 || domain.compareToIgnoreCase("") == 0) {
                domain = "plusworkflow";
            }
            if (domain.compareTo("plusworkflow") == 0) {
                validateSuccess = Shark.getInstance().validateUser(userName, password);
            } else {
                DBManagement dbm = new DBManagement();
                LDAPManager ldap = new LDAPManager();
                DomainTable domainObj = dbm.getDomainByName(domain);
                validateSuccess = ldap.AuthorizeUserInDomain(userName, password, domainObj.getId().toString());
            }
            log.info((Object)("validateSuccess: " + validateSuccess));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        return validateSuccess;
    }

    private void InitializeShark() {
        log.trace((Object)"************ InitializeShark() ************");
        if (!PlusWorkflow.isSystemConfigured()) {
            log.info((Object)"InitializeShark:");
            String sINIFile = "..//conf//releaseConfig.ini";
            String sConfFile = "";
            File f = new File(sINIFile);
            INIFile objINI = null;
            if (f.exists()) {
                objINI = new INIFile(sINIFile);
                sConfFile = objINI.getStringProperty("Files", "SharkConfFile");
            }
            Shark.configure((String)sConfFile);
        }
    }

    @Override
    public DocumentVersions GetAllDocumentVersions(String userName, String password, String fileId) {
        log.trace((Object)("************ GetAllDocumentVersions(userName=" + userName + ", password, fileId=" + fileId + ") ************"));
        return this.GetAllDocumentVersionsWithDomain(userName, password, "", fileId);
    }

    @Override
    public DocumentVersions GetAllDocumentVersionsWithDomain(String userName, String password, String domain, String fileId) {
        log.trace((Object)("************ GetAllDocumentVersionsWithDomain(userName=" + userName + ", password, domain=" + domain + ", fileId=" + fileId + ") ************"));
        DocumentVersions versions = null;
        try {
            versions = WordAddInServiceImpl.GetDocumentVersions(fileId);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return versions;
    }

    @Override
    public int SaveAsNewVersion(String userName, String password, String sFileId, String sFileName, String sPageCount, String sDescription, String sOCRContent, String sComment, byte[] bytes) {
        log.trace((Object)("************ SaveAsNewVersion(userName=" + userName + ", password, sFileId=" + sFileId + ", sFileName=" + sFileName + ", sPageCount=" + sPageCount + ", sDescription=" + sDescription + ", sOCRContent=" + sOCRContent + ", sComment=" + sComment + ", byte[]) ************"));
        FileService fs = ServiceFactory.getFileService();
        Long parentFileId = Long.valueOf(sFileId);
        DocumentDefinition dd = new DocumentDefinition();
        dd.setFileName(sFileName);
        dd.setDescription(sDescription);
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        dd.setInputStream((InputStream)is);
        dd.setUserName(userName);
        try {
            return fs.checkIn(dd, parentFileId, sComment).intValue();
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            return -1;
        }
    }

    @Override
    public int SaveAsNewVersionWithDomain(String userName, String password, String domain, String sFileId, String sFileName, String sPageCount, String sDescription, String sOCRContent, String sComment, byte[] bytes) {
        log.trace((Object)("************ SaveAsNewVersionWithDomain(userName=" + userName + ", password, domain=" + domain + ", sFileId=" + sFileId + ", sFileName=" + sFileName + ", sPageCount=" + sPageCount + ", sDescription=" + sDescription + ", sOCRContent=" + sOCRContent + ", sComment=" + sComment + ", byte[]) ************"));
        int newFileId = -1;
        try {
            newFileId = this.SaveAsNewVersion(userName, password, sFileId, sFileName, sPageCount, sDescription, sOCRContent, sComment, bytes);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return newFileId;
    }

    @Override
    public OpenedFile GetOpenedFileInfo(String userName, String password) {
        log.trace((Object)("************ GetOpenedFileInfo(userName=" + userName + ", password) ************"));
        return this.GetOpenedFileInfoWithDomain(userName, password, "");
    }

    @Override
    public OpenedFile GetOpenedFileInfoWithDomain(String userName, String password, String domain) {
        log.trace((Object)("************ GetOpenedFileInfoWithDomain(userName=" + userName + ", password, domain=" + domain + ") ************"));
        OpenedFile openedFile = null;
        try {
            openedFile = OpenedFilesManager.getLastOpenedFileForUser((String)userName);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return openedFile;
    }

    @Override
    public boolean CloseOpenedFile(String userName, String password, String sFileId, String sSessionId) {
        log.trace((Object)("************ CloseOpenedFile(userName=" + userName + ", password, sFileId=" + sFileId + ", sSessionId=" + sSessionId + ") ************"));
        return this.CloseOpenedFileWithDomain(userName, password, "", sFileId, sSessionId);
    }

    @Override
    public boolean CloseOpenedFileWithDomain(String userName, String password, String domain, String sFileId, String sSessionId) {
        log.trace((Object)("************ CloseOpenedFileWithDomain(userName=" + userName + ", password, domain=" + domain + ", sFileId=" + sFileId + ", sSessionId=" + sSessionId + ") ************"));
        boolean bResult = false;
        try {
            OpenedFilesManager.deleteOpenedFileWhenClose((Long)Long.valueOf(sFileId), (String)userName, (String)sSessionId);
            bResult = true;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return bResult;
    }

    @Override
    public boolean CheckInOut(String userName, String password, String sFileId, boolean bCheckOut) {
        log.trace((Object)("************ CheckInOut(userName=" + userName + ", password, sFileId=" + sFileId + ", bCheckOut=" + String.valueOf(bCheckOut) + ") ************"));
        return this.CheckInOutWithDomain(userName, password, "", sFileId, bCheckOut);
    }

    @Override
    public boolean CheckInOutWithDomain(String userName, String password, String domain, String sFileId, boolean bCheckOut) {
        log.trace((Object)("************ CheckInOutWithDomain(userName=" + userName + ", password, domain=" + domain + ", sFileId=" + sFileId + ", bCheckOut=" + String.valueOf(bCheckOut) + ") ************"));
        boolean bResult = false;
        String sState = "";
        String sFullUserName = "";
        try {
            if (StringUtils.isBlank((CharSequence)sFileId)) {
                throw new Exception("Nie podano fileId: " + sFileId);
            }
            Long fileId = Long.valueOf(sFileId);
            FileService fs = ServiceFactory.getFileService();
            WfFile file = fs.getFile(fileId, new String[]{"version"});
            if (file == null) {
                throw new Exception("W systemie nie istnieje dokument o identyfikatorze " + sFileId);
            }
            sState = file.getVersion().getState();
            sFullUserName = !Tools.isNullOrEmpty((String)domain) ? domain + "/" + userName : userName;
            if (bCheckOut) {
                log.info((Object)("Proba pobrania pliku o identyfikatorze " + sFileId + " do edycji"));
                if (sState.equalsIgnoreCase(WfFileVersion.State.STATE_READY.toString())) {
                    fs.checkOut(fileId, sFullUserName);
                    log.info((Object)("Pobrano dokument o identyfikatorze pliku " + sFileId + " do edycji"));
                    bResult = true;
                } else {
                    log.warn((Object)("Dokument o identyfikatorze pliku " + sFileId + " jest juz w edycji"));
                }
            } else {
                log.info((Object)("Proba anulowania zmian dla pliku o identyfikatorze " + sFileId));
                bResult = true;
                if (sState.equalsIgnoreCase(WfFileVersion.State.STATE_EDIT.toString())) {
                    fs.cancelCheckOut(fileId);
                    bResult = true;
                    log.info((Object)("Anulowano zmiany dla dokumentu o identyfikatorze pliku " + sFileId));
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return bResult;
    }

    public boolean CheckOut(String userName, String password, String sFileId) {
        log.trace((Object)("************ CheckOut(userName=" + userName + ", password, sFileId=" + sFileId + ") ************"));
        return this.CheckOutWithDomain(userName, password, "", sFileId);
    }

    public boolean CheckOutWithDomain(String userName, String password, String domain, String sFileId) {
        log.trace((Object)("************ CheckOutWithDomain(userName=" + userName + ", password, domain=" + domain + ", sFileId=" + sFileId + ") ************"));
        return false;
    }

    private static DocumentVersions GetDocumentVersions(String sFileId) {
        DocumentVersions versions = null;
        DocumentVersionInfo[] docTab = null;
        List<WfFileVersion> fileVersions = null;
        WfFile file = null;
        Long fileId = null;
        ArrayList<DocumentVersionInfo> tempList = null;
        int tabCounter = 0;
        FileService fs = ServiceFactory.getFileService();
        try {
            if (Tools.isNullOrEmpty((String)sFileId)) {
                throw new Exception("Nie podano identyfikatora pliku");
            }
            fileId = Long.valueOf(sFileId);
            file = fs.getFile(fileId, new String[0]);
            if (file == null) {
                throw new Exception("Plik o identyfikatorze " + sFileId + " nie istnieje w systemie");
            }
            fileVersions = WordAddInServiceImpl.GetAllVersionsOfFile(fileId);
            if (fileVersions == null || fileVersions.size() == 0) {
                throw new Exception("Brak wersji dla dokumentu o identyfikatorze pliku " + sFileId);
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            tempList = new ArrayList<DocumentVersionInfo>();
            for (int i = fileVersions.size() - 1; i >= 0; --i) {
                WfFileVersion fileVersion = fileVersions.get(i);
                Long thisFileId = fileVersion.getFile().getId();
                DocumentVersionInfo doc = new DocumentVersionInfo();
                doc.setComment(fileVersion.getComment());
                doc.setDescr(fileVersion.getFile().getDescription());
                doc.setFileId(thisFileId);
                doc.setOrgDocName(fileVersion.getFile().getFileName());
                doc.setState(fileVersion.getState());
                doc.setUploadDate(sdf.format(fileVersion.getFile().getFileDate()));
                doc.setUploader(fileVersion.getFile().getUploader());
                doc.setVersion(String.valueOf(fileVersion.getVersion()));
                tempList.add(doc);
            }
            docTab = new DocumentVersionInfo[tempList.size()];
            Iterator iterator = tempList.iterator();
            while (iterator.hasNext()) {
                DocumentVersionInfo doc;
                docTab[tabCounter] = doc = (DocumentVersionInfo)iterator.next();
                ++tabCounter;
            }
            versions = new DocumentVersions();
            versions.setVersions(docTab);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return versions;
    }

    private static List<WfFileVersion> GetAllVersionsOfFile(Long fileId) {
        log.trace((Object)("************ GetAllVersionsOfFile(fileId=" + String.valueOf(fileId) + ") ************"));
        try {
            log.info((Object)("Pobieranie wszystkich wersji pliku o identyfikatorze: " + fileId.toString()));
            FileService fs = ServiceFactory.getFileService();
            WfFileVersion v = fs.getVersionForFile(fileId);
            Long newestFileId = v.getNewestFile().getId();
            DetachedCriteria dc = DetachedCriteria.forClass(WfFileVersion.class);
            dc.setFetchMode("file", FetchMode.JOIN);
            dc.add((Criterion)Restrictions.eq((String)"newestFile.id", (Object)newestFileId));
            QueryExecutor qe = ComponentFactory.getQueryExecutor();
            List versions = qe.findByCriteria(dc);
            return versions;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

