/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.services;

import com.plusmpm.database.authorization.RightTreeBuilder;
import com.plusmpm.services.WordAddInServiceImpl;
import com.plusmpm.util.Authorization;
import com.plusmpm.util.Tools;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFireException;
import org.codehaus.xfire.handler.AbstractHandler;
import org.codehaus.xfire.transport.http.XFireServletController;

public class WordAddInRestrictionHandler
extends AbstractHandler {
    public static Logger log = Logger.getLogger(WordAddInRestrictionHandler.class);

    public void invoke(MessageContext ctx) throws Exception {
        log.trace((Object)"************ invoke(MessageContext) ************");
        String remoteIp = XFireServletController.getRequest().getRemoteAddr();
        log.info((Object)("Proba wywolania metody: " + ctx.getExchange().getOperation().getName() + " z adresu " + remoteIp));
        boolean ipOk = false;
        String allowedIP = (String)ctx.getService().getProperty("allowedIP");
        if (!Tools.isNullOrEmpty((String)allowedIP)) {
            log.info((Object)"Weryfikacja adresu IP");
            String[] allowedIPTab = allowedIP.split(";");
            for (int i = 0; i < allowedIPTab.length; ++i) {
                if (Tools.isNullOrEmpty((String)allowedIPTab[i]) || remoteIp.compareToIgnoreCase(allowedIPTab[i]) == -1) continue;
                ipOk = true;
                break;
            }
        } else {
            log.info((Object)"Brak weryfikacji adresu IP");
            ipOk = true;
        }
        if (!ipOk) {
            log.info((Object)("Przerwanie wykonywania metody: " + ctx.getExchange().getOperation().getName() + " z adresu " + remoteIp + ". Niewlasciwy adres IP"));
            throw new XFireException("Niew\u0142a\u015bciwy adres IP.");
        }
        log.info((Object)"IP OK");
        String sMethodName = ctx.getExchange().getOperation().getName();
        ArrayList aParameters = (ArrayList)ctx.getExchange().getInMessage().getBody();
        WordAddInServiceImpl wordAddInService = new WordAddInServiceImpl();
        String sLogin = "";
        String sPass = "";
        String sDomain = "";
        int iAuthorizeStat = 0;
        boolean methodRecognized = false;
        if (sMethodName.equalsIgnoreCase("GetAllDocumentVersions") || sMethodName.equalsIgnoreCase("SaveAsNewVersion") || sMethodName.equalsIgnoreCase("CloseOpenedFile") || sMethodName.equalsIgnoreCase("CheckInOut") || sMethodName.equalsIgnoreCase("GetOpenedFileInfo")) {
            sLogin = (String)aParameters.get(0);
            sPass = (String)aParameters.get(1);
            methodRecognized = true;
        }
        if (sMethodName.equalsIgnoreCase("GetAllDocumentVersionsWithDomain") || sMethodName.equalsIgnoreCase("SaveAsNewVersionWithDomain") || sMethodName.equalsIgnoreCase("CloseOpenedFileWithDomain") || sMethodName.equalsIgnoreCase("CheckInOutWithDomain") || sMethodName.equalsIgnoreCase("GetOpenedFileInfoWithDomain")) {
            sLogin = (String)aParameters.get(0);
            sPass = (String)aParameters.get(1);
            sDomain = (String)aParameters.get(2);
            methodRecognized = true;
        }
        if (methodRecognized) {
            boolean bLoginValidate = wordAddInService.ValidateLoginWithDomain(sLogin, sPass, sDomain);
            if (!bLoginValidate) {
                log.warn((Object)("Przerwanie wykonywania metody: " + ctx.getExchange().getOperation().getName() + " z adresu " + remoteIp + ". Niepoprawny Login, login:" + sLogin + ", haslo:" + sPass + ", domena:" + sDomain));
                throw new XFireException(String.valueOf("Brak autoryzacji u\u017cytkownika " + sLogin + " w systemie Plus Workflow." + System.getProperty("line.separator") + "Sprawd\u017a login i has\u0142o."));
            }
            log.info((Object)"LOGIN OK");
            iAuthorizeStat = Authorization.checkRight((String)RightTreeBuilder.builder().system().archive().docClasses().build(), (String)sLogin, (boolean)false, (boolean)false);
            if (iAuthorizeStat == -1) {
                log.warn((Object)("Przerwanie wykonywania metody: " + ctx.getExchange().getOperation().getName() + " z adresu " + remoteIp + ". Brak uprawnie\u0144 do funkcji, AuthorizeStat" + iAuthorizeStat));
                throw new XFireException("U\u017cytkownik " + sLogin + " nie posiada praw do archiwum systemu Plus Workflow.");
            }
        } else {
            log.warn((Object)("WordAddInService nie umo\u017cliwia wykoniania metody " + sMethodName + "."));
            throw new XFireException("WordAddInService nie umo\u017cliwia wykoniania metody " + sMethodName + ".");
        }
        log.info((Object)"AUTHORIZE OK");
    }
}

