/**
 * Skrypty formularza zadania.
 */

var ihPusty = "pages/images/cal1.gif";
var iAdditionalSubmitCheck = false;
var bSaveForm = false;
var deletedDocumentId = null;
var authorizeUserOnSubmit = false;

function filterDateField( e ) {
    var keynum;
    var keychar;
    var numcheck;

    keynum = e.which;

    if ( keynum == undefined ) {
        keynum = e.keyCode;
    }

    if ( keynum == 8 || keynum == 0 ) {
        return true;
    }

    keychar = String.fromCharCode( keynum );
    numcheck = /[0123456789-]/;
    return numcheck.test( keychar );

}

function ShowLoginForm() {
    validationMask.hide();

    new Ext.ux.plusmpm.AuthorizationPopupWindow( {
        showUsername: sTaskUserName,
        username: sOriginalTaskUserName,
        domainId: userDomain,
        listeners: {
            success: function() {
                // autoryzacja zakonczona pomyslnie
                document.forms['taskForm'].submit();
            },
            failure: function() {
                // uzytkownik zamknął okno autoryzacji bez wprowadzenia
                // poprawnych danych
                checkFormOK = false;
                iAdditionalSubmitCheck = true;
            }
        }
    } ).show();
}

function getIFrameDocument( aID ) {
    var rv = null;
    // if contentDocument exists, W3C compliant (Mozilla)
    if ( document.getElementById( aID ).contentDocument ) {
        rv = document.getElementById( aID ).contentDocument;
    } else {
        // IE
        rv = document.frames[aID].document;
    }
    return rv;
}

function checkDataChoosers( checkForm ) {
    return ValidateDataChoosers( checkForm );
}

function submitTaskForm() {
    // juz chyba nieaktualne bo jest maska
    // disableAllButtons();
    if ( true === bAcceptTaskWithPassword && true === authorizeUserOnSubmit ) {
        ShowLoginForm();
    } else
        document.taskForm.submit();
}

function stopVariableSetEdition() {
    var sets = oDataDynamicTableDefinitionsArray, table, div;
    for ( var i = 0; i < sets.length; i++ ) {
        div = Ext.get( sets[i].targetDivId ).child( "div" );
        table = Ext.getCmp( div.id );
        if ( Ext.isDefined( table ) && table.editing ) {
            table.stopEditing();
        }
    }
}

/**
 * Używana w 'taskbody.jsp'.
 */
function authorizeUser( checkForm ) {
    var dataChooserValidation = "";
    
    // sprawdzam czy nie ma znakow specjalnych, ktore powoduja problemy
    if ( checkStringFieldsSpecialChars() ) {
        // zatwierdzenie edytowanych pól w tabelce
        stopVariableSetEdition();
        
        
        // wstepna walidacja - sprawdz DataChooser
        dataChooserValidation = checkDataChoosers( checkForm );
        if ( dataChooserValidation == "" ) {
            if ( !bSaveForm && checkForm ) {
                iAdditionalSubmitCheck = true;
                formShowed = false;
                form_submit_handler();
                formShowed = true;
                if ( ( checkFormOK ) && ( additionalCheck() && checkAppendics() && formPanel.validateTables() ) ) {
                    if ( true === bAcceptTaskWithPassword ) {
                        authorizeUserOnSubmit = true;
                        return true;
                    } else {
                        iAdditionalSubmitCheck = false;
                        return true;
                    }
                } else
                    iAdditionalSubmitCheck = true;
                return false;
            } else {
                return true;
            }
        } else {
            Ext.Msg.show( {
                title: sUwaga,
                msg: dataChooserValidation,
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.INFO
            } );
            return false;
        }
    } else {
        return false;
    }

}

function checkAppendics() {
    var ajax = new XMLHttpRequest();

    ajax.open( "GET", 'com.plusmpm.servlet.CheckAppendicesServlet.customServlet?processId=' + processId + '&activityId=' + activityId + '&d='
                    + new Date().getTime(), false );

    ajax.send();

    resp = Ext.util.JSON.decode( ajax.responseText );

    if ( resp.length == 0 )
        return true;

    Ext.Msg.show( {
        title: sUwaga,
        msg: sBrak_wymaganych_zalacznikow + " " + ajax.responseText,
        buttons: Ext.MessageBox.OK,
        icon: Ext.MessageBox.INFO
    } );
    return false;
}

/**
 * Sprawdza czy uzytkownik wpisal tresc komentarza i wyswietla informacje
 *
 * @returns {Boolean} true jezeli komentarz nie jest pusty
 */
function checkBlankComment() {
    var lengthWarning = document.getElementById( 'commentlength-message' );
    if ( lengthWarning ) {
        lengthWarning.style.display = 'none';
    }
    var text = document.getElementById( 'comment' ).value.replace( " ", "" );

    if ( text.length <= 0 || text == null ) {
        var blankWarning = document.getElementById( 'comment-message' );
        if ( blankWarning ) {
            blankWarning.style.display = 'block';
        }
        return false;
    } else {
        var blankWarning = document.getElementById( 'comment-message' );
        if ( blankWarning ) {
            blankWarning.style.display = 'none';
        }
        return true;
    }
}

/**
 * Sprawdza czy uzytkownik wpisal tresc komentarza dluzsza niz 4000 znakow
 *
 * @returns {Boolean} true jezeli komentarz ma mniej niz 4000 znakow
 */
function checkCommentLength() {
    var blankWarning = document.getElementById( 'comment-message' );
    if ( blankWarning ) {
        blankWarning.style.display = 'none';
    }

    var text = document.getElementById( 'comment' ).value;

    if ( text.length > 4000 ) {
        var lengthWarning = document.getElementById( 'commentlength-message' );
        if ( lengthWarning ) {
            lengthWarning.style.display = 'block';
        }
        return false;
    } else {
        var lengthWarning = document.getElementById( 'commentlength-message' );
        if ( lengthWarning ) {
            lengthWarning.style.display = 'none';
        }
        return true;
    }
}

function checkStringFieldsSpecialChars() {
    if ( oStringFieldsToCheck.size() > 0 ) {
        for ( var i = 0; i < oStringFieldsToCheck.size(); i++ ) {

            var textArea = document.getElementById( oStringFieldsToCheck[i].id );
            if ( textArea ) {
                var text = textArea.value;
                if ( text.indexOf( ";" ) > -1 || text.indexOf( "~" ) > -1 ) // ||
                // text.indexOf("\\")
                // > -1)
                {
                    var info = indeksONazwie + ": <b>" + oStringFieldsToCheck[i].name + "</b> " + nieMozeZawieracZnakowSpecjalnych;

                    Ext.Msg.show( {
                        title: sUwaga,
                        msg: info,
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.INFO
                    } );

                    return false;
                }
                if ( text.length > 4000 ) {
                    var info = indeksONazwie + ": <b>" + oStringFieldsToCheck[i].name + "</b> " + jest_za_dlugi__ma_wiecej_niz_4000_znakow_;

                    Ext.Msg.show( {
                        title: sUwaga,
                        msg: info,
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.INFO
                    } );

                    return false;
                }
            }
        }
    }

    return true;
}

/**
 * Używana w 'commentsList.jsp'.
 */

// fla kompatybilnosci wstecznej
function addNewComment() {
    openNewCommentForm();
}

function openNewCommentForm() {
    var val = document.getElementById( "addComment" );
    if ( val ) {
        val.style.display = "inline";
        var commentArea = document.getElementById( 'comment' );
        if ( commentArea )
            commentArea.focus();
    }

    var panel = Ext.getCmp( 'activity_form_panel' );
    if ( panel ) {
        panel.recalculateHeights();
    }
}

function updateCommentTable() {
    var panel = Ext.getCmp( 'taskbodyCommentPanel' );
    if ( panel ) {
        panel.updateComments();
    }
}

function addComment() {
    if ( checkBlankComment() && checkCommentLength() ) {
        var commentText = document.getElementById( 'comment' ).value;
        commentText = encodeURIComponent( commentText );
        var panel = Ext.getCmp( 'taskbodyCommentPanel' );
        if ( panel ) {
            panel.addComment( commentText );
        }
    }
}

function deleteComment( id ) {
    var panel = Ext.getCmp( 'taskbodyCommentPanel' );
    if ( panel ) {
        panel.deleteComment( id );
    }
}

function closeNewCommentForm() {
    var val = document.getElementById( "addComment" );
    if ( val ) {
        val.style.display = "none";
    }

    var valText = document.getElementById( "comment" );
    if ( valText )
        valText.value = "";

    // usuwam wiaadomosc o pusym komentarzu, jezeli taka jest
    var warning = document.getElementById( 'comment-message' );
    if ( warning )
        warning.style.display = 'none';

    var panel = Ext.getCmp( 'activity_form_panel' );
    if ( panel ) {
        panel.recalculateHeights();
    }
}

/**
 * Używana w 'taskbody.jsp'.
 */
function printBarcode( label, source ) {
    if ( typeof customPrintBarcode === 'undefined' ) {
        var values = new Array();
        var barcode = "";
        for ( x in source ) {
            var element = source[x];
            var val = document.getElementById( element );
            if ( val ) {
                var value;
                if ( element == "BU" )
                    value = val.value.slice( 2, 4 );
                else if ( element == "PM_Pracownika" )
                    value = val.value.slice( 0, 4 );
                else if ( element == "Numer_dokumentu" ) {
                    if ( val.value.length > 4 ) {
                        value = val.value;
                        barcode = "";
                    } else
                        value = val.value;
                } else
                    value = val.value;
                barcode = barcode + value;
            }
        }

        var val2 = document.getElementById( "Numer_dokumentu" );
        if ( val2 ) {
            val2.value = barcode;
        }
        var DymoAddIn, DymoLabel;
        objMediaPlayer = new ActiveXObject( "MediaPlayer.MediaPlayer.1" );
        DymoAddIn = new ActiveXObject( 'DYMO.DymoAddIn' );
        DymoLabel = new ActiveXObject( 'DYMO.DymoLabels' );

        if ( DymoAddIn.Open( label ) ) {
            DymoLabel.SetAddress( 1, '' + barcode + '' );
            DymoAddIn.Print( 1, true );
        } else
            alert( sDefinitionFileNotFound + ':\n' + label );
    } else {
        customPrintBarcode( label, source );
    }
}

/**
 * Używana w 'taskbody.jsp'.
 */
function ihPokaz( adres, img ) {
    val = document.getElementById( img );
    if ( document.images ) {
        val.src = adres;
    }
}

/**
 * Używana w 'taskbody.jsp'.
 */
function ihCzysc( img ) {
    ihPokaz( ihPusty, img );
}

/**
 * Używana w 'TableDecoratorWrapper.java'.
 */
function Viewer( text ) {
    var text2 = 'menubar=no,toolbar=no,location=no,directories=no,status=no,scrollbars=yes,resizable=yes,fullscreen=no,channelmode=no,width='
                    + screen.width / 2 + ',height=' + screen.height + ',left=' + screen.width / 2 + ',top=0';
    window.open( text, 'viewer', text2 ).focus();
}

/**
 * Używana w 'addDocumentFromArchive.jsp'.
 */
function setFocusOnIndex() {
    obj = document.getElementById( "indexId0" );
    if ( obj ) {
        obj.focus();
    }
}

/**
 * Używana w apletach.
 */
function barcodeValue() {
    obj = document.getElementById( "id_dokumentu" );
    if ( obj )
        return document.getElementById( "id_dokumentu" ).value;

    obj = document.getElementById( "Numer_dokumentu" );
    if ( obj )
        return document.getElementById( "Numer_dokumentu" ).value;
}

/**
 * Używana w apletach.
 */
function readValueFromTask( variableName ) {
    obj = document.getElementById( variableName );
    if ( obj )
        return obj.value;
}

/**
 * Używana w 'taskbody.jsp'.
 */
function disableAllButtons() {
    var all = document.all;

    var selectedCount = 0;
    var element;

    for ( var i = 0; i < document.forms[0].elements.length; i++ ) {
        element = document.forms[0].elements[i];

        switch ( element.type ) {
            case 'a':
                element.disabled = true;
                break;
            case 'button':
                element.disabled = true;
                break;
        }
    }
}

/**
 * Używana w 'addDocumentFromArchive.jsp'.
 */
function generateDocumentWindowLink() {
    moveAllValuesForAddDocument();
    var sLink = "SearchDocClasses.do?docclassId=";
    sLink = sLink.concat( document.getElementById( 'docclassId' ).value, "&values=", escape( document.getElementById( 'values' ).value ),
                    "&source=task&processId=", processId, "&activityId=", activityId );
    return sLink;
}

function deleteDocFromProcessPostFunction() {
    CloseFreezeScreen1();
    if ( deletedDocumentId ) {
        Ext.getCmp( 'documents_view_panel' ).deleteDocument( deletedDocumentId );
    }

}

function setDCValidationRules( includes, excludes ) {
    try {
        DCValidationIncludes = splitAndTrim( includes, "," );
        DCValidationExcludes = splitAndTrim( excludes, "," );
    }
    catch ( e ) {
        resetDCValidationRules();
    }
}

function resetDCValidationRules() {
    DCValidationIncludes = [];
    DCValidationExcludes = [];
}

function splitAndTrim( source, separator ) {
    var splited = source.split( separator );
    for ( var i = 0; i < splited.length; i++ ) {
        splited[i] = splited[i].replace( /^\s+|\s+$/g, "" ); // trim
    }
    return splited;
}
