Ext.namespace('Ext.ux.plusmpm.scheduledtasks');

/**
 * Wymagane parametry: renderTo - wskazuje do jakiego elementu ma zostać
 * wyrenderowany menadżer
 */
Ext.ux.plusmpm.scheduledtasks.Manager = function (config) {
  Ext.QuickTips.init();

  var me = this;

  var store = new Ext.data.JsonStore({
    autoDestroy: true,
    storeId: 'tasksCategoryStore',

    proxy: new Ext.data.HttpProxy({
      method: 'GET',
      url: 'com.plusmpm.servlet.scheduledTasks.ScheduledTasksCategoryServlet.customServlet',
    }),

    root: 'categories',
    idProperty: 'id',
    fields: ['id', 'name'],
  });

  config = Ext.apply(
    {
      height: 700,
      store: store,
      items: [
        {
          xtype: 'st_tasktab',
          categoryName: PW.t('all'),
          categoryId: 'all',
          ref: 'allTab',
          listeners: {
            beforeparametersrender: function () {
              me.propagateBeforeParametersRenderEvent();
            },
          },
        },
        {
          xtype: 'st_tasktab',
          categoryName: PW.t('unassigned'),
          ref: 'unassignedTab',
          listeners: {
            beforeparametersrender: function () {
              me.propagateBeforeParametersRenderEvent();
            },
          },
        },
      ],

      tbar: {
        xtype: 'st_filtertoolbar',
        listeners: {
          scope: this,
          filter: this.onFilter,
          refresh: this.onRefresh,
          refreshAll: this.onRefreshAll,
          sort: this.onSort,
        },
      },
      bbar: new Ext.PagingToolbar({
        displayInfo: false,
        pageSize: 20,
        prependButtons: true,
        items: [
          {
            xtype: 'button',
            text: PW.t('addNewScheduledTask'),
            handler: this.onAddNewTask,
            iconCls: 'dvnt-icon-plus-symbol',
            scope: this,
          },
          { xtype: 'tbfill' },
        ],
      }),
    },
    config
  );

  Ext.ux.plusmpm.scheduledtasks.Manager.superclass.constructor.call(this, config);
}; // end of Ext.ux.plusmpm.ScheduledTasks constructor

Ext.extend(Ext.ux.plusmpm.scheduledtasks.Manager, Ext.TabPanel, {
  taskFilter: {
    query: '',
    active: false,
    processing: false,
  },
  enableTabScroll: true,
  sortInfo: {
    field: 'name',
    type: 'ASC',
    valueType: 'string',
  },

  /**
   * Handler zmiany kryteriów wyszukiwania
   */
  onFilter: function (query, onlyActive, onlyProcessing) {
    this.taskFilter = {
      query: query,
      active: onlyActive,
      processing: onlyProcessing,
    };
    this.getActiveTab().loadFirstPage();
  },

  /**
   * Handler kliknięcia na przycisk refresh
   */
  onRefresh: function (btn) {
    this.getActiveTab().store.reload();
  },

  /**
   * Handler kliknięcia na przycisk refreshAll
   */
  onRefreshAll: function (btn) {
    this.store.load();
  },

  onSort: function (type, field) {
    this.sortInfo = {
      type: type,
      field: field,
      valueType: field == 'lastRun' ? 'date' : 'string',
    };
    this.getActiveTab().loadFirstPage();
  },

  onAfterRender: function (element) {
    this.setWidth('auto');

    this.loadMask = new Ext.LoadMask(
      this.el,
      Ext.apply(
        {
          store: this.store,
        },
        Ext.LoadMask.prototype.msg
      )
    );

    this.store.load();
  },

  initComponent: function () {
    Ext.ux.plusmpm.scheduledtasks.Manager.superclass.initComponent.call(this);

    this.on('afterrender', this.onAfterRender, this);

    this.store.on({
      scope: this,
      datachanged: this.onStoreDataChange,
    });
  },

  /**
   * Pokazuje okno doddawania nowego zadania.
   */
  onAddNewTask: function () {
    if (this.newTaskWindow) {
      if (this.newTaskWindow.hidden == false) {
        return;
      }
    }

    var currentCategory = '';
    if (this.getActiveTab() != this.unassignedTab && this.getActiveTab() != this.allTab) {
      currentCategory = this.getActiveTab().categoryName;
    }

    this.propagateBeforeParametersRenderEvent();

    this.newTaskWindow = new Ext.ux.plusmpm.scheduledtasks.NewTaskWindow({
      defaultCategory: currentCategory,
    }).show();
  },

  propagateBeforeParametersRenderEvent: function () {
    this.items.each(function (item) {
      item.propagateBeforeParametersRenderEvent();
    }, this);
  },

  /**
   * Obsługa zdarzeń store'a
   */
  onStoreDataChange: function (store) {
    this.refresh();
  },
  /**
   * Obsługa zdarzeń store'a - KONIEC
   */

  /**
   * Tworzy/odświeża zakładki kategorii na podstawie stanu store'a
   */
  refresh: function () {
    var itemsToRemove = this.items.clone();
    itemsToRemove.remove(this.unassignedTab);
    itemsToRemove.remove(this.allTab);

    this.store.each(function (record) {
      var existingCategory;
      itemsToRemove.removeKey(record.data.id);

      var me = this;

      // jeżeli nie ma jeszcze takiej zakładki - dodaj
      if ((existingCategory = this.items.key(record.data.id)) === undefined) {
        this.insert(
          this.items.getCount() - 2,
          Ext.create({
            xtype: 'st_tasktab',
            itemId: record.data.id,
            categoryName: record.data.name,
            categoryId: record.data.id,
            listeners: {
              beforeparametersrender: function () {
                me.propagateBeforeParametersRenderEvent();
              },
            },
          })
        );
      }
      // w przeciwnym wypadku uaktualij dane - nazwa
      else {
        existingCategory.updateCategory(record);
      }
    }, this);

    itemsToRemove.each(function (item) {
      this.remove(item);
    }, this);

    if (this.getActiveTab() == undefined) {
      this.setActiveTab(0);
    } else {
      this.getActiveTab().refreshStore();
    }
  },
}); // end of Ext.extend
