/**
 * Rozszerzenia standardowej biblioteki Ext JS
 * Copyright(c) 2009 Plus MPM s.c.
 */
Ext.BLANK_IMAGE_URL = Suncode.getAbsolutePath('/style/img/s.gif');

Ext.state.Manager.setProvider(new Ext.state.CookieProvider());

Ext.apply(Ext.util.Format, {

	mpm_numberEU:function(value, metaData, record, rowIndex, colIndex, store)
	{
		//this.format dotyczy przestrzeni(scope) instancji obiektu, w ktorym jest uzywana
		var sFormatedValue = Ext.util.Format.number(value, this.format);
		sFormatedValue = sFormatedValue.replace(/\,/g, " ");
		sFormatedValue = sFormatedValue.replace(/\./g, this.editor.decimalSeparator );
		return sFormatedValue;
	} //end mpm_numberEU
}); //end Ext.apply

Ext.override(Ext.Component, {

    mpm_restoreState:function()
    {
        this.initState(null);
    }, //end mpm_restoreState

    mpm_clearState:function()
    {
        Ext.state.Manager.clear(this.getStateId());
    } //end mpm_clearState
}); //end Ext.override

Ext.override(Ext.data.Store, {

    mpm_hasPhantomRecords:function()
    {
    	var bHasPhantomRecords = false;
     	this.each(function(oNextRecord){
	        if(oNextRecord.phantom === true)
			{
				bHasPhantomRecords = true;
				return false;
			} //end if
		}); //end each
        return bHasPhantomRecords;
    }, //end mpm_hasPhantomRecords

    mpm_sum : function(property, start, end) {
		var rs = this.data.items, v = 0;
		start = start || 0;
		end = (end || end === 0) ? end : rs.length - 1;

		for ( var i = start; i <= end; i++) {
			v += parseInt(rs[i].data[property] * 10000 || 0);
		}
		return v / 10000;
	}
}); // end Ext.override

/**
 * Fix for ExtJs 3.2.2 - invalid state restore in Ext.grid.ColumnModel
 * */
Ext.override(Ext.grid.ColumnModel, {
    setState : function(col, state){
    	// code copied from ExtJs 3.3.0
        var def = Ext.apply(this.defaults, {});
        delete def.sortable;
        
        state = Ext.applyIf(state, def);
        if(state.hidden == undefined)
        	state.hidden = false;
        Ext.apply(this.config[col], state);
    } //end setState
}); //end Ext.override

/**
 * Zablokowanie BACKSPACE jako klawisza cofania do poprzedniej strony.
 * */
var extKeyMap_DisableBackspace = new Ext.KeyMap(document, [{
    key     : [Ext.EventObject.BACKSPACE],
    handler : function (nKeyCode, extEventObject) {
		var sTagName = extEventObject.getTarget().tagName;
		var sType = extEventObject.getTarget().type;
		var sReadOnly = extEventObject.getTarget().readOnly;
        if ( (sType !== "text" && sType !== "search" && sTagName !== "TEXTAREA" && sType !== "password" && sType !== "number" && sType !== "date") || sReadOnly===true) {
        	extEventObject.stopEvent();
        } //end if

    } //end Ext.KeyMap handler
}]); //end extKeyMap_DisableBackspace definition

/**
 * Fix for ExtJs 3.2.2 - unmask
 * */
Ext.override(Ext.Element, {
   unmask : Ext.Element.prototype.unmask.createSequence(function(){
       this.removeClass(['x-masked', 'x-masked-relative']);
   })
});

/**
 * Ustawienia tabIndex=-1 dla wyłączonych (disabled) przycisków
 */
Ext.override(Ext.Button, {
    
    setTabIndex: function(tabIndex){
        this.tabIndex = tabIndex;
        
        if(this.btnEl){
            this.btnEl.dom.tabIndex = this.tabIndex;
        }
    },
    
    onDisable : function(){
        this.onDisableChange(true); // oryginalna funkcja
        this.oldTabIndex = this.tabIndex;
        this.setTabIndex(-1);
    },
    
    // private
    onEnable : function(){
        this.onDisableChange(false); // oryginalna funkcja
        this.setTabIndex(this.oldTabIndex);
    }
    
}); //end Ext.override

Ext.override(Ext.Window, {
    
    frame: false
    
}); //end Ext.override

//Dodanie klasy selectable, aby można było zaznaczać tekst w komórkach tabeli
if (!Ext.grid.GridView.prototype.templates) {
    Ext.grid.GridView.prototype.templates = {};
}
Ext.grid.GridView.prototype.templates.cell = new Ext.Template(
    '<td class="x-grid3-col x-grid3-cell x-grid3-td-{id} x-selectable {css}" style="{style}" tabIndex="0" {cellAttr}>',
        '<div class="x-grid3-cell-inner x-grid3-col-{id}" {attr}>{value}</div>',
        '</td>'
);

(function() {
    var propCache = {},
        camelRe = /(-[a-z])/gi,
        propFloat = Ext.isIE ? "styleFloat" : "cssFloat",
        view = document.defaultView;

    function camelFn(m, a) {
        return a.charAt(1).toUpperCase();
    }

    function chkCache(prop) {
        return propCache[prop] || (propCache[prop] = prop == "float" ? propFloat : prop.replace(camelRe, camelFn));
    }

    Ext.override(Ext.Element, {
        /**
         * Normalizes currentStyle and computedStyle.
         * @param {String} property The style property whose value is returned.
         * @return {String} The current value of the style property for this element.
         */
        getStyle : function(){
            return view && view.getComputedStyle ?
                function(prop){
                    var el = this.dom,
                        v,
                        cs,
                        out,
                        display,
                        wk = Ext.isWebKit,
                        display;

                    if(el == document){
                        return null;
                    }
                    prop = chkCache(prop);
                    // Fix bug caused by this: https://bugs.webkit.org/show_bug.cgi?id=13343
                    if(wk && (/marginRight/.test(prop))) {
                        // PWFL-12342
                        // display = this.getStyle('display');
                        //
                        // zwykle pola ukrywane są poprzez klasę, co powoduje, że
                        // metoda this.getStyle(..) dla pustego "display" zwróci "display: none",
                        // bo taki byłby finalny styl nałożony przez przeglądarkę
                        // z powodu obecnych klas ukrywających pole
                        //
                        // w tym przypadku powoduje to problem, ponieważ to miejsce ma na celu
                        // dokonać prostego tymczasowego swap'a, a przypadkowo przy wykryciu
                        // pobierania wartości dla marginRight, wstawia
                        // explicit inline style "display: none;", którego reszta kodu już nigdy nie przywróci,
                        // bo ukrywanie jest zarządzane przez klasy, a nie inline style
                        display = el.style.display;

                        el.style.display = 'inline-block';
                    }
                    out = (v = el.style[prop]) ? v :
                        (cs = view.getComputedStyle(el, "")) ? cs[prop] : null;

                    // Webkit returns rgb values for transparent.
                    if(wk){
                        if(out == 'rgba(0, 0, 0, 0)'){
                            out = 'transparent';
                        }else if(display){
                            el.style.display = display;
                        }
                    }
                    return out;
                } :
                function(prop){
                    var el = this.dom,
                        m,
                        cs;

                    if(el == document) return null;
                    if (prop == 'opacity') {
                        if (el.style.filter.match) {
                            if(m = el.style.filter.match(opacityRe)){
                                var fv = parseFloat(m[1]);
                                if(!isNaN(fv)){
                                    return fv ? fv / 100 : 0;
                                }
                            }
                        }
                        return 1;
                    }
                    prop = chkCache(prop);
                    return el.style[prop] || ((cs = el.currentStyle) ? cs[prop] : null);
                };
        }(),

        /**
         * Wrapper for setting style properties, also takes single object parameter of multiple styles.
         * @param {String/Object} property The style property to be set, or an object of multiple styles.
         * @param {String} value (optional) The value to apply to the given property, or null if an object was passed.
         * @return {Ext.Element} this
         */
        setStyle : function(prop, value){
            var tmp, style;

            if (typeof prop != 'object') {
                tmp = {};
                tmp[prop] = value;
                prop = tmp;
            }
            for (style in prop) {
                value = prop[style];
                style == 'opacity' ?
                    this.setOpacity(value) :
                    this.dom.style[chkCache(style)] = value;
            }
            return this;
        },
    });
})()