(function(Ext) {
	
	Ext.define('Suncode.datasourcemanager.component.GroupedMultiValueField', {
		extend: 'Suncode.datasourcemanager.component.MultiValueField',
		alias: 'widget.groupedmultivaluefield',
		mixins: ['Suncode.datasourcemanager.mixins.ToolTip'],
		
		constructor: function( config ) {
		    this.fieldLabel = config.name;
		    if( config.description ) {
                this.initTooltip(this, config);
            }
		    
			this.callParent(arguments);
		},
		
		labelWidth: 200,
		labelPad: 10,
		
		initComponent: function(){
			var me = this;
			
			me.fields = [];
			
			me.items = [{
				xtype: 'container',
				itemId: 'labels',
				frame: false,
				border: false,
				layout: 'hbox',
				defaults: {
					flex: 1,
					margin: '4 0 0 0'
				},
				padding: '0 48 0 0', // szerokość 2 przycisków
			}];
			
			me.on('addField', function(position, field, config){
				me.addLabel(position, field, config);
			});
			
			this.callParent(arguments);
		},
		
		addRow: function(){
			var me = this,
				row = me.callParent(arguments);
			
			Ext.apply(row.down('#fields-form'), {
				insertParameter: function(position, config, extraConfig){
					config = Ext.apply({
						grouped: true
					}, config);
					
					extraConfig = Ext.apply({
						hideLabel: true,
						flex: 1
					}, extraConfig);
					
					var field = this._prepareField(config, extraConfig);
					this.up('removablefield').fields.push(field);
					me.fireEvent('addField', position, field, config);
					
					return this.insert(position, field);
				}
			});
			
			return row;
		},
		
		getParametersForm: function(){
			return this.down('#fields-form');
		},
		
		removeRow: function(row){
		    if(this.items && this.items.length == 2){
                row.setAsPlaceholder();
            }
			if(this.items && this.items.length > 2){
				this.remove(row);
			}
			this.fireEvent('change');
		},
		
		addLabel: function(position, field, config) {
			var label = {
				xtype: 'label',
				itemId: field.itemId,
				html: field.fieldLabel + ':',
			};
			
			if( config.description ){
            	this.initTooltip(label, config);
            }
			
			this.down('#labels').insert(position, label);
		}
		
	});
	
})(Ext4);