(function (Ext) {
  var messages = Suncode.context('dashboard').messages;

  Ext.define('Suncode.dashboard.administration.view.DashboardGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.dashboard-grid',

    selModel: {
      pruneRemoved: false,
      allowDeselect: true,
    },

    initComponent: function () {
      this.initTemplate();
      Ext.apply(this, {
        columns: [
          {
            xtype: 'rownumberer',
          },
          {
            text: messages('dashboard.name'),
            dataIndex: 'translatedName',
            flex: 1,
            renderer: function (value) {
              return Ext.util.Format.htmlEncode(value);
            },
          },
            {
                text: messages('TranslatedFieldType_ABBREVIATION'),
                dataIndex: 'abbreviation',
                flex: 1,
                renderer: function (value) {
                    return Ext.util.Format.htmlEncode(value);
                },
            },
          {
            text: messages('dashboard.owner'),
            dataIndex: 'owner',
            flex: 1,
            sortable: false,
            renderer: function (value, metaData) {
              var name = value.name ? value.name : value.userName,
                qtip = value.name ? Ext.String.format('{0} ({1})', value.name, value.userName) : value.userName;
              metaData.tdAttr = 'data-qtip="' + qtip + '"';
              return name;
            },
          },
          {
            text: messages('dashboard.description'),
            dataIndex: 'translatedDescription',
            flex: 2,
            renderer: function (value) {
              return Ext.util.Format.htmlEncode(value);
            },
          },
            {
                text: messages('Kolor'),
                dataIndex: 'color',
                flex: 1,
                renderer: function (value) {
                    var formattedValue = value.toLowerCase().replace('_', '-');
                    return '<div class="icon-color-item">' +
                        '<div>' +
                        `<span class="icon dvnt-${formattedValue}-background">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span><span>  ${formattedValue}</span>` +
                        '   </div>' +
                        '</div>';
                },
            },
          {
            xtype: 'templatecolumn',
            text: messages('dashboard.shared'),
            flex: 1,
            tpl: this.shareColumnTpl,
            listeners: {
              scope: this,
              afterrender: this.renderAdditionalSharesTip,
            },
          },
          {
            xtype: 'datecolumn',
            format: 'Y-m-d H:i:s',
            text: messages('dashboard.created'),
            dataIndex: 'created',
            width: 120,
            getSortParam: function () {
              return 'creationDate';
            },
          },
        ],
      });

      if (this.editable) {
        this.columns.push({
          xtype: 'actioncolumn',
          iconCls: 'dvnt-icon-x-symbol',
          tooltip: messages('delete'),
          flex: 0.25,
          menuDisabled: true,
          resizable: false,
          scope: this,
          handler: this.deleteDashboard,
        });
      }

      this.callParent();

      this.getStore().load();
    },

    deleteDashboard: function (grid, rowIndex, colIndex, item, e, record) {
      var me = grid,
        sm = grid.getSelectionModel(),
        dashboard = record,
        mainPanel = me.up().up().up();

      Ext.Msg.confirm(
          messages('dashboard.delete.confirm.title'),
          messages('dashboard.delete.confirm.content', Ext.util.Format.htmlEncode(dashboard.get('translatedName'))),
          function (button) {
              if (button != 'yes') {
                  return;
              }

              Ext.Msg.wait(messages('dashboard.delete.msg', dashboard.get('name')));
              Ext.Ajax.request({
                  url: Suncode.context('dashboard').base + '/api/dashboards/' + dashboard.get('id'),
                  method: 'delete',
                  callback: function (opts, success, response) {
                      Ext.Msg.hide();
                      if (success) {
                          mainPanel.defaultDashboardCombo.reset();
                          mainPanel.defaultDashboardCombo.getStore().reload();

                          me.getStore().load({
                              params: {
                                  user: mainPanel.chosenUsername,
                              },
                          });
              }
            },
          });
        }
      );
    },

    renderAdditionalSharesTip: function (column) {
      var me = this,
        gridEl = me.getEl(),
        moreEls;

      moreEls = gridEl.select('.x4-grid-cell');
    },

    initTemplate: function () {
      this.shareColumnTpl = new Ext.XTemplate(
        '<ul class="row-icon-padding"><tpl for="shares">',
        '{% if (xindex > 3){ out.push(\'<li class="more"><li>\'); break;} %}',
        '<tpl switch="shareType">',
        '<tpl case="ALL">',
        '<li class="dvnt-icon-globe">' + messages('all') + '</li>',
        '<tpl case="USER">',
        '<li data-qtip="' + messages('user') + '" class="dvnt-icon-user">{resourceName}</li>',
        '<tpl case="GROUP">',
        '<li data-qtip="' + messages('group') + '" class="dvnt-icon-users">{resourceName}</li>',
        '</tpl>',
        '</tpl></ul>'
      );
    },
  });
})(Ext4);
