
// funkcja do pobierania kluczy z property list
// dla zapamietywania zmienionych rekordow
// zawsze chcemy id
var qbVtGetKeys = function(obj){
   var keys = [];
   for(var key in obj){
      keys.push(key);
   }
   return keys;
}

// =====================================================================
// =================== Funkcje obslugujace zdarzenia =================
// =====================================================================


// akcja 'Dodaj'
// =====================================================================

function getDefaultNewRecord(activeTab, nr){
	switch (activeTab){
		case 'tablesGrid': return {
			nowy: true,
			id : (PW.t('prefix_nowej_tabeli') + nr)
			}; break;
		case 'columnsGrid' : return {
			nowy: true,
			id : (PW.t('prefix_nowej_kolumny') + nr)
			}; break;
		case 'valuesGrid' : var tmp = -1*nr; return{
			// jak tworzymy nowa wartosc to ona ma id ujemne
			// po tym rozpoznajemy nowe wartosci
			// potem ich id sie zmieni na serwerze
			// (bo to jest wlasciwie nr wiersza)
			nowy: true,
			id : tmp
			}; break;
	}
};

function qbVtAdd(){
	// sprawdzamy na jakim jestesmy panelu
	var activeTab = qbVtTabPanel.getActiveTab();
	// pobieramy store'a
	var s = activeTab.getStore();
	// ile mamy aktualnie wartosci?
	var nr = s.getTotalCount();
	// uwaga! to wcale nie gwarantuje nam unikalnej nazwy!
	var defaultNewRecord = getDefaultNewRecord(activeTab.id, nr+1);
	rec = new s.recordType(defaultNewRecord, defaultNewRecord.id);
	// oznaczanie nowego rekordu jako zmienionego
	rec.dirty = true;
	if(!rec.modified){
		rec.modified = {};
	};
	rec.fields.each(function(item,nr,len){
		rec.modified[item.name] = rec.data[item.name];
	});
	s.addSorted(rec);
	rec.afterEdit(rec);
	// zmienianie wielkosci store'a
	s.totalLength = nr+1;
	// ustawianie kursora na pierwszym polu
	activeTab.startEditing(s.indexOf(rec), 0);
}



// akcja 'Odswiez'
// =====================================================================

function qbVtRefresh(){
	// sprawdzamy na jakim jestesmy panelu
	var activeTab = qbVtTabPanel.getActiveTab();
	// pobieramy store'a
	var s = activeTab.getStore();
	// odswiezamy zawartosc grida
	// jezeli to valuesGrid, to sprawdzamy, czy jest wybrana tabela
	// to jest potrzebne dla przypadku jak nie ma tabel
	if(activeTab.getId()=='valuesGrid'){
		if(activeTab.tableId!=null){
			s.commitChanges();
			s.load();
		}
	}else{
		s.commitChanges();
		s.load();
	}
	// po odswiezeniu tracimy informacje o zmianach

}

// akcja 'Usuń'
// =====================================================================

function komunikatUsuwania(activeTabId){
	switch (activeTabId){
		case 'tablesGrid' : return PW.t('komunikat_tabeli2'); break;
		case 'columnsGrid' : return PW.t('komunikat_kolumny2'); break;
		case 'valuesGrid' : return PW.t('komunikat_wartosci2'); break;
		default : return PW.t('komunikat_ogolny2'); break;
	}
	return;
}

function komunikatWybierania(activeTabId){
	switch (activeTabId){
		case 'tablesGrid' : return PW.t('komunikat_tabeli3'); break;
		case 'columnsGrid' : return PW.t('komunikat_kolumny3'); break;
		case 'valuesGrid' : return PW.t('komunikat_wartosci3'); break;
		default : return PW.t('komunikat_ogolny3'); break;
	}
	return;
}

function qbVtDelete(){
	// sprawdzamy na jakim jestesmy panelu
	var activeTab = qbVtTabPanel.getActiveTab();
	// pobieramy store'a
	var s = activeTab.getStore();
	var deleted = activeTab.getSelectionModel().getSelections();
	// sprawdzamy wszystkie zaznaczone rekordy
	var i;
	for(i=0; i<deleted.length; i++){
		// jezeli cos zostalo zedytowane, to nie moze byc usuniete
		if (isEdited(deleted[i],s)){
			var napis = komunikatUsuwania(activeTab.id);
			Ext.Msg.alert(PW.t('uwaga'), napis);
			activeTab.getSelectionModel().clearSelections();
			return;
		}
		// jezeli zaden wiersz nie zostal wybrany,
		// to nie wiemy co usuwac
		if (deleted[i]==undefined){
			// okienko o wyborze czegostam
			var napis = komunikatWybierania(activeTab.id);
			Ext.Msg.alert(PW.t('uwaga'), napis);
			activeTab.getSelectionModel().clearSelections();
			return;
		}
	}
	// jezeli wczesniej bylo ok i mamy rekordy..
	for(i=0; i<deleted.length; i++){
		if(deleted[i]!=undefined){
			// tylko jezeli jeszcze nie jest zaznaczony do usuniecia
			if(!deleted[i].deleted){
				// zaznaczyc wiersz do usunięcia..
				deleted[i].deleted = true;
				deleted[i].modified = false;
				deleted[i].dirty = true;
				activeTab.getStore().deletedRecords.push(deleted[i]);
			}
		}
	}
	// odswiezenie (repaint) grida
	// (z usunietym rekordem wyswietlany na szaro
	// - styl 'deleted-row')
	activeTab.view.refresh();
}



// akcja 'Zapisz'
// =====================================================================

// jako globalna zmienna dla funkcji ajaxowej
var activeTab;

function idSaUnikalne(){
	// sprawdzamy na jakim jestesmy panelu
	activeStore = qbVtTabPanel.getActiveTab().getStore();

}

function qbVtSave(){
	// sprawdzamy na jakim jestesmy panelu
	activeTab = qbVtTabPanel.getActiveTab();
	// powinniśmy pokazać okienko o oczekiwaniu
	var oldText = activeTab.loadMask.msg;
	activeTab.loadMask.msg = PW.t('zapisywanie_zmian');

		activeTab.loadMask.show();
		// tablica zmodyfikowanych rekordow
		var potentiallyModified = activeTab.getStore().getModifiedRecords();
		var modified = new Array();
		var stopSave = false;
        var stopSaveMsg = '';

		Ext.each( potentiallyModified, function( r, idx, rs ) {
			var fillEmpty = false;

			Ext.each( r.fields.items, function( item, nr, len ) {
				if ( item.name != 'id' && r.data[item.name] ) {
					fillEmpty = true;

					return false;
				}
			} );

			if ( fillEmpty ) {
				Ext.each( r.fields.items, function( item, nr, len ) {
					if ( r.data[item.name] == undefined ) {
						var val = '';

						if ( item.type.type == 'bool' ) {
							val = false;
						}

						r.data[item.name] = val;
					}
				} );

				modified.push( r );
			}

			if ( activeTab.getId() == 'columnsGrid' && Ext.isEmpty( r.data['typeId'] ) ) {
			    stopSave = true;
		        stopSaveMsg = PW.t('brak_typu_kolumny');

		        return false;
            }
		} );

		if ( stopSave ) {
		    activeTab.loadMask.hide();
            activeTab.loadMask.msg = oldText;
		    Ext.Msg.alert( PW.t('uwaga'), stopSaveMsg );
		    return;
		}

		// tablica usunietych rekordow
		var deleted = activeTab.getStore().deletedRecords;

		if ( modified.length == 0 && deleted.length == 0 ) {
			activeTab.loadMask.hide();
			activeTab.loadMask.msg = oldText;
			activeTab.getStore().load();
			Ext.Msg.alert(PW.t('brak_modyfikacji'), PW.t('brak_modyfikacji_info'));
			return;
		}

		var type = qbVtGetType(activeTab);
		// sprawdzamy tableId dla jsonstr..
		var tableId = activeTab.getStore().baseParams.tableId;
		var jsonstr = prepareJsonForChangedData(modified, deleted, type, tableId);
		// wysylamy jako parametr jsonStringa
		var params = "jsonString=" +jsonstr;
		params = params.replace(/\+/g,"%2B");
		// synchronicznie (czekamy na odpowiedz)
		// od metody POST
		AJAX.open("POST", "com.plusmpm.servlet.virtualtables.setJsonChanges.customServlet", false);
		AJAX.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded; charset=UTF-8');
		// wysylamy zadanie zapisania informacji

		// alert(params);
		AJAX.send(params);
		// chowamy komunikat o zapisywaniu danych
		activeTab.loadMask.hide();
		activeTab.loadMask.msg = oldText;
		// musimy przetworzyc i przetlumaczyc odpowiedz
		eval("var response = ("+AJAX.responseText+")");
		Ext.Msg.alert(response.result, response.msg);
		// jezeli nie bylo porazki, to odswiez grida
		if(!(response.result==PW.t('porazka'))){

			// zeby juz nie pamietal o zmianach
			activeTab.getStore().commitChanges();
			activeTab.getStore().deletedRecords = [];
			activeTab.getStore().load();

			if(activeTab.id=='columnsGrid'){
				// jak usunelismy kolumne, to musimy przeladowac wartosci
				// ale rowniez byc moze struktura sie zmienila
				// wiec ustawiamy loaded na false. powinien
				// sie wtedy zaladowac store
				Ext.getCmp('valuesGrid').loaded = false;
			}
			// jak usunelismy tabele, to musimy przeladowac wartosci
			// oraz kolumny
			if(activeTab.id=='tablesGrid'){
				Ext.getCmp('valuesGrid').getStore().load();
				Ext.getCmp('columnsGrid').getStore().load();
			}
			// byc moze usunelismy rekordy i trzeba przeladowac
			// grida z tabelami, bo tam jest inf o ilosci rekordow
			if(activeTab.id=='valuesGrid'){
				Ext.getCmp('tablesGrid').loaded = false;
			}
			// i klikamy pierwszy rekord
			if(activeTab.getStore().getTotalCount()>0){
				activeTab.getSelectionModel().selectRow(0);
				activeTab.fireEvent('rowclick', activeTab, 0);
			}
		}
}

function qbVtExport() {
	var valuesGrid = Ext.getCmp('valuesGrid');
	var valuesStore = valuesGrid.getStore();
	var rec = Ext.getCmp('tablesGrid').getSelectionModel().getSelected();

	if ( !rec ) {
		Ext.Msg.show( {
			title: PW.t('uwaga'),
			msg: PW.t('wybierz_tabele'),
			buttons: Ext.Msg.OK,
			icon: Ext.Msg.WARNING
		} );

		return;
	}

	if ( valuesStore.getCount()==0 ) {
		Ext.Msg.show( {
			title: PW.t('uwaga'),
			msg: PW.t('tabela_jest_pusta'),
			buttons: Ext.Msg.OK,
			icon: Ext.Msg.WARNING
		} );

		return;
	}

	valuesStore.load( {
		callback: function( r, options, success ) {
			var link = document.location.href;
			var lastSymbol = link.lastIndexOf( '/' );
			link = link.substring( 0, lastSymbol );

			var exportData = new Object();
			var recs = new Array();

			valuesStore.each( function( r ) {
				recs.push( r.data );
			} );

			exportData = Ext.apply( {
				records: recs
			}, exportData );

			var exportForm = document.getElementById( 'export-form' );

			if ( !exportForm ) {
				exportForm = Ext.getBody().createChild( {
					tag: 'form',
					action: '#',
					cls: 'x-hidden',
					id: 'export-form',
					children: [ {
						tag: 'div',
						children: [ {
							tag: 'input',
							id: 'export-tableId',
							name: 'tableId',
							type: 'hidden'
						}, {
							tag: 'input',
							id: 'export-exportData',
							name: 'exportData',
							type: 'hidden'
						} ]
					} ]
				} );
			}

			document.getElementById( 'export-tableId' ).value = rec.data.id;
			document.getElementById( 'export-exportData' ).value = Ext.util.JSON.encode( exportData );
			exportForm = document.getElementById( 'export-form' );
			exportForm.setAttribute( 'method', 'POST' );
			exportForm.setAttribute( 'action', link + '/com.plusmpm.servlet.virtualtables.exportValues.customServlet');
			exportForm.submit();
		}
	} );
}

// =====================================================================
// ================== Pasek Guzikow ==================================
// =====================================================================

var qbVtToolbar = new Ext.Toolbar( {
	id : 'vtToolbar',
	items : [ {
		text : PW.t('dodaj'),
		id : 'vtAddRecord',
		iconCls : 'dvnt-icon-plus-symbol',
		scope : this,
		// zeby pozostale guziki nie byly przesuniete
		width : 70,
		handler : function() {
			qbVtAdd();
		}
	}, {
		text : PW.t('usun'),
		scope : this,
		iconCls : 'dvnt-icon-x-symbol',
		handler : function(){
			qbVtDelete();
		}
	}, {
		text : PW.t('odswiez'),
		scope : this,
		iconCls : 'dvnt-icon-rotation-right',
		handler : function(){
			qbVtRefresh();
		}
	}, {
		text : PW.t('zapisz'),
		scope : this,
		iconCls : 'dvnt-icon-save',
		handler : function(){
			qbVtSave();
		}
	},'->',
	{
		// tu bedzie chyba działać submit..
		text : PW.t('importuj'),
		id : 'importButton',
		hidden : true,
		scope : this,
		iconCls : 'dvnt-icon-down',
		handler : function(){
			// powinniśmy pokazać okienko o oczekiwaniu
			// var oldText = Ext.getCmp('valuesGrid').loadMask.msg;
			// maskujemy grida na czas uploadowania..
			// Ext.getCmp('valuesGrid').loadMask.msg =
            // PW.t('upload');
			// Ext.getCmp('valuesGrid').loadMask.show();
			// Ext.getCmp('fileUploadVtWindow').show();
			Ext.getCmp('fileUploadVtWindow').show();
		}
	},
	{
		text : PW.t('eksportuj'),
		id : 'exportButton',
		hidden : true,
		scope : this,
		iconCls : 'dvnt-icon-up',
		handler : function(){
			qbVtExport();
		}
	}
	 ]
});

qbVtToolbar.doLayout();

// =====================================================================
// ================== Funkcje pomocnicze =============================
// =====================================================================

function isEdited(record, store){
	var edited = store.getModifiedRecords();
	i = edited.length;
	// sprawdzamy, czy nasz rekord byl edytowany
	while(i--){
		if(edited[i].id == record.id){
			return true;
		}
	}
	return false;
}


// przygotowanie stringa i wyslanie na serwer..
function prepareJsonForChangedData(modified, deleted, type, tableId){
	var jsonstring = '{';
	// najpierw okreslamy co jest na rzeczy:
	jsonstring += "type : \"" + type +"\", ";
	jsonstring += "tableId : \"" + tableId + "\", ";
	// nastepnie budujemy stringa na temat usunietych rekordow
	// to jest latwiejsze:
	jsonstring += 'deleted : [' + qbVtDeletedJsonString(deleted) + '], ';
	jsonstring += 'modified: [' + qbVtModifiedJsonString(modified) + ']';
	jsonstring += "}";
	return jsonstring;
}

// zbudowanie tablicy z identyfikatorami tego, co jest usuniete
function qbVtDeletedJsonString(deleted){
	var result = '';
	var len = deleted.length;
	for(i=0; i<len-1; i++){
		result += "\"" + deleted[i].id + "\", ";
	}
	if(deleted.length>0){
		result += "\"" + deleted[(len-1)].id + "\""
	}
	return result;
}

function qbVtModifiedJsonString(modified){
	var result = '';
	var len = modified.length;
	for(i=0; i<len-1; i++){
		result += qbVtModifiedJsonOneRecord(modified[i])+ ", ";
	}
	if(modified.length>0){
		result += qbVtModifiedJsonOneRecord(modified[len-1]);
	}
	return result;
}

function qbVtModifiedJsonOneRecord(record){
	var mod = record.data;
	// tablica zmodyfikowanych
	var columnsInJson = qbVtGetKeys(record.modified)
	// czy zmieniane bylo Id
	if(record.modified.id!=undefined){
		// dodajemy dodatkowe pole
		mod.oldId = record.modified.id;
		columnsInJson.push('oldId');
	} else {
		// jezeli id nie bylo modyfikowane
		// to musimy je dodac (bo nie ma go na razie w 'columnsInJson')
		columnsInJson.push('id');
	}
	// utworzenie json stringa
	// tylko zmodyfikowane kolumny i id
	var result = JSON.stringify(mod, columnsInJson);
	return result;
}

function qbVtGetType(activeTab){
	return activeTab.id;
}





