/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.support.form.cache;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.plusmpm.struts.form.AdvanceVariableForm;
import com.suncode.plugin.framework.service.Provides;
import com.suncode.pwfl.search.AdvanceVariableFormBuilder;
import com.suncode.pwfl.web.search.model.SearchFormModelDto;
import com.suncode.pwfl.web.util.SessionUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Provides(value={SearchFormCache.class})
public class SearchFormCache {
    @Autowired
    private AdvanceVariableFormBuilder advanceVariableFormBuilder;

    public Cache<String, String> getCache(HttpSession session) {
        Optional<Object> cacheAttribute = Optional.ofNullable(session.getAttribute("searchFormCache"));
        Cache<Object, Object> cache = cacheAttribute.orElse(this.generateCache());
        session.setAttribute("searchFormCache", cache);
        return cache;
    }

    private Cache<Object, Object> generateCache() {
        return CacheBuilder.newBuilder().expireAfterAccess(4L, TimeUnit.HOURS).build();
    }

    public void cacheSearchForm(HttpSession session, String searchId, String encodedSearchForm) {
        Cache<String, String> cache = this.getCache(session);
        cache.put((Object)searchId, (Object)encodedSearchForm);
    }

    public Optional<String> getValueFromCache(HttpSession session, String searchId) {
        Cache<String, String> cache = this.getCache(session);
        return Optional.ofNullable(cache.asMap().get(searchId));
    }

    public Optional<String> getValueFromCache(String searchId) {
        HttpSession session = SessionUtils.getCurrentSession();
        Cache<String, String> cache = this.getCache(session);
        return Optional.ofNullable(cache.asMap().get(searchId));
    }

    public Optional<AdvanceVariableForm[]> getSearchVariablesFromCache(String searchId) throws IOException {
        HttpSession session = SessionUtils.getCurrentSession();
        Cache<String, String> cache = this.getCache(session);
        Optional encodedCachedForm = Optional.ofNullable(cache.asMap().get(searchId));
        if (encodedCachedForm.isPresent()) {
            byte[] decodedBytes = Base64.getDecoder().decode(((String)encodedCachedForm.get()).getBytes(StandardCharsets.UTF_8));
            String searchModelForm = new String(decodedBytes, StandardCharsets.UTF_8);
            SearchFormModelDto searchFormModelDto = (SearchFormModelDto)new ObjectMapper().readValue(searchModelForm, SearchFormModelDto.class);
            return Optional.ofNullable(this.advanceVariableFormBuilder.buildAdvanceFormVariables(searchFormModelDto));
        }
        return Optional.empty();
    }

    public Optional<AdvanceVariableForm[]> getSearchExtrasFromCache(String searchId) throws IOException {
        HttpSession session = SessionUtils.getCurrentSession();
        Cache<String, String> cache = this.getCache(session);
        Optional encodedCachedForm = Optional.ofNullable(cache.asMap().get(searchId));
        if (encodedCachedForm.isPresent()) {
            byte[] decodedBytes = Base64.getDecoder().decode(((String)encodedCachedForm.get()).getBytes(StandardCharsets.UTF_8));
            String searchModelForm = new String(decodedBytes, StandardCharsets.UTF_8);
            SearchFormModelDto searchFormModelDto = (SearchFormModelDto)new ObjectMapper().readValue(searchModelForm, SearchFormModelDto.class);
            return Optional.ofNullable(this.advanceVariableFormBuilder.buildAdvanceVariableFormExtras(searchFormModelDto.getExtrasSearchModel()));
        }
        return Optional.empty();
    }

    public Optional<SearchFormModelDto> getSearchFormFromCache(String searchId) {
        HttpSession session = SessionUtils.getCurrentSession();
        Cache<String, String> cache = this.getCache(session);
        Optional encodedCachedForm = Optional.ofNullable(cache.asMap().get(searchId));
        if (encodedCachedForm.isPresent()) {
            byte[] decodedBytes = Base64.getDecoder().decode(((String)encodedCachedForm.get()).getBytes(StandardCharsets.UTF_8));
            String searchModelForm = new String(decodedBytes, StandardCharsets.UTF_8);
            SearchFormModelDto searchFormModelDto = (SearchFormModelDto)new ObjectMapper().readValue(searchModelForm, SearchFormModelDto.class);
            return Optional.ofNullable(searchFormModelDto);
        }
        return Optional.empty();
    }
}

