/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.dto.workflow.search;

import com.suncode.plugin.framework.PluginFramework;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.license.LicenseService;
import com.suncode.pwfl.search.results.AdvanceSearchVariableType;
import com.suncode.pwfl.web.dto.workflow.search.AdvanceSearchResultColumnDto;
import com.suncode.pwfl.web.dto.workflow.search.AdvanceSearchVariableTypeResolver;
import com.suncode.pwfl.web.search.model.ActivityDetailsSearchModelDto;
import com.suncode.pwfl.web.search.model.ExtraValueSearchModelDto;
import com.suncode.pwfl.web.search.model.ExtrasSearchModelDto;
import com.suncode.pwfl.web.search.model.ProcessDetailsSearchModelDto;
import com.suncode.pwfl.web.search.model.ProcessVariablesSearchModelDto;
import com.suncode.pwfl.web.search.model.SearchFormModelDto;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SearchModelToColumnMapper {
    private final LicenseService licenseService;
    private final MessageHelperBean messageHelperBean;
    private final AdvanceSearchVariableTypeResolver advanceSearchVariableTypeResolver;
    private final PluginFramework pluginFramework;

    public List<AdvanceSearchResultColumnDto> map(SearchFormModelDto searchFormModelDto) {
        LinkedList<VariableWithPosition> variableWithPositions = new LinkedList<VariableWithPosition>();
        variableWithPositions.addAll(this.getProcessHeaders(searchFormModelDto.getProcessDetailsSearchModel()));
        variableWithPositions.addAll(this.getActivityHeaders(searchFormModelDto.getActivityDetailsSearchModel()));
        variableWithPositions.addAll(this.getProcessVariables(searchFormModelDto.getProcessVariablesSearchModel()));
        variableWithPositions.addAll(this.getExtrasHeaders(searchFormModelDto.getExtrasSearchModel()));
        return variableWithPositions.stream().filter(VariableWithPosition::isPresent).sorted(new VariableComparator()).map((? super T variable) -> new AdvanceSearchResultColumnDto(variable.getId(), variable.getName(), variable.getVariableExtendedType(), variable.isTableVariable(), variable.getVariableType())).collect(Collectors.toList());
    }

    private List<VariableWithPosition> getProcessHeaders(ProcessDetailsSearchModelDto processDetailsSearchModel) {
        LinkedList<VariableWithPosition> variableWithPositions = new LinkedList<VariableWithPosition>();
        variableWithPositions.add(this.buildVariableWithPosition("processType", this.messageHelperBean.getMessage("Typ_procesu"), processDetailsSearchModel.getProcessDefinitionId().getExtraValueSearchModel()));
        variableWithPositions.add(this.buildVariableWithPosition("processName", this.messageHelperBean.getMessage("Nazwa_procesu"), processDetailsSearchModel.getName().getExtraValueSearchModel()));
        variableWithPositions.add(this.buildVariableWithPosition("processDescription", this.messageHelperBean.getMessage("Opis_procesu"), processDetailsSearchModel.getDescription().getExtraValueSearchModel()));
        variableWithPositions.add(this.buildVariableWithPosition("processInitiator", this.messageHelperBean.getMessage("Inicjator"), processDetailsSearchModel.getInitiator().getExtraValueSearchModel()));
        variableWithPositions.add(this.buildVariableWithPosition("processState", this.messageHelperBean.getMessage("Status_procesu"), processDetailsSearchModel.getState().getExtraValueSearchModel()));
        variableWithPositions.add(this.buildVariableWithPosition("processCreatedData", this.messageHelperBean.getMessage("Data_rozpoczecia_procesu"), processDetailsSearchModel.getCreatedDate().getExtraValueSearchModel(), (Type<?>)Types.DATETIME));
        variableWithPositions.add(this.buildVariableWithPosition("processFinishedDate", this.messageHelperBean.getMessage("Data_zakonczenia_procesu"), processDetailsSearchModel.getFinishedDate().getExtraValueSearchModel(), (Type<?>)Types.DATETIME));
        variableWithPositions.add(this.buildVariableWithPosition("processDeadlineTimeDays", this.messageHelperBean.getMessage("Przekroczenie_terminu_w_dn"), processDetailsSearchModel.getDeadlineTimeDays().getExtraValueSearchModel(), AdvanceSearchVariableType.DEADLINE, false, (Type<?>)Types.INTEGER));
        return variableWithPositions;
    }

    private List<VariableWithPosition> getActivityHeaders(ActivityDetailsSearchModelDto activityDetailsSearchModel) {
        LinkedList<VariableWithPosition> variableWithPositions = new LinkedList<VariableWithPosition>();
        variableWithPositions.add(this.buildVariableWithPosition("activityName", this.messageHelperBean.getMessage("Nazwa_zadania"), activityDetailsSearchModel.getName().getExtraValueSearchModel()));
        variableWithPositions.add(this.buildVariableWithPosition("activityState", this.messageHelperBean.getMessage("Status_zadania"), activityDetailsSearchModel.getState().getExtraValueSearchModel()));
        variableWithPositions.add(this.buildVariableWithPosition("activityPerformer", this.messageHelperBean.getMessage("Wykonawca"), activityDetailsSearchModel.getPerformer().getExtraValueSearchModel()));
        variableWithPositions.add(this.buildVariableWithPosition("activityCreatedDate", this.messageHelperBean.getMessage("Data_rozpoczecia_zadania"), activityDetailsSearchModel.getCreatedDate().getExtraValueSearchModel(), (Type<?>)Types.DATETIME));
        variableWithPositions.add(this.buildVariableWithPosition("activityFinishedDate", this.messageHelperBean.getMessage("Data_zakonczenia_zadania"), activityDetailsSearchModel.getFinishedDate().getExtraValueSearchModel(), (Type<?>)Types.DATETIME));
        variableWithPositions.add(this.buildVariableWithPosition("activityDeadlineTimeDays", this.messageHelperBean.getMessage("Przekroczenie_terminu_zadania_w_dn"), activityDetailsSearchModel.getDeadlineTimeDays().getExtraValueSearchModel(), AdvanceSearchVariableType.DEADLINE, false, (Type<?>)Types.INTEGER));
        variableWithPositions.add(this.buildVariableWithPosition("activityDeadlineName", this.messageHelperBean.getMessage("Przekroczenie_terminu"), activityDetailsSearchModel.getDeadlineName().getExtraValueSearchModel()));
        return variableWithPositions;
    }

    private List<VariableWithPosition> getProcessVariables(ProcessVariablesSearchModelDto processVariablesSearchModelDto) {
        if (StringUtils.isBlank((CharSequence)processVariablesSearchModelDto.getProcessDefinitionId())) {
            return Collections.emptyList();
        }
        return processVariablesSearchModelDto.getVariables().stream().map((? super T variable) -> this.buildVariableWithPosition(variable.getId(), variable.getName(), variable.getValue().getExtraValueSearchModel(), this.advanceSearchVariableTypeResolver.resolveVariableExtendedType(processVariablesSearchModelDto.getProcessDefinitionId(), variable.getId()), this.advanceSearchVariableTypeResolver.isTableVariable(processVariablesSearchModelDto.getProcessDefinitionId(), variable.getId()), this.advanceSearchVariableTypeResolver.resolveVariableType(processVariablesSearchModelDto.getProcessDefinitionId(), variable.getId()))).collect(Collectors.toList());
    }

    private List<VariableWithPosition> getExtrasHeaders(ExtrasSearchModelDto extrasSearchModel) {
        LinkedList<VariableWithPosition> variableWithPositions = new LinkedList<VariableWithPosition>();
        if (extrasSearchModel.getShowAttachedDocuments() != null && this.licenseService.hasFeature("process-search-documents-preview") && extrasSearchModel.getShowAttachedDocuments().getExtraValueSearchModel().isShowColumn()) {
            variableWithPositions.add(this.buildVariableWithPosition("documentExtraColumn", this.messageHelperBean.getMessage("Dokumenty"), extrasSearchModel.getShowAttachedDocuments().getExtraValueSearchModel()));
            return variableWithPositions;
        }
        if (extrasSearchModel.getAllowAttachDocuments() != null && (this.licenseService.hasFeature("process-search-documents-attach") || this.pluginFramework.isActive("com.suncode.plugin-wizards-attach-documents")) && extrasSearchModel.getAllowAttachDocuments().getExtraValueSearchModel().isShowColumn()) {
            variableWithPositions.add(this.buildVariableWithPosition("documentExtraColumn", this.messageHelperBean.getMessage("Dokumenty"), extrasSearchModel.getAllowAttachDocuments().getExtraValueSearchModel()));
            return variableWithPositions;
        }
        return variableWithPositions;
    }

    private VariableWithPosition buildVariableWithPosition(String id, String name, ExtraValueSearchModelDto extraValueSearchModelDto) {
        return this.buildVariableWithPosition(id, name, extraValueSearchModelDto, AdvanceSearchVariableType.NORMAL, false, (Type<?>)Types.STRING);
    }

    private VariableWithPosition buildVariableWithPosition(String id, String name, ExtraValueSearchModelDto extraValueSearchModelDto, Type<?> type) {
        return this.buildVariableWithPosition(id, name, extraValueSearchModelDto, AdvanceSearchVariableType.NORMAL, false, type);
    }

    private VariableWithPosition buildVariableWithPosition(String id, String name, ExtraValueSearchModelDto extraValueSearchModelDto, AdvanceSearchVariableType variableType, boolean isTableVariable, Type<?> type) {
        return VariableWithPosition.builder().id(id).name(name).position(extraValueSearchModelDto.getPosition()).isPresent(extraValueSearchModelDto.isShowColumn()).variableType(type.name()).variableExtendedType(variableType).isTableVariable(isTableVariable).build();
    }

    @ConstructorProperties(value={"licenseService", "messageHelperBean", "advanceSearchVariableTypeResolver", "pluginFramework"})
    @Autowired
    public SearchModelToColumnMapper(LicenseService licenseService, MessageHelperBean messageHelperBean, AdvanceSearchVariableTypeResolver advanceSearchVariableTypeResolver, PluginFramework pluginFramework) {
        this.licenseService = licenseService;
        this.messageHelperBean = messageHelperBean;
        this.advanceSearchVariableTypeResolver = advanceSearchVariableTypeResolver;
        this.pluginFramework = pluginFramework;
    }

    private static class VariableComparator
    implements Comparator<VariableWithPosition> {
        private VariableComparator() {
        }

        @Override
        public int compare(VariableWithPosition var1, VariableWithPosition var2) {
            if (var1.getPosition() != null && var2.getPosition() != null) {
                return var1.getPosition().compareTo(var2.getPosition());
            }
            if (var1.getPosition() == null && var2.getPosition() == null) {
                return 0;
            }
            if (var1.getPosition() == null) {
                return 1;
            }
            return -1;
        }
    }

    private static final class VariableWithPosition {
        private final String id;
        private final String name;
        private final Integer position;
        private final boolean isPresent;
        private final String variableType;
        private final AdvanceSearchVariableType variableExtendedType;
        private final boolean isTableVariable;

        @ConstructorProperties(value={"id", "name", "position", "isPresent", "variableType", "variableExtendedType", "isTableVariable"})
        VariableWithPosition(String id, String name, Integer position, boolean isPresent, String variableType, AdvanceSearchVariableType variableExtendedType, boolean isTableVariable) {
            this.id = id;
            this.name = name;
            this.position = position;
            this.isPresent = isPresent;
            this.variableType = variableType;
            this.variableExtendedType = variableExtendedType;
            this.isTableVariable = isTableVariable;
        }

        public static VariableWithPositionBuilder builder() {
            return new VariableWithPositionBuilder();
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public Integer getPosition() {
            return this.position;
        }

        public boolean isPresent() {
            return this.isPresent;
        }

        public String getVariableType() {
            return this.variableType;
        }

        public AdvanceSearchVariableType getVariableExtendedType() {
            return this.variableExtendedType;
        }

        public boolean isTableVariable() {
            return this.isTableVariable;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VariableWithPosition)) {
                return false;
            }
            VariableWithPosition other = (VariableWithPosition)o;
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Integer this$position = this.getPosition();
            Integer other$position = other.getPosition();
            if (this$position == null ? other$position != null : !((Object)this$position).equals(other$position)) {
                return false;
            }
            if (this.isPresent() != other.isPresent()) {
                return false;
            }
            String this$variableType = this.getVariableType();
            String other$variableType = other.getVariableType();
            if (this$variableType == null ? other$variableType != null : !this$variableType.equals(other$variableType)) {
                return false;
            }
            AdvanceSearchVariableType this$variableExtendedType = this.getVariableExtendedType();
            AdvanceSearchVariableType other$variableExtendedType = other.getVariableExtendedType();
            if (this$variableExtendedType == null ? other$variableExtendedType != null : !this$variableExtendedType.equals(other$variableExtendedType)) {
                return false;
            }
            return this.isTableVariable() == other.isTableVariable();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Integer $position = this.getPosition();
            result = result * 59 + ($position == null ? 43 : ((Object)$position).hashCode());
            result = result * 59 + (this.isPresent() ? 79 : 97);
            String $variableType = this.getVariableType();
            result = result * 59 + ($variableType == null ? 43 : $variableType.hashCode());
            AdvanceSearchVariableType $variableExtendedType = this.getVariableExtendedType();
            result = result * 59 + ($variableExtendedType == null ? 43 : $variableExtendedType.hashCode());
            result = result * 59 + (this.isTableVariable() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "SearchModelToColumnMapper.VariableWithPosition(id=" + this.getId() + ", name=" + this.getName() + ", position=" + this.getPosition() + ", isPresent=" + this.isPresent() + ", variableType=" + this.getVariableType() + ", variableExtendedType=" + this.getVariableExtendedType() + ", isTableVariable=" + this.isTableVariable() + ")";
        }

        public static class VariableWithPositionBuilder {
            private String id;
            private String name;
            private Integer position;
            private boolean isPresent;
            private String variableType;
            private AdvanceSearchVariableType variableExtendedType;
            private boolean isTableVariable;

            VariableWithPositionBuilder() {
            }

            public VariableWithPositionBuilder id(String id) {
                this.id = id;
                return this;
            }

            public VariableWithPositionBuilder name(String name) {
                this.name = name;
                return this;
            }

            public VariableWithPositionBuilder position(Integer position) {
                this.position = position;
                return this;
            }

            public VariableWithPositionBuilder isPresent(boolean isPresent) {
                this.isPresent = isPresent;
                return this;
            }

            public VariableWithPositionBuilder variableType(String variableType) {
                this.variableType = variableType;
                return this;
            }

            public VariableWithPositionBuilder variableExtendedType(AdvanceSearchVariableType variableExtendedType) {
                this.variableExtendedType = variableExtendedType;
                return this;
            }

            public VariableWithPositionBuilder isTableVariable(boolean isTableVariable) {
                this.isTableVariable = isTableVariable;
                return this;
            }

            public VariableWithPosition build() {
                return new VariableWithPosition(this.id, this.name, this.position, this.isPresent, this.variableType, this.variableExtendedType, this.isTableVariable);
            }

            public String toString() {
                return "SearchModelToColumnMapper.VariableWithPosition.VariableWithPositionBuilder(id=" + this.id + ", name=" + this.name + ", position=" + this.position + ", isPresent=" + this.isPresent + ", variableType=" + this.variableType + ", variableExtendedType=" + this.variableExtendedType + ", isTableVariable=" + this.isTableVariable + ")";
            }
        }
    }
}

