/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.dto.archive;

import com.suncode.pwfl.archive.CipherAlgorithm;
import java.beans.ConstructorProperties;
import java.util.List;

public class CipherAlgorithmDto {
    private String name;
    private List<Long> allowedKeyLengths;

    public static CipherAlgorithmDto from(CipherAlgorithm cipherAlgorithm) {
        return CipherAlgorithmDto.builder().name(cipherAlgorithm.name()).allowedKeyLengths(cipherAlgorithm.getAllowedKeyLengths()).build();
    }

    @ConstructorProperties(value={"name", "allowedKeyLengths"})
    CipherAlgorithmDto(String name, List<Long> allowedKeyLengths) {
        this.name = name;
        this.allowedKeyLengths = allowedKeyLengths;
    }

    public static CipherAlgorithmDtoBuilder builder() {
        return new CipherAlgorithmDtoBuilder();
    }

    public String getName() {
        return this.name;
    }

    public List<Long> getAllowedKeyLengths() {
        return this.allowedKeyLengths;
    }

    public static class CipherAlgorithmDtoBuilder {
        private String name;
        private List<Long> allowedKeyLengths;

        CipherAlgorithmDtoBuilder() {
        }

        public CipherAlgorithmDtoBuilder name(String name) {
            this.name = name;
            return this;
        }

        public CipherAlgorithmDtoBuilder allowedKeyLengths(List<Long> allowedKeyLengths) {
            this.allowedKeyLengths = allowedKeyLengths;
            return this;
        }

        public CipherAlgorithmDto build() {
            return new CipherAlgorithmDto(this.name, this.allowedKeyLengths);
        }

        public String toString() {
            return "CipherAlgorithmDto.CipherAlgorithmDtoBuilder(name=" + this.name + ", allowedKeyLengths=" + this.allowedKeyLengths + ")";
        }
    }
}

