/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.workflow.archive;

import com.suncode.pwfl.archive.LinkConnection;
import com.suncode.pwfl.archive.LinkService;
import com.suncode.pwfl.archive.UpsertLinkConnectionDto;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.export.extension.ExportExtension;
import com.suncode.pwfl.export.model.ExportColumn;
import com.suncode.pwfl.export.model.ExportColumnBuilder;
import com.suncode.pwfl.export.model.ExportModel;
import com.suncode.pwfl.export.service.ExportService;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.util.DtoComparator;
import com.suncode.pwfl.util.Paginator;
import com.suncode.pwfl.util.exception.ServiceException;
import com.suncode.pwfl.web.dto.archive.AssociatedIndexesDto;
import com.suncode.pwfl.web.dto.archive.LinkAssociationDto;
import com.suncode.pwfl.web.dto.archive.LinkConnectionDto;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.support.ajax.RestResult;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"links/{id}/associations"})
public class LinkAssociationsController {
    @Autowired
    private AuthorizationHelper authorizationHelper;
    @Autowired
    private LinkService linkService;
    @Autowired
    private MessageHelperBean messageHelper;
    @Autowired
    private ExportService exportService;

    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<LinkAssociationDto> getAssociationsForLink(@RequestParam(required=false, defaultValue="0") Integer start, @RequestParam(required=false, defaultValue="20") Integer limit, @RequestParam(required=false, defaultValue="documentClassTranslatedName") String orderBy, @RequestParam(required=false, defaultValue="ASC") SortDirection orderDirection, @PathVariable Long id) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        List<LinkAssociationDto> associations = this.getLinkAssociationDtos(orderBy, orderDirection, id);
        return Paginator.forAll(associations).viewPageByOffset(start, limit);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"{documentClassId}"})
    @ResponseBody
    public List<LinkConnectionDto> getAssociationsBetweenLinkAndDocumentClass(@PathVariable Long id, @PathVariable Long documentClassId) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        List<LinkConnectionDto> associationsBetweenLinkAndDocumentClass = this.linkService.getConnectionsBetweenLinkAndDocumentClass(id, documentClassId, new String[]{"link", "documentClass", "linkIndex", "documentClassIndex"}).stream().map(LinkConnectionDto::fromEntity).collect(Collectors.toList());
        return associationsBetweenLinkAndDocumentClass;
    }

    private List<LinkAssociationDto> getLinkAssociationDtos(String orderBy, SortDirection orderDirection, Long id) {
        return this.linkService.getLinkConnectionsForLink(id, new String[]{"link", "documentClass", "linkIndex", "documentClassIndex"}).stream().collect(Collectors.groupingBy(linkConnection -> linkConnection.getDocumentClass().getId(), Collectors.collectingAndThen(Collectors.toList(), list -> LinkAssociationDto.from(list, ((LinkConnection)list.get(0)).getLink(), ((LinkConnection)list.get(0)).getDocumentClass())))).values().stream().sorted((Comparator<LinkAssociationDto>)DtoComparator.of(LinkAssociationDto.class, (String)orderBy, (SortDirection)orderDirection)).collect(Collectors.toList());
    }

    @RequestMapping(value={"export/{extension}"})
    @ResponseBody
    public void exportDocumentClassAssociations(HttpServletResponse response, @PathVariable Long id, @RequestParam(required=false, defaultValue="documentClassTranslatedName") String orderBy, @RequestParam(required=false, defaultValue="ASC") SortDirection orderDirection, @PathVariable String extension) throws IOException {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        List<LinkAssociationDto> linkAssociations = this.getLinkAssociationDtos(orderBy, orderDirection, id);
        List<ExportColumn> columns = Arrays.asList(ExportColumnBuilder.create().name(this.messageHelper.getMessage("Powiazana_klasa")).data(linkAssociations).by(LinkAssociationDto::getDocumentClassTranslatedName).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Powiazane_indeksy")).data(linkAssociations).by(linkAssociationDto -> this.getFormattedAssociatedIndexes(linkAssociationDto.getAssociatedIndexes(), extension)).build());
        ExportModel model = ExportModel.builder().title(this.messageHelper.getMessage("Powiazania")).columns(columns).build();
        ExportExtension extensionEnum = ExportExtension.valueOf((String)extension.toUpperCase());
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"export.%s\"", extensionEnum.getExtension()));
        this.exportService.export(model, extensionEnum, (OutputStream)response.getOutputStream());
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"{documentClassId}"})
    @ResponseBody
    public RestResult deleteLinkAssociation(HttpServletRequest request, @PathVariable Long id, @PathVariable Long documentClassId) {
        HashMap<String, Object> auditParams = new HashMap<String, Object>();
        auditParams.put("linkId", id);
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_LINK_CONNECTION).params(auditParams);
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        try {
            List associationIds = this.linkService.deleteLinkAssociationsForDocumentClass(id, documentClassId);
            auditParams.put("connectionId", associationIds.stream().map(String::valueOf).collect(Collectors.joining(",")));
            auditBuilder.params(auditParams);
        }
        catch (Exception e) {
            auditBuilder.buildFailure(request);
            throw e;
        }
        auditBuilder.buildSuccess(request);
        return new RestResult(true);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"{documentClassId}"})
    @ResponseBody
    public RestResult addLinkAssociation(HttpServletRequest request, @PathVariable Long id, @PathVariable Long documentClassId, @RequestBody List<UpsertLinkConnectionDto> associations) {
        HashMap<String, Long> auditParams = new HashMap<String, Long>();
        auditParams.put("linkId", id);
        auditParams.put("docClassId", documentClassId);
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_ADD_LINK_CONNECTION).params(auditParams);
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        try {
            this.linkService.addLinkAssociations(id, documentClassId, associations);
        }
        catch (Exception e) {
            auditBuilder.buildFailure(request);
            throw e;
        }
        auditBuilder.buildSuccess(request);
        return new RestResult(true);
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"{documentClassId}"})
    @ResponseBody
    public RestResult updateLinkAssociation(HttpServletRequest request, @PathVariable Long id, @PathVariable Long documentClassId, @RequestBody List<UpsertLinkConnectionDto> associations) {
        HashMap<String, Long> auditParams = new HashMap<String, Long>();
        auditParams.put("linkId", id);
        auditParams.put("docClassId", documentClassId);
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_EDIT_LINK_CONNECTION).params(auditParams);
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        try {
            this.linkService.updateLinkAssociations(id, documentClassId, associations);
        }
        catch (Exception e) {
            auditBuilder.buildFailure(request);
            throw e;
        }
        auditBuilder.buildSuccess(request);
        return new RestResult(true);
    }

    private String getFormattedAssociatedIndexes(List<AssociatedIndexesDto> associatedIndexes, String fileExtension) {
        String pattern = "%s -> %s";
        String delimiter = ";";
        if (fileExtension.equals("pdf")) {
            delimiter = ";\n";
        }
        return associatedIndexes.stream().map(index -> String.format("%s -> %s", index.getParentIndexName(), index.getChildIndexName())).collect(Collectors.joining(delimiter));
    }

    @ExceptionHandler(value={ServiceException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public RestResult handleServiceException(ServiceException e) {
        return new RestResult(false, e.getMessage());
    }
}

