/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.workflow.archive;

import com.google.common.collect.ImmutableMap;
import com.plusmpm.database.authorization.RightTreeBuilder;
import com.plusmpm.i18n.I18NCustom;
import com.suncode.pwfl.archive.DocumentClassIndex;
import com.suncode.pwfl.archive.DocumentClassIndexFinder;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.IndexPattern;
import com.suncode.pwfl.archive.IndexType;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.export.extension.ExportExtension;
import com.suncode.pwfl.export.model.ExportColumn;
import com.suncode.pwfl.export.model.ExportColumnBuilder;
import com.suncode.pwfl.export.model.ExportModel;
import com.suncode.pwfl.export.service.ExportService;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.util.exception.ServiceException;
import com.suncode.pwfl.web.dto.archive.DocumentClassIndexDto;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.security.exception.NoRightsException;
import com.suncode.pwfl.web.security.exception.NotFullRightsException;
import com.suncode.pwfl.web.support.DocumentClassIndexMapper;
import com.suncode.pwfl.web.support.ajax.RestResult;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"documents"})
public class DocumentClassIndexController {
    private static final Logger log = LoggerFactory.getLogger(DocumentClassIndexController.class);
    @Autowired
    private DocumentClassIndexFinder documentClassIndexFinder;
    @Autowired
    private DocumentClassService documentClassService;
    @Autowired
    private DocumentClassIndexMapper documentClassIndexMapper;
    @Autowired
    private ExportService exportService;
    @Autowired
    private MessageHelperBean messageHelper;
    @Autowired
    private AuthorizationHelper authorizationHelper;

    @ResponseBody
    @RequestMapping(value={"indexes/{documentClassId}", "classes/{documentClassId}/indexes"})
    public List<DocumentClassIndex> getDocumentClassesIndexes(@PathVariable Long documentClassId) {
        this.authorizationHelper.assertFullOrPartRights(RightTreeBuilder.builder().system().archive().docClasses().custom((Object)documentClassId).build(), () -> {});
        List docClassIndexes = this.documentClassIndexFinder.findByDocumentClass(documentClassId);
        List<DocumentClassIndex> tDocClassIndexes = docClassIndexes.stream().map(dci -> {
            TranslatedDocumentClassIndex tdci = new TranslatedDocumentClassIndex();
            BeanUtils.copyProperties((Object)dci, (Object)((Object)tdci));
            I18NCustom customTranslator = new I18NCustom(LocaleContextHolder.getLocale());
            String tName = customTranslator.getString(dci.getName());
            tdci.setNameTranslated(tName);
            String tDesc = customTranslator.getString(dci.getDescription());
            tdci.setDescriptionTranslated(tDesc);
            return tdci;
        }).collect(Collectors.toList());
        return tDocClassIndexes;
    }

    @RequestMapping(value={"classes/{documentClassId}/indices"})
    @ResponseBody
    public CountedResult<DocumentClassIndexDto> getDocumentClassIndices(@PathVariable Long documentClassId, @RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit, @RequestParam(required=false, defaultValue="orderId") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) {
        this.authorizationHelper.assertFullOrPartRights(RightTreeBuilder.builder().system().archive().docClasses().custom((Object)documentClassId).build(), () -> {});
        CountedResult docClassIndexes = this.documentClassIndexFinder.findByDocumentClass(documentClassId, start, limit, sortBy, sortDirection);
        List result = docClassIndexes.getData().stream().map(this.documentClassIndexMapper::toDocumentClassIndexDto).collect(Collectors.toList());
        return new CountedResult(docClassIndexes.getTotal(), result);
    }

    @RequestMapping(value={"classes/{documentClassId}/indices/{documentClassIndexId}"})
    @ResponseBody
    public DocumentClassIndexDto getDocumentClassIndex(@PathVariable Long documentClassId, @PathVariable Long documentClassIndexId) {
        this.authorizationHelper.assertFullOrPartRights(RightTreeBuilder.builder().system().archive().docClasses().custom((Object)documentClassId).build(), () -> {});
        DocumentClassIndex documentClassIndex = (DocumentClassIndex)this.documentClassIndexFinder.get((Serializable)documentClassIndexId);
        if (documentClassIndex == null) {
            throw new IllegalArgumentException(this.messageHelper.getMessage("Nie_znaleziono_indeksu_klasy_dokumentow", new Object[]{documentClassIndexId}));
        }
        return this.documentClassIndexMapper.toDocumentClassIndexDto(documentClassIndex);
    }

    @RequestMapping(value={"classes/{documentClassId}/indices/{documentClassIndexId}/canBeEdited"})
    @ResponseBody
    public RestResult canDocumentClassIndexBeEdited(@PathVariable Long documentClassId, @PathVariable Long documentClassIndexId) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        DocumentClassIndex documentClassIndex = (DocumentClassIndex)this.documentClassIndexFinder.get((Serializable)documentClassIndexId);
        if (documentClassIndex == null) {
            throw new IllegalArgumentException(this.messageHelper.getMessage("Nie_znaleziono_indeksu_klasy_dokumentow", new Object[]{documentClassIndexId}));
        }
        try {
            this.documentClassService.validateDocumentClassIndexCanBeEdited(documentClassIndex);
        }
        catch (ServiceException e) {
            return new RestResult(false, e.getMessage());
        }
        return new RestResult(true);
    }

    @RequestMapping(value={"classes/{documentClassId}/indices/types"})
    @ResponseBody
    public List<String> getIndexTypes(@PathVariable Long documentClassId) {
        return Arrays.asList(IndexType.values()).stream().map(IndexType::toString).collect(Collectors.toList());
    }

    @ResponseBody
    @RequestMapping(value={"classes/{documentClassId}/indexes/add", "classes/{documentClassId}/indices/add"}, method={RequestMethod.POST})
    public ResponseEntity<RestResult> addDocumentClassIndex(HttpServletRequest request, @PathVariable Long documentClassId, @RequestBody DocumentClassIndexDto docClassIndexDto) {
        HashMap<String, Object> auditParams = new HashMap<String, Object>();
        auditParams.put("docclassId", StringUtils.defaultIfEmpty((CharSequence)documentClassId.toString(), (CharSequence)""));
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_ADD_DOC_CLASS_INDEX).params(auditParams);
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        try {
            DocumentClassIndex documentClassIndex = this.documentClassIndexMapper.toEntity(docClassIndexDto);
            auditParams.putAll(this.createAddIndexAuditParams(documentClassIndex));
            auditBuilder.params(auditParams);
            this.documentClassService.addIndexToDocumentClass(documentClassId, documentClassIndex);
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
            return new ResponseEntity((Object)new RestResult(true), HttpStatus.OK);
        }
        catch (Exception ex) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw ex;
        }
    }

    @ResponseBody
    @RequestMapping(value={"classes/{documentClassId}/indexes/update", "classes/{documentClassId}/indices/update"}, method={RequestMethod.POST})
    public ResponseEntity<?> updateDocumentClassIndex(HttpServletRequest request, @RequestBody DocumentClassIndexDto docClassIndexDto, @PathVariable(value="documentClassId") Long documentClassId) {
        HashMap<String, Object> auditParams = new HashMap<String, Object>();
        auditParams.put("docclassId", StringUtils.defaultIfEmpty((CharSequence)documentClassId.toString(), (CharSequence)""));
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_UPDATE_DOC_CLASS_INDEX).params(auditParams);
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        if (this.documentClassIndexFinder.get((Serializable)docClassIndexDto.getId()) == null) {
            throw new IllegalArgumentException(this.messageHelper.getMessage("Indeks_klasy_dokumentu_nie_istnieje", new Object[]{docClassIndexDto.getId()}));
        }
        try {
            DocumentClassIndex documentClassIndex = this.documentClassIndexMapper.toEntity(docClassIndexDto);
            auditParams.putAll(this.createUpdateIndexAuditParams(documentClassIndex));
            auditBuilder.params(auditParams);
            DocumentClassIndex updatedIndex = this.documentClassService.updateIndexInDocumentClass(documentClassId, documentClassIndex);
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
            return new ResponseEntity((Object)this.documentClassIndexMapper.toDocumentClassIndexDto(updatedIndex), HttpStatus.OK);
        }
        catch (Exception ex) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw ex;
        }
    }

    @RequestMapping(value={"classes/{documentClassId}/indexes/{documentClassIndexId}", "classes/{documentClassId}/indices/{documentClassIndexId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public RestResult deleteDocumentClassIndex(HttpServletRequest request, @PathVariable Long documentClassId, @PathVariable Long documentClassIndexId) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_DOC_CLASS_INDEX).params((Map)ImmutableMap.of((Object)"docclassId", (Object)documentClassId, (Object)"indexId", (Object)documentClassIndexId));
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        this.documentClassService.deleteDocumentClassIndex(documentClassIndexId);
        request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
        return new RestResult(true);
    }

    @RequestMapping(value={"classes/{documentClassId}/indexes/{documentClassIndexId}/moveUp", "classes/{documentClassId}/indices/{documentClassIndexId}/moveUp"})
    @ResponseBody
    public void moveUpDocumentClassIndex(@PathVariable Long documentClassId, @PathVariable Long documentClassIndexId) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        this.documentClassService.moveUpDocumentClassIndex(documentClassIndexId);
    }

    @RequestMapping(value={"classes/{documentClassId}/indices/export/{extension}"})
    @ResponseBody
    public void exportDocumentClassIndices(HttpServletResponse response, @PathVariable Long documentClassId, @PathVariable String extension, @RequestParam(required=false, defaultValue="orderId") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) throws IOException {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        List docClassIndexes = this.documentClassIndexFinder.findByDocumentClass(documentClassId, null, null, sortBy, sortDirection).getData().stream().map(this.documentClassIndexMapper::toDocumentClassIndexDto).map(docClassIndex -> {
            docClassIndex.setType(this.messageHelper.getMessage("IndexType_" + docClassIndex.getType()));
            return docClassIndex;
        }).collect(Collectors.toList());
        List<ExportColumn> columns = Arrays.asList(ExportColumnBuilder.create().name(this.messageHelper.getMessage("Nazwa_indeksu")).data(docClassIndexes).by(DocumentClassIndexDto::getTranslatedName).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Opis_indeksu")).data(docClassIndexes).by(DocumentClassIndexDto::getTranslatedDescription).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Typ_indeksu")).data(docClassIndexes).by(DocumentClassIndexDto::getType).build());
        ExportModel model = ExportModel.builder().title(this.messageHelper.getMessage("Indeksy")).columns(columns).build();
        ExportExtension extensionEnum = ExportExtension.valueOf((String)extension.toUpperCase());
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"export.%s\"", extensionEnum.getExtension()));
        this.exportService.export(model, extensionEnum, (OutputStream)response.getOutputStream());
    }

    private Map<String, Object> createAddIndexAuditParams(DocumentClassIndex index) {
        return ImmutableMap.builder().put((Object)"indexName", (Object)StringUtils.defaultIfEmpty((CharSequence)index.getName(), (CharSequence)"")).put((Object)"indexDescription", (Object)StringUtils.defaultIfEmpty((CharSequence)index.getDescription(), (CharSequence)"")).put((Object)"indexType", (Object)StringUtils.defaultIfEmpty((CharSequence)index.getType().toString(), (CharSequence)"")).put((Object)"indexValue", (Object)StringUtils.defaultIfEmpty((CharSequence)index.getValues(), (CharSequence)"")).put((Object)"indexPattern", (Object)this.buildIndexPatternAuditParam(index.getPatterns())).build();
    }

    private String buildIndexPatternAuditParam(List<IndexPattern> patterns) {
        return patterns.stream().map(pattern -> pattern.getPattern() + "->" + pattern.getReplacement() + "(regex=" + pattern.getIsRegex() + ")").collect(Collectors.joining("; "));
    }

    private Map<String, Object> createUpdateIndexAuditParams(DocumentClassIndex index) {
        DocumentClassIndex oldIndex = this.documentClassIndexFinder.findById(index.getId());
        return ImmutableMap.builder().put((Object)"indexName", (Object)this.buildIndexAuditParam(oldIndex.getName(), index.getName())).put((Object)"indexDescription", (Object)this.buildIndexAuditParam(oldIndex.getDescription(), index.getDescription())).put((Object)"indexType", (Object)(oldIndex.getType() + ";" + index.getType())).put((Object)"indexValue", (Object)this.buildIndexAuditParamChange(oldIndex.getValues(), index.getValues())).put((Object)"indexPattern", (Object)this.buildIndexAuditParamChange(this.buildIndexPatternAuditParam(oldIndex.getPatterns()), this.buildIndexPatternAuditParam(index.getPatterns()))).build();
    }

    private String buildIndexAuditParam(String oldValue, String newValue) {
        return (String)StringUtils.defaultIfEmpty((CharSequence)oldValue, (CharSequence)"") + ";" + (String)StringUtils.defaultIfEmpty((CharSequence)newValue, (CharSequence)"");
    }

    private String buildIndexAuditParamChange(String oldValue, String newValue) {
        return (String)StringUtils.defaultIfEmpty((CharSequence)oldValue, (CharSequence)"") + " > " + (String)StringUtils.defaultIfEmpty((CharSequence)newValue, (CharSequence)"");
    }

    @ExceptionHandler(value={IllegalArgumentException.class, ServiceException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public RestResult handleBadRequests(Exception e) {
        log.error("", (Throwable)e);
        return new RestResult(false, e.getMessage());
    }

    @ExceptionHandler(value={NotFullRightsException.class, NoRightsException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public RestResult handleNotFullRightsException(Exception e) {
        return new RestResult(false, this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
    }

    private class TranslatedDocumentClassIndex
    extends DocumentClassIndex {
        private String nameTranslated;
        private String descriptionTranslated;

        private TranslatedDocumentClassIndex() {
        }

        public String getNameTranslated() {
            return this.nameTranslated;
        }

        public String getDescriptionTranslated() {
            return this.descriptionTranslated;
        }

        public void setNameTranslated(String nameTranslated) {
            this.nameTranslated = nameTranslated;
        }

        public void setDescriptionTranslated(String descriptionTranslated) {
            this.descriptionTranslated = descriptionTranslated;
        }
    }
}

