/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.workflow.activity;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.plusmpm.database.workflow.activities.ActivityMisc;
import com.plusmpm.i18n.I18Nxpdl;
import com.plusmpm.parser.wrapper.XpdlKey;
import com.plusmpm.util.SharkFunctions;
import com.plusmpm.util.XpdlPackageManager;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.export.extension.ExportExtension;
import com.suncode.pwfl.export.model.ExportColumn;
import com.suncode.pwfl.export.model.ExportColumnBuilder;
import com.suncode.pwfl.export.model.ExportModel;
import com.suncode.pwfl.export.service.ExportService;
import com.suncode.pwfl.form.service.FormService;
import com.suncode.pwfl.form.util.object.ActivityAcceptance;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.language.LanguageUtils;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.transaction.SharkTransactionManager;
import com.suncode.pwfl.transaction.support.SharkTransactionCallback;
import com.suncode.pwfl.util.SharkUtils;
import com.suncode.pwfl.util.exception.ServiceException;
import com.suncode.pwfl.web.dto.activity.AcceptActivityDto;
import com.suncode.pwfl.web.dto.activity.ActivityContextDto;
import com.suncode.pwfl.web.dto.activity.ActivityDto;
import com.suncode.pwfl.web.dto.activity.DisplayFieldDto;
import com.suncode.pwfl.web.dto.activity.FieldDto;
import com.suncode.pwfl.web.dto.activity.UserActivitiesDto;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.security.exception.NotFullRightsException;
import com.suncode.pwfl.web.support.ajax.ResponseMessageLevel;
import com.suncode.pwfl.web.support.ajax.RestResponse;
import com.suncode.pwfl.web.util.SessionUtils;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityFinder;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.activity.exception.ActivityAlreadyCompletedException;
import com.suncode.pwfl.workflow.activity.exception.ActivityIsNotSuspendedException;
import com.suncode.pwfl.workflow.activity.exception.ActivityIsSuspendedException;
import com.suncode.pwfl.workflow.activity.exception.UserIsNotAssignedToActivityException;
import com.suncode.pwfl.workflow.activity.sequential.SequentialMode;
import com.suncode.pwfl.workflow.variable.type.ExtAttrUtils;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.UserTransaction;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.client.wfmodel.WfActivity;
import org.enhydra.shark.api.client.wfservice.ConnectFailed;
import org.enhydra.shark.api.client.wfservice.NotConnected;
import org.enhydra.shark.xpdl.elements.DataField;
import org.enhydra.shark.xpdl.elements.ExtendedAttributes;
import org.enhydra.shark.xpdl.elements.Package;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/activities"})
public class ActivityController {
    private static final Logger log = LoggerFactory.getLogger(ActivityController.class);
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final ActivityService activityService;
    private final ActivityFinder activityFinder;
    private final FormService formService;
    private final SharkTransactionManager sharkTransactionManager;
    private final ExportService exportService;
    private final AuthorizationHelper authorizationHelper;
    private final MessageHelperBean messageHelper;

    @RequestMapping(value={"my"})
    @ResponseBody
    public CountedResult<ActivityDto> getMyActivities(@RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit, @RequestParam(required=false, defaultValue="false") boolean isMobile) {
        String userId = SessionUtils.getLoggedUserName();
        CountedResult activities = isMobile ? this.activityFinder.findMobileActivitiesForUser(userId, start, limit) : this.activityFinder.findActivitiesAssignedToUser(userId, start, limit, new String[]{"process", "process.processDefinition"});
        return ActivityDto.build((CountedResult<Activity>)activities);
    }

    @RequestMapping(value={"my/new"})
    @ResponseBody
    public CountedResult<UserActivitiesDto> getMyNewActivities(@RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit, @RequestParam(required=false, defaultValue="actstarttime") String sortBy, @RequestParam(required=false, defaultValue="DESC") SortDirection sortDirection) {
        return this.getNewActivitiesAssignedToUser(sortBy, sortDirection, start, limit);
    }

    @ResponseBody
    @RequestMapping(value={"my/new/export/{extension}"})
    public void exportNewActivities(HttpServletResponse response, @PathVariable String extension, @RequestParam(required=false) String sortBy, @RequestParam(required=false) SortDirection sortDirection) throws IOException, BaseException {
        CountedResult<UserActivitiesDto> assignments = this.getNewActivitiesAssignedToUser(sortBy, sortDirection, 0, Integer.MAX_VALUE);
        this.exportUserAssignments(assignments.getData(), extension, response);
    }

    @RequestMapping(value={"my/open"})
    @ResponseBody
    public CountedResult<UserActivitiesDto> getActivitiesAssignedToUser(@RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit, @RequestParam(required=false, defaultValue="actstarttime") String sortBy, @RequestParam(required=false, defaultValue="DESC") SortDirection sortDirection) {
        return this.getAllActivitiesAssignedToUser(sortBy, sortDirection, start, limit);
    }

    @ResponseBody
    @RequestMapping(value={"my/open/export/{extension}"})
    public void exportProcessingFinishedActivities(HttpServletResponse response, @PathVariable String extension, @RequestParam(required=false) String sortBy, @RequestParam(required=false) SortDirection sortDirection) throws IOException, BaseException {
        CountedResult<UserActivitiesDto> assignments = this.getAllActivitiesAssignedToUser(sortBy, sortDirection, 0, Integer.MAX_VALUE);
        this.exportUserAssignments(assignments.getData(), extension, response);
    }

    private CountedResult<UserActivitiesDto> getNewActivitiesAssignedToUser(String sortBy, SortDirection sortDirection, int start, int limit) {
        String userName = SessionUtils.getLoggedUserName();
        int total = ActivityMisc.countNewActivitiesAssignedToUser((String)userName);
        String orderBy = String.format(" ORDER BY %s %s ", sortBy, sortDirection);
        List assignments = ActivityMisc.getNewActivitiesAssignedToUser((String)userName, (String)orderBy, (int)start, (int)limit).stream().map(UserActivitiesDto::build).collect(Collectors.toList());
        return new CountedResult((long)total, assignments);
    }

    private CountedResult<UserActivitiesDto> getAllActivitiesAssignedToUser(String sortBy, SortDirection sortDirection, int start, int limit) {
        String userName = SessionUtils.getLoggedUserName();
        int total = ActivityMisc.countActivitiesAssignedToUser((String)userName, (long)0L, null, null);
        String orderBy = String.format(" ORDER BY %s %s ", sortBy, sortDirection);
        List assignments = ActivityMisc.getActivitiesAssignedToUser((String)userName, (String)orderBy, (int)start, (int)limit, (long)0L, null, null).stream().map(UserActivitiesDto::build).collect(Collectors.toList());
        return new CountedResult((long)total, assignments);
    }

    private void exportUserAssignments(List<UserActivitiesDto> assignments, String extension, HttpServletResponse response) throws IOException, BaseException {
        List<ExportColumn> columns = Arrays.asList(ExportColumnBuilder.create().name(this.messageHelper.getMessage("Nazwa_procesu")).data(assignments).by(UserActivitiesDto::getProcessName).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Opis_procesu")).data(assignments).by(UserActivitiesDto::getProcessDescription).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Nazwa_zadania")).data(assignments).by(UserActivitiesDto::getActivityName).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Data_przyjscia")).data(assignments).by(assignment -> dateFormat.format(assignment.getActivityStart())).build());
        String userName = Shark.getInstance().getAdminInterface().getUserGroupAdministration().getUserRealName(SessionUtils.getLoggedUserName());
        String title = String.format("%s: %s", this.messageHelper.getMessage("Zadania_przypisane_dla_uzytkownika"), userName);
        ExportModel model = ExportModel.builder().title(title).columns(columns).build();
        ExportExtension extensionEnum = ExportExtension.valueOf((String)extension.toUpperCase());
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"export.%s\"", extensionEnum.getExtension()));
        this.exportService.export(model, extensionEnum, (OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"my/executed"})
    @ResponseBody
    public CountedResult<ActivityDto> getMyExecutedActivities(@RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit) {
        String userId = SessionUtils.getLoggedUserName();
        CountedResult activities = this.activityFinder.findActivitiesExecutedByUser(userId, start, limit, new String[]{"process", "process.processDefinition"});
        return ActivityDto.build((CountedResult<Activity>)activities);
    }

    @RequestMapping(value={"{processId}/{activityId}"})
    @ResponseBody
    public ActivityDto getActivity(@PathVariable String processId, @PathVariable String activityId, HttpServletResponse response) {
        return (ActivityDto)this.authorizationHelper.ensureProcessAccess(processId, null, () -> {
            Activity activity = this.activityService.getActivity(processId, activityId, new String[]{"process", "process.processDefinition"});
            if (activity == null) {
                response.setStatus(404);
                return null;
            }
            return ActivityDto.build(activity);
        }).getBody();
    }

    @RequestMapping(value={"accept"}, method={RequestMethod.POST})
    @ResponseBody
    public ActivityAcceptance acceptActivity(HttpSession session, @RequestBody AcceptActivityDto accept) {
        String userName = SessionUtils.getLoggedUserName();
        ActivityAcceptance acceptance = new ActivityAcceptance();
        try {
            acceptance = this.formService.accept(acceptance, accept.getProcessId(), accept.getActivityId(), accept.getActionName(), userName, null, this.buildVariables(accept.getContextMap()), true, LocaleContextHolder.getLocale(), "", (Set)Sets.newHashSet(), session.getId(), SequentialMode.DEFAULT, null, null, accept.getOverrideAcceptConcurrently());
        }
        catch (Exception e) {
            log.error("Error occurred during acceptation", (Throwable)e);
        }
        this.formService.skipValidatorCallbacks(acceptance);
        return acceptance;
    }

    @RequestMapping(value={"context"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, Object> getActivityContext(@RequestParam String activityId, final @RequestParam String processId, @RequestParam(required=false) boolean extended) throws TransactionException {
        return (Map)this.authorizationHelper.ensureProcessAccess(processId, null, () -> {
            final Map activityContext = this.activityService.getActivityContext(processId, activityId);
            if (!extended) {
                return activityContext;
            }
            TransactionTemplate tx = new TransactionTemplate((PlatformTransactionManager)this.sharkTransactionManager);
            return (Map)tx.execute((TransactionCallback)new SharkTransactionCallback<Map<String, Object>>(){

                public Map<String, Object> doInSharkTransaction(SharkTransaction transaction, TransactionStatus status) throws Exception {
                    UserTransaction userTransaction = ActivityController.this.sharkTransactionManager.getUserTransaction();
                    return ActivityController.this.getExtendedActivityContext(activityContext, transaction, processId, userTransaction);
                }
            });
        }).getBody();
    }

    private Map<String, Object> getExtendedActivityContext(Map<String, Object> activityContext, SharkTransaction transaction, String processId, UserTransaction userTransaction) throws BaseException, ConnectFailed, NotConnected {
        Package processPackage = XpdlPackageManager.getInstance().getPackageByProcessId(transaction, processId);
        String processDefId = SharkFunctions.getProcessDefId((SharkTransaction)transaction, (String)processId);
        for (String key : activityContext.keySet()) {
            this.extendActivityContext(processPackage, processDefId, key, activityContext, userTransaction);
        }
        return activityContext;
    }

    private void extendActivityContext(Package processPackage, String processDefId, String key, Map<String, Object> activityContext, UserTransaction userTransaction) throws BaseException {
        DataField dataField = processPackage.getWorkflowProcess(processDefId).getDataField(key);
        Object contextValue = activityContext.get(key);
        if (dataField != null) {
            activityContext.put(key, this.buildField(dataField, contextValue, userTransaction));
        } else {
            activityContext.put(key, new FieldDto(contextValue));
        }
    }

    private FieldDto buildField(DataField dataField, Object contextValue, UserTransaction userTransaction) throws BaseException {
        ExtendedAttributes extendedAttributes = dataField.getExtendedAttributes();
        if (ExtAttrUtils.hasExtAttr((ExtendedAttributes)extendedAttributes, (String)"EXTYPE", (String)"USERNAME")) {
            String userName = (String)contextValue;
            String realName = Shark.getInstance().getAdminInterface().getUserGroupAdministration().getUserRealName(userTransaction, userName);
            return new DisplayFieldDto(userName, realName);
        }
        return new FieldDto(contextValue);
    }

    @RequestMapping(value={"context"}, method={RequestMethod.POST})
    @ResponseBody
    public void setActivityContext(@RequestBody ActivityContextDto ctx) {
        this.authorizationHelper.ensureProcessAccess(ctx.getProcessId(), null, () -> {
            this.activityService.setActivityContext(ctx.getProcessId(), ctx.getActivityId(), ctx.getContextMap());
            return null;
        });
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST})
    @ResponseBody
    public void save(@RequestBody ActivityContextDto ctx) {
        String userName = SessionUtils.getLoggedUserName();
        this.formService.save(ctx.getProcessId(), ctx.getActivityId(), userName, this.buildVariables(ctx.getContextMap()), LocaleContextHolder.getLocale());
    }

    private Map<String, String[]> buildVariables(Map<String, Object> contextMap) {
        HashMap<String, String[]> vars = new HashMap<String, String[]>();
        for (String id : contextMap.keySet()) {
            String value = Optional.ofNullable(contextMap.get(id)).map(Object::toString).orElse(null);
            vars.put(id, new String[]{value});
        }
        return vars;
    }

    @RequestMapping(value={"open"})
    @ResponseBody
    public void openActivity(@RequestParam String activityId, @RequestParam String processId) throws UserIsNotAssignedToActivityException, ActivityAlreadyCompletedException, ActivityIsSuspendedException {
        String userName = SessionUtils.getLoggedUserName();
        this.activityService.openActivity(userName, processId, activityId);
    }

    @RequestMapping(value={"opened"}, method={RequestMethod.GET})
    @ResponseBody
    public List<ActivityDto> getOpenedActivities(@RequestParam String processId) {
        return (List)this.authorizationHelper.ensureProcessAccess(processId, null, () -> this.activityService.getOpenActivitiesForProcess(processId).stream().map(ActivityDto::build).collect(Collectors.toList())).getBody();
    }

    @RequestMapping(value={"autocomplete"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public String doAutocomplete() {
        return "";
    }

    @RequestMapping(value={"suspend"})
    @ResponseBody
    public RestResponse<?> suspendActivity(HttpServletRequest request, @RequestParam String activityId, @RequestParam String processId) {
        AuditBuilder auditBuilder = this.buildAudit(processId, activityId, AuditTypes.AUDIT_SUSPEND_ACTIVITY);
        this.authorizationHelper.assertFullSystemRights(() -> request.setAttribute("audit", (Object)auditBuilder.buildFailure()));
        try {
            this.activityService.suspendActivity(activityId, processId, false);
            String message = this.prepareActivityActionSuccessMessage(activityId, processId, this.messageHelper.getMessage("zostalo_zawieszone"), new I18Nxpdl(request));
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
            return new RestResponse(message, ResponseMessageLevel.SUCCESS);
        }
        catch (ActivityAlreadyCompletedException e) {
            String message = this.messageHelper.getMessage("activity.suspend.alreadycompleted.message");
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
            return new RestResponse(message, ResponseMessageLevel.INFO);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    @RequestMapping(value={"resume"})
    @ResponseBody
    public RestResponse<?> resumeActivity(HttpServletRequest request, @RequestParam String activityId, @RequestParam String processId) {
        AuditBuilder auditBuilder = this.buildAudit(processId, activityId, AuditTypes.AUDIT_RESUME_ACTIVITY);
        this.authorizationHelper.assertFullSystemRights(() -> request.setAttribute("audit", (Object)auditBuilder.buildFailure()));
        try {
            this.activityService.resumeActivity(activityId, processId, false);
            String message = this.prepareActivityActionSuccessMessage(activityId, processId, this.messageHelper.getMessage("zostalo_przywrocone"), new I18Nxpdl(request));
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
            return new RestResponse(message, ResponseMessageLevel.SUCCESS);
        }
        catch (ActivityIsNotSuspendedException e) {
            String message = this.messageHelper.getMessage("activity.resume.notsuspended.message");
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
            return new RestResponse(message, ResponseMessageLevel.INFO);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    @RequestMapping(value={"abort"})
    @ResponseBody
    public RestResponse<?> abortActivity(HttpServletRequest request, @RequestParam String activityId, @RequestParam String processId) {
        AuditBuilder auditBuilder = this.buildAudit(processId, activityId, AuditTypes.AUDIT_ABORT_ACTIVITY);
        this.authorizationHelper.assertFullSystemRights(() -> request.setAttribute("audit", (Object)auditBuilder.buildFailure()));
        try {
            this.activityService.abort(processId, activityId);
            String message = this.prepareActivityActionSuccessMessage(activityId, processId, this.messageHelper.getMessage("zostalo_anulowane"), new I18Nxpdl(request));
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
            return new RestResponse(message, ResponseMessageLevel.SUCCESS);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    private String prepareActivityActionSuccessMessage(String activityId, String processId, String suffix, I18Nxpdl xpdl) {
        String translatedActivityName;
        String translatedProcessName;
        try {
            WfActivity wfActivity = SharkUtils.getExecutionAdministration().getActivity(processId, activityId);
            String processName = wfActivity.container().name();
            String processDefinitionId = SharkFunctions.getProcessDefId((String)processId);
            translatedProcessName = LanguageUtils.getProcessName((I18Nxpdl)xpdl, (String)processName, (String)processDefinitionId);
            String activityDefinitionId = SharkFunctions.getActivityDefId((String)processId, (String)activityId);
            String packageId = XpdlPackageManager.getInstance().getPackageIdByProcessDefinitionId(processDefinitionId);
            translatedActivityName = xpdl.getString(XpdlKey.forPackage((String)packageId).forProcess(processDefinitionId).forActivity(activityDefinitionId).getKey());
        }
        catch (Exception e) {
            translatedActivityName = activityId;
            translatedProcessName = processId;
        }
        StringBuilder messageBuilder = new StringBuilder();
        String EMPTY_CHAR = " ";
        return messageBuilder.append(this.messageHelper.getMessage("Zadanie")).append(EMPTY_CHAR).append(translatedActivityName).append(EMPTY_CHAR).append(this.messageHelper.getMessage("z_procesu")).append(EMPTY_CHAR).append(translatedProcessName).append(EMPTY_CHAR).append(suffix).toString();
    }

    @ExceptionHandler(value={NotFullRightsException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public RestResponse<?> handleNotFullRightsException(NotFullRightsException e) {
        return new RestResponse(this.messageHelper.getMessage("activity.action.error.forbidden.message"), ResponseMessageLevel.ERROR);
    }

    @ExceptionHandler(value={ServiceException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public RestResponse<?> handleServiceException(ServiceException e) {
        return new RestResponse(e.getMessage(), ResponseMessageLevel.ERROR);
    }

    private AuditBuilder buildAudit(String processId, String activityId, AuditTypes auditType) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(auditType);
        ImmutableMap params = ImmutableMap.builder().put((Object)"ProcessId", (Object)processId).put((Object)"ActivityId", (Object)activityId).build();
        auditBuilder.params((Map)params);
        return auditBuilder;
    }

    @ConstructorProperties(value={"activityService", "activityFinder", "formService", "sharkTransactionManager", "exportService", "authorizationHelper", "messageHelper"})
    @Autowired
    public ActivityController(ActivityService activityService, ActivityFinder activityFinder, FormService formService, SharkTransactionManager sharkTransactionManager, ExportService exportService, AuthorizationHelper authorizationHelper, MessageHelperBean messageHelper) {
        this.activityService = activityService;
        this.activityFinder = activityFinder;
        this.formService = formService;
        this.sharkTransactionManager = sharkTransactionManager;
        this.exportService = exportService;
        this.authorizationHelper = authorizationHelper;
        this.messageHelper = messageHelper;
    }
}

