/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.scheduledtasks;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.plusmpm.database.scheduledTasks.ScheduledTaskCategory;
import com.plusmpm.database.scheduledTasks.ScheduledTasksParametersTable;
import com.plusmpm.database.scheduledTasks.ScheduledTasksTable;
import com.plusmpm.database.scheduledTasks.dao.ScheduledTaskCategoryDAO;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskMethodDto;
import com.suncode.pwfl.administration.scheduledtask.parameter.ScheduledTaskParameterFinder;
import com.suncode.pwfl.administration.scheduledtask.service.ScheduledTaskHelper;
import com.suncode.pwfl.administration.scheduledtask.service.ScheduledTaskMethodFinder;
import com.suncode.pwfl.administration.scheduledtask.service.ScheduledTaskMethodParameter;
import com.suncode.pwfl.administration.scheduledtask.service.ScheduledTaskService;
import com.suncode.pwfl.config.tomcat.ServerMode;
import com.suncode.pwfl.config.tomcat.TomcatService;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.web.controller.api.scheduledtasks.ScheduledTaskParameterBuilder;
import com.suncode.pwfl.web.controller.api.scheduledtasks.dto.ParameterInfo;
import com.suncode.pwfl.web.controller.api.scheduledtasks.exception.ScheduledTaskNotAvailableException;
import com.suncode.pwfl.web.controller.api.scheduledtasks.method.ScheduledTaskReceivedParametersValidator;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"scheduledtasks"})
public class NewScheduledTaskController {
    private static final Logger log = LoggerFactory.getLogger(NewScheduledTaskController.class);
    @Autowired
    private ScheduledTaskService scheduledTaskService;
    @Autowired
    private ScheduledTaskHelper scheduledTaskHelper;
    @Autowired
    private ScheduledTaskParameterFinder scheduledTaskParameterFinder;
    @Autowired
    private ScheduledTaskMethodFinder scheduledTaskMethodFinder;
    @Autowired
    private ScheduledTaskParameterBuilder scheduledTaskParameterBuilder;
    @Autowired
    private ScheduledTaskReceivedParametersValidator scheduledTaskReceivedParametersValidator;
    @Autowired
    private AuthorizationHelper authorizationHelper;
    @Autowired
    private TomcatService tomcatService;
    private ObjectMapper objectMapper = new ObjectMapper();
    private TypeReference<LinkedList<ParameterInfo>> parameterInfoType = new TypeReference<LinkedList<ParameterInfo>>(){};

    @RequestMapping(value={"available"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<CountedResult<ScheduledTaskMethodDto>> findScheduledTasks(@RequestParam(required=false) String className) {
        if (this.tomcatService.getTomcatInstanceParameters().getServerMode() == ServerMode.SLAVE) {
            return new ResponseEntity(HttpStatus.FORBIDDEN);
        }
        try {
            this.authorizationHelper.assertFullAdministrationRights(() -> {});
            List methodsInfo = StringUtils.isNotBlank((CharSequence)className) ? this.scheduledTaskMethodFinder.findScheduledTaskMethods(className) : this.scheduledTaskMethodFinder.findScheduledTaskMethods();
            CountedResult result = new CountedResult();
            result.setData(methodsInfo);
            result.setTotal((long)methodsInfo.size());
            return new ResponseEntity((Object)result, HttpStatus.OK);
        }
        catch (ClassNotFoundException e) {
            log.info("Nie znaleziono szukanej klasy");
            return new ResponseEntity(HttpStatus.BAD_REQUEST);
        }
        catch (Exception e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"new"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Map<String, Object>> saveNewScheduledTask(@RequestParam String name, @RequestParam String description, @RequestParam(required=false) String method, @RequestParam String className, @RequestParam String params, @RequestParam(required=false) String categoryName, @RequestParam(required=false) Long categoryId, @RequestParam String firstRun, @RequestParam(required=false) String executeOnce, @RequestParam(required=false) Long periodValue, @RequestParam(required=false) String periodUnit, @RequestParam(required=false) String active, @RequestParam(required=false) String saveHistory) {
        if (this.tomcatService.getTomcatInstanceParameters().getServerMode() == ServerMode.SLAVE) {
            return new ResponseEntity(HttpStatus.FORBIDDEN);
        }
        log.info("Dodawanie nowego zadania zaplanowanego...");
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(2);
        try {
            this.authorizationHelper.assertFullAdministrationRights(() -> {});
            if (this.scheduledTaskHelper.isComponent(className)) {
                method = "execute";
            }
            List dtoParamList = (List)this.objectMapper.readValue(params, this.parameterInfoType);
            List queryMethodParameters = dtoParamList.stream().sorted(Comparator.comparing(ParameterInfo::getPosition)).map(parameterInfo -> new ScheduledTaskMethodParameter(parameterInfo.getPosition(), parameterInfo.getType())).collect(Collectors.toList());
            ScheduledTaskMethodDto methodDto = (ScheduledTaskMethodDto)this.scheduledTaskMethodFinder.findScheduledTaskMethod(className, method, queryMethodParameters).orElseThrow(() -> new ScheduledTaskNotAvailableException("Could not find method"));
            this.scheduledTaskReceivedParametersValidator.validateReceivedParametersAgainstMethod(dtoParamList, methodDto, true);
            SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date firstRunDate = dateFormatter.parse(firstRun);
            Long period = null;
            if (periodValue != null && periodUnit != null) {
                switch (periodUnit) {
                    case "minute": {
                        period = TimeUnit.MINUTES.toMillis(periodValue);
                        break;
                    }
                    case "hour": {
                        period = TimeUnit.HOURS.toMillis(periodValue);
                        break;
                    }
                    case "day": {
                        period = TimeUnit.DAYS.toMillis(periodValue);
                        break;
                    }
                    case "month": {
                        period = TimeUnit.DAYS.toMillis(periodValue) * 30L;
                    }
                }
            }
            ScheduledTaskCategory taskCategory = null;
            if (categoryId != null) {
                taskCategory = ScheduledTaskCategoryDAO.get((Long)categoryId);
            } else if (StringUtils.isNotBlank((CharSequence)categoryName) && (taskCategory = ScheduledTaskCategoryDAO.getByName((String)categoryName)) == null) {
                taskCategory = new ScheduledTaskCategory(categoryName);
                ScheduledTaskCategoryDAO.save((ScheduledTaskCategory)taskCategory);
            }
            boolean runOnce = StringUtils.equals((CharSequence)executeOnce, (CharSequence)"on");
            boolean isActive = StringUtils.equals((CharSequence)active, (CharSequence)"on");
            boolean logHistory = StringUtils.equals((CharSequence)saveHistory, (CharSequence)"on");
            ScheduledTasksTable task = new ScheduledTasksTable(name, description, Boolean.valueOf(isActive), className, method, firstRunDate, firstRunDate, null, Boolean.valueOf(runOnce), period, Boolean.valueOf(logHistory), taskCategory);
            task.setScheduled_tasks_parameters(this.scheduledTaskParameterBuilder.buildTaskParameters(dtoParamList, task));
            this.appendRemainingParameters(task, methodDto);
            this.scheduledTaskService.addScheduledTask(task);
            log.info("Zadanie zaplanowane zosta\u0142o dodane.");
            result.put("success", true);
            return new ResponseEntity(result, HttpStatus.OK);
        }
        catch (Exception e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            result.put("success", false);
            return new ResponseEntity(result, HttpStatus.OK);
        }
    }

    private void appendRemainingParameters(ScheduledTasksTable newEntity, ScheduledTaskMethodDto methodDto) {
        List newParameterEntities = newEntity.getScheduled_tasks_parameters();
        for (ScheduledTaskMethodDto.Parameter parameterDto : methodDto.getParameters()) {
            Optional newParameterEntityOpt = this.scheduledTaskParameterFinder.findInEntity(newParameterEntities).by(parameterDto);
            if (newParameterEntityOpt.isPresent()) continue;
            ScheduledTasksParametersTable newParameterEntity = new ScheduledTasksParametersTable(newEntity, parameterDto.getType(), null, parameterDto.getPosition());
            newParameterEntities.add(newParameterEntity);
        }
    }
}

