/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.dashboards;

import com.suncode.plugin.dashboard.Dashboard;
import com.suncode.plugin.dashboard.DashboardService;
import com.suncode.plugin.dashboard.Gadget;
import com.suncode.plugin.dashboard.SystemDashboardService;
import com.suncode.plugin.dashboard.gadget.Errors;
import com.suncode.plugin.dashboard.gadget.GadgetDefinition;
import com.suncode.plugin.dashboard.gadget.GadgetPropertyValidator;
import com.suncode.plugin.dashboard.gadget.Property;
import com.suncode.plugin.dashboard.web.support.dto.GadgetDefinitionDto;
import com.suncode.plugin.framework.Plugin;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.dashboard.exception.DashboardNotFoundException;
import com.suncode.pwfl.dashboard.exception.GadgetNotFoundException;
import com.suncode.pwfl.dashboard.exception.UnauthorizedException;
import com.suncode.pwfl.dashboard.internal.SystemDashboardGadget;
import com.suncode.pwfl.dashboard.internal.gadget.GadgetDefinitionRegistry;
import com.suncode.pwfl.web.controller.api.dashboards.RestSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class GadgetController
extends RestSupport {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private DashboardService dashboardService;
    @Autowired
    private SystemDashboardService systemDashboardService;
    @Autowired
    private GadgetDefinitionRegistry gadgetDefinitionRegistry;

    @RequestMapping(value={"/gadgets/definitions"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, Object> avaiableGadgets() {
        ArrayList<GadgetDefinitionDto> definitions = new ArrayList<GadgetDefinitionDto>();
        List gadgetDefinitions = this.gadgetDefinitionRegistry.getAll();
        for (GadgetDefinition gadgetDefinition : gadgetDefinitions) {
            definitions.add(GadgetDefinitionDto.create((GadgetDefinition)gadgetDefinition));
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("records", definitions);
        return result;
    }

    @RequestMapping(value={"/dashboard/{dashId}/gadgets/{gadgetId}/properties"}, method={RequestMethod.POST})
    @ResponseBody
    @Transactional
    public ResponseEntity<Errors> saveGadgetProperties(@PathVariable String dashId, @PathVariable String gadgetId, @RequestParam(required=false) boolean system, @RequestParam Map<String, String> properties) throws UnauthorizedException {
        Dashboard dashboard;
        User user = this.getUserContext().getUser();
        Dashboard dashboard2 = dashboard = system ? this.systemDashboardService.getSystemDashboardForUser(dashId, user) : this.dashboardService.getDashboard(Long.valueOf(dashId));
        if (dashboard == null) {
            throw new DashboardNotFoundException();
        }
        Gadget gadget = system ? (Gadget)this.systemDashboardService.findGadgetForUser(user, gadgetId).orElseThrow(() -> new GadgetNotFoundException(gadgetId)) : dashboard.getGadget(Long.valueOf(gadgetId));
        Plugin plugin = gadget.getPlugin();
        Errors errors = new Errors(plugin);
        Map gadgetProps = gadget.getProperties();
        Set propertiesToUpdate = properties.keySet().stream().filter(property -> !property.equals("system")).collect(Collectors.toSet());
        for (String name : propertiesToUpdate) {
            Property property2 = (Property)gadgetProps.get(name);
            if (property2 == null) {
                this.logger.debug("No property [{}] found in gadget {}", (Object)name, (Object)gadget);
                continue;
            }
            try {
                String value = properties.get(name);
                property2.setRawValue(value.equalsIgnoreCase("null") ? null : value);
            }
            catch (RuntimeException e) {
                this.logger.debug("Could not set property [{}] new value: {}", (Object)property2, (Object)properties.get(name));
                errors.add(property2);
            }
        }
        if (errors.isSuccess()) {
            this.validatePropertiesUsingCustomValidator(plugin, gadget, errors);
            if (errors.isSuccess()) {
                if (system) {
                    this.systemDashboardService.updateSystemGadgetProperties(user, (SystemDashboardGadget)gadget);
                } else {
                    this.dashboardService.updateDashboard(dashboard);
                }
            }
        }
        return new ResponseEntity((Object)errors, HttpStatus.OK);
    }

    private void validatePropertiesUsingCustomValidator(Plugin plugin, Gadget gadget, Errors errors) {
        Class validator = gadget.getPropertyValidatorClass();
        if (validator != null) {
            this.logger.debug("Custom gadget property validator class found [{}]", (Object)validator);
            try {
                GadgetPropertyValidator validatorBean = (GadgetPropertyValidator)plugin.getContext().getAutowireCapableBeanFactory().createBean(validator);
                for (Property property : gadget.getProperties().values()) {
                    this.logger.debug("Validating property [{}] using validator [{}({})]", new Object[]{property, validatorBean, validatorBean.getClass()});
                    validatorBean.validateProperty(property, errors);
                }
            }
            catch (BeansException e) {
                this.logger.warn("Could not instantiate validator class [{}]", (Object)validator, (Object)e);
            }
            catch (RuntimeException e) {
                this.logger.warn("Unexpected error occured during gadget [{}] properties validation", (Object)gadget, (Object)e);
            }
        }
    }
}

