/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.certificates.dto;

import java.security.MessageDigest;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.springframework.util.Assert;

public class CertificateDto {
    private static final SimpleDateFormat FORMATTER = new SimpleDateFormat("yyyy-MM-dd");
    private String alias;
    private String subjectDN;
    private String issuerDN;
    private Date fromDate;
    private Date toDate;
    private String signature;

    public CertificateDto(String alias, Certificate cert) {
        Assert.isInstanceOf(X509Certificate.class, (Object)cert, (String)"Obiekt certyfikatu nie jest typu X.509");
        X509Certificate xCert = (X509Certificate)cert;
        this.alias = alias;
        this.subjectDN = xCert.getSubjectX500Principal().getName().replace("=", ": ").replace(",", ", ");
        this.issuerDN = xCert.getIssuerX500Principal().getName().replace("=", ": ").replace(",", ", ");
        this.fromDate = xCert.getNotBefore();
        this.toDate = xCert.getNotAfter();
        MessageDigest hash = MessageDigest.getInstance("SHA1");
        this.signature = CertificateDto.formatSignature(hash.digest(xCert.getEncoded()));
    }

    private static String formatSignature(byte[] signature) {
        int val;
        if (signature.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(signature.length * 3 - 1);
        int len = signature.length - 1;
        for (int i = 0; i < len; ++i) {
            val = Byte.toUnsignedInt(signature[i]);
            builder.append(CertificateDto.toHex(val >> 4));
            builder.append(CertificateDto.toHex(val & 0xF));
            builder.append(':');
        }
        val = Byte.toUnsignedInt(signature[len]);
        builder.append(CertificateDto.toHex(val >> 4));
        builder.append(CertificateDto.toHex(val & 0xF));
        return builder.toString();
    }

    private static char toHex(int bytePart) {
        if (bytePart <= 9) {
            return (char)(bytePart + 48);
        }
        return (char)(bytePart + 55);
    }

    public String formatFromDateField() {
        return FORMATTER.format(this.getFromDate());
    }

    public String formatToDateField() {
        return FORMATTER.format(this.getToDate());
    }

    public String getAlias() {
        return this.alias;
    }

    public String getSubjectDN() {
        return this.subjectDN;
    }

    public String getIssuerDN() {
        return this.issuerDN;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setSubjectDN(String subjectDN) {
        this.subjectDN = subjectDN;
    }

    public void setIssuerDN(String issuerDN) {
        this.issuerDN = issuerDN;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }
}

