/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.certificates;

import com.suncode.pwfl.web.controller.api.certificates.fetchers.CertificateFetcher;
import com.suncode.pwfl.web.controller.api.certificates.fetchers.CertificateFetcherIMAP4;
import com.suncode.pwfl.web.controller.api.certificates.fetchers.CertificateFetcherLDAP;
import com.suncode.pwfl.web.controller.api.certificates.fetchers.CertificateFetcherPOP3;
import com.suncode.pwfl.web.controller.api.certificates.fetchers.CertificateFetcherSMTP;
import com.suncode.pwfl.web.controller.api.certificates.fetchers.CertificateFetcherSimple;

public enum CertificateProtocol {
    SIMPLE(CertificateFetcherSimple::new),
    SMTP(CertificateFetcherSMTP::new),
    IMAP4(CertificateFetcherIMAP4::new),
    POP3(CertificateFetcherPOP3::new),
    LDAP(CertificateFetcherLDAP::new);

    private CertificateFetcherFactory factory;

    private CertificateProtocol(CertificateFetcherFactory factory) {
        this.factory = factory;
    }

    public CertificateFetcher createFetcher(String host, int port) {
        return this.factory.getCertificateFetcher(host, port);
    }

    private static interface CertificateFetcherFactory {
        public CertificateFetcher getCertificateFetcher(String var1, int var2);
    }
}

