/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.administration.user;

import com.google.common.collect.ImmutableMap;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.administration.user.exception.GroupNotFoundException;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"activation"})
public class UserActivationController {
    @Autowired
    private AuthorizationHelper authorizationHelper;
    @Autowired
    private UserService userService;

    @Transactional
    @ResponseStatus(value=HttpStatus.OK)
    @RequestMapping(method={RequestMethod.POST})
    public void activate(HttpServletRequest request, @RequestParam String username, @RequestParam String groupNameToAttach) throws GroupNotFoundException {
        AuditBuilder builder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_ACTIVATE_USER).params((Map)ImmutableMap.of((Object)"userId", (Object)username, (Object)"groupToAttach", (Object)groupNameToAttach));
        this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)builder.buildFailure()));
        try {
            this.userService.activateUser(username);
            this.userService.addUserToGroup(username, groupNameToAttach);
            request.setAttribute("audit", (Object)builder.buildSuccess());
        }
        catch (Exception ex) {
            request.setAttribute("audit", (Object)builder.buildFailure());
            throw ex;
        }
    }
}

