/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.administration.processField;

import com.plusmpm.i18n.I18Nxpdl;
import com.plusmpm.parser.wrapper.XpdlKey;
import com.plusmpm.util.XpdlPackageManager;
import com.suncode.pwfl.administration.processField.DefaultProcessFieldsStatus;
import com.suncode.pwfl.administration.processField.ProcessField;
import com.suncode.pwfl.administration.processField.ProcessFieldService;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.view.exception.NoPermissionToProcessException;
import com.suncode.pwfl.web.dto.administration.processField.ProcessFieldDto;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.security.exception.NotFullRightsException;
import com.suncode.pwfl.web.support.ajax.RestResult;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.enhydra.shark.xpdl.elements.Package;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/processField"})
public class ProcessFieldController {
    private static final Logger log = LoggerFactory.getLogger(ProcessFieldController.class);
    private final ProcessFieldService processFieldService;
    private final AuthorizationHelper authorizationHelper;
    private final MessageHelperBean messageHelper;

    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public List<ProcessFieldDto> getProcessFields(@RequestParam String processDefId, @RequestParam(required=false) String activityDefId) throws NoPermissionToProcessException {
        if (!this.authorizationHelper.hasSearchProcessAccess(processDefId).booleanValue()) {
            throw new NoPermissionToProcessException(this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
        }
        List processFields = this.processFieldService.getProcessFields(processDefId, activityDefId);
        return this.getTranslatedDto(processDefId, processFields);
    }

    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    public DefaultProcessFieldsStatus saveProcessFields(HttpServletRequest request, @RequestBody List<ProcessFieldDto> processFieldDtos, @RequestParam String processDefId, @RequestParam(required=false) String activityDefId) {
        DefaultProcessFieldsStatus fields;
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(StringUtils.isBlank((CharSequence)activityDefId) ? AuditTypes.AUDIT_CHANGE_SELECTED_PROCESS_FIELDS : AuditTypes.AUDIT_CHANGE_SELECTED_TASK_FIELDS);
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        List processFields = processFieldDtos.stream().map(ProcessFieldDto::toEntity).collect(Collectors.toList());
        try {
            fields = this.processFieldService.saveProcessFields(processFields, processDefId, activityDefId);
            String savedFieldsIds = fields.getSavedFields().stream().map(ProcessField::getVariableId).collect(Collectors.joining(", "));
            String updatedFieldsIds = fields.getUpdatedFields().stream().map(ProcessField::getVariableId).collect(Collectors.joining(", "));
            String deletedFieldsIds = fields.getDeletedFields().stream().map(ProcessField::getVariableId).collect(Collectors.joining(", "));
            HashMap<String, String> auditParams = new HashMap<String, String>();
            auditParams.put("saved", savedFieldsIds);
            auditParams.put("updated", updatedFieldsIds);
            auditParams.put("deleted", deletedFieldsIds);
            auditParams.put("processDefId", processDefId);
            if (StringUtils.isNotBlank((CharSequence)activityDefId)) {
                auditParams.put("activityDefId", activityDefId);
            }
            auditBuilder.params(auditParams).buildSuccess(request);
        }
        catch (Exception e) {
            auditBuilder.buildFailure(request);
            throw e;
        }
        return fields;
    }

    private List<ProcessFieldDto> getTranslatedDto(String processDefId, List<ProcessField> processFields) {
        Package processPackage = XpdlPackageManager.getInstance().getPackageByProcessDefinitionId(processDefId);
        I18Nxpdl translator = new I18Nxpdl(LocaleContextHolder.getLocale());
        return processFields.stream().map(processField -> {
            ProcessFieldDto processFieldDto = new ProcessFieldDto((ProcessField)processField);
            String variableName = processPackage.getWorkflowProcess(processDefId).getDataField(processField.getVariableId()).getName();
            processFieldDto.setVariableName(variableName);
            String translationKey = XpdlKey.forPackage((String)processPackage.getId()).forProcess(processDefId).forDataField(processField.getVariableId()).getKey();
            String translatedName = translator.getStringWithDefault(translationKey, variableName);
            processFieldDto.setTranslatedVariableName(translatedName);
            return processFieldDto;
        }).collect(Collectors.toList());
    }

    @ExceptionHandler(value={NotFullRightsException.class, NoPermissionToProcessException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public RestResult handleNoRightsException(Exception e) {
        log.info(this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
        return new RestResult(false, this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
    }

    @ConstructorProperties(value={"processFieldService", "authorizationHelper", "messageHelper"})
    @Autowired
    public ProcessFieldController(ProcessFieldService processFieldService, AuthorizationHelper authorizationHelper, MessageHelperBean messageHelper) {
        this.processFieldService = processFieldService;
        this.authorizationHelper = authorizationHelper;
        this.messageHelper = messageHelper;
    }
}

