/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.administration.mappings;

import com.google.common.collect.ImmutableMap;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserFinder;
import com.suncode.pwfl.administration.user.search.SimpleHibernateUserFilter;
import com.suncode.pwfl.administration.user.search.UserPropertyFilter;
import com.suncode.pwfl.administration.user.search.UserSortProperty;
import com.suncode.pwfl.administration.user.search.UserSorter;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.database.DBUtils;
import com.suncode.pwfl.export.extension.ExportExtension;
import com.suncode.pwfl.export.model.ExportColumn;
import com.suncode.pwfl.export.model.ExportColumnBuilder;
import com.suncode.pwfl.export.model.ExportModel;
import com.suncode.pwfl.export.service.ExportService;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.FilterOperator;
import com.suncode.pwfl.search.LogicOperator;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.search.hibernate.GroupHibernateFilter;
import com.suncode.pwfl.search.hibernate.HibernateFilter;
import com.suncode.pwfl.web.controller.api.administration.mappings.MappingFilters;
import com.suncode.pwfl.web.dto.administration.GroupDto;
import com.suncode.pwfl.web.dto.administration.MappingRoleDto;
import com.suncode.pwfl.web.dto.administration.structure.organizationalUnit.OrganizationalUnitDto;
import com.suncode.pwfl.web.dto.administration.structure.position.PositionDto;
import com.suncode.pwfl.web.dto.administration.user.UserMappingDto;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.security.exception.NotFullRightsException;
import com.suncode.pwfl.web.support.UserMapper;
import com.suncode.pwfl.web.support.ajax.RestResult;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"mappings"})
public class MappingsController {
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private UserFinder userFinder;
    @Autowired
    private ExportService exportService;
    @Autowired
    private AuthorizationHelper authorizationHelper;
    @Autowired
    private MessageHelperBean messageHelper;

    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<UserMappingDto> getMappings(HttpServletRequest request, MappingFilters mappingFilters, @RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit, @RequestParam(required=false, defaultValue="userName") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_SEARCH_MAPPINGS);
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        List<HibernateFilter> filters = MappingsController.createHibernateFilters(mappingFilters);
        UserSorter sorter = new UserSorter(UserSortProperty.valueOf((String)sortBy.toUpperCase()), sortDirection);
        CountedResult result = this.userFinder.findByFilters(filters, sorter, start.intValue(), limit.intValue());
        if (mappingFilters.getIsSearch() == null || mappingFilters.getIsSearch().booleanValue()) {
            ImmutableMap params = new ImmutableMap.Builder().put((Object)"userName", (Object)StringUtils.defaultString((String)mappingFilters.getUserName())).put((Object)"firstName", (Object)StringUtils.defaultString((String)mappingFilters.getFirstName())).put((Object)"lastName", (Object)StringUtils.defaultString((String)mappingFilters.getLastName())).put((Object)"group", (Object)StringUtils.defaultString((String)mappingFilters.getGroup())).put((Object)"positionName", (Object)StringUtils.defaultString((String)mappingFilters.getPositionName())).put((Object)"positionSymbol", (Object)StringUtils.defaultString((String)mappingFilters.getPositionSymbol())).put((Object)"organizationalUnitName", (Object)StringUtils.defaultString((String)mappingFilters.getOrganizationalUnitName())).put((Object)"organizationalUnitSymbol", (Object)StringUtils.defaultString((String)mappingFilters.getOrganizationalUnitSymbol())).put((Object)"roleId", (Object)StringUtils.defaultString((String)mappingFilters.getRoleId())).build();
            auditBuilder.params((Map)params).buildSuccess(request);
        }
        List userDtos = result.getData().stream().map(user -> this.userMapper.fromEntity((User)user)).collect(Collectors.toList());
        return new CountedResult(result.getTotal(), userDtos);
    }

    @RequestMapping(value={"export/{extension}"}, method={RequestMethod.GET})
    @ResponseBody
    public void exportMappings(HttpServletResponse response, MappingFilters mappingFilters, @PathVariable String extension, @RequestParam(required=false, defaultValue="userName") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) throws IOException {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        List<HibernateFilter> filters = MappingsController.createHibernateFilters(mappingFilters);
        UserSorter sorter = new UserSorter(UserSortProperty.valueOf((String)sortBy.toUpperCase()), sortDirection);
        CountedResult result = this.userFinder.findByFilters(filters, sorter, 0, Integer.MAX_VALUE);
        List<UserMappingDto> userDtos = result.getData().stream().map(user -> this.userMapper.fromEntity((User)user)).collect(Collectors.toList());
        List<ExportColumn> columns = Arrays.asList(this.buildExportColumn(this.messageHelper.getMessage("Nazwa"), userDtos, UserMappingDto::getUserName), this.buildExportColumn(this.messageHelper.getMessage("Imie"), userDtos, UserMappingDto::getFirstName), this.buildExportColumn(this.messageHelper.getMessage("Nazwisko"), userDtos, UserMappingDto::getLastName), this.buildExportColumn(this.messageHelper.getMessage("Grupa"), userDtos, userMappingDto -> userMappingDto.getGroups().stream().map(GroupDto::getName).collect(Collectors.joining(", "))), this.buildExportColumn(this.messageHelper.getMessage("Stanowisko"), userDtos, userMappingDto -> userMappingDto.getPositions().stream().map(PositionDto::getName).collect(Collectors.joining(", "))), this.buildExportColumn(this.messageHelper.getMessage("Symbol_stanowiska"), userDtos, userMappingDto -> userMappingDto.getPositions().stream().map(PositionDto::getSymbol).collect(Collectors.joining(", "))), this.buildExportColumn(this.messageHelper.getMessage("Jednostka_organizacyjna"), userDtos, userMappingDto -> userMappingDto.getOrganizationalUnits().stream().map(OrganizationalUnitDto::getName).collect(Collectors.joining(", "))), this.buildExportColumn(this.messageHelper.getMessage("Symbol_jednostki_organizacyjnej"), userDtos, userMappingDto -> userMappingDto.getOrganizationalUnits().stream().map(OrganizationalUnitDto::getSymbol).collect(Collectors.joining(", "))), this.buildExportColumn(this.messageHelper.getMessage("Identyfikator_roli"), userDtos, userMappingDto -> userMappingDto.getRoles().stream().map(MappingRoleDto::getRoleId).collect(Collectors.joining(", "))), this.buildExportColumn(this.messageHelper.getMessage("Rola"), userDtos, userMappingDto -> userMappingDto.getRoles().stream().map(MappingRoleDto::getRoleName).collect(Collectors.joining(", "))));
        ExportModel model = ExportModel.builder().title(this.messageHelper.getMessage("Mapowanie_uzytkownikow")).columns(columns).build();
        ExportExtension extensionEnum = ExportExtension.valueOf((String)extension.toUpperCase());
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"export.%s\"", extensionEnum.getExtension()));
        this.exportService.export(model, extensionEnum, (OutputStream)response.getOutputStream());
    }

    private ExportColumn buildExportColumn(String name, List<UserMappingDto> data, Function<UserMappingDto, String> supplier) {
        return ExportColumnBuilder.create().name(name).data(data).by(supplier).build();
    }

    private static List<HibernateFilter> createHibernateFilters(MappingFilters mappingFilters) {
        ArrayList<HibernateFilter> filters = new ArrayList<HibernateFilter>();
        MappingsController.addFilter(filters, UserPropertyFilter.USERNAME, mappingFilters.getUserName());
        MappingsController.addFilter(filters, UserPropertyFilter.FIRSTNAME, mappingFilters.getFirstName());
        MappingsController.addFilter(filters, UserPropertyFilter.LASTNAME, mappingFilters.getLastName());
        MappingsController.addFilter(filters, UserPropertyFilter.GROUP_NAME, mappingFilters.getGroup());
        MappingsController.addFilter(filters, UserPropertyFilter.POSITION_NAME, mappingFilters.getPositionName());
        MappingsController.addFilter(filters, UserPropertyFilter.POSITION_SYMBOL, mappingFilters.getPositionSymbol());
        MappingsController.addFilter(filters, UserPropertyFilter.ORGANIZATIONALUNIT_NAME, mappingFilters.getOrganizationalUnitName());
        MappingsController.addFilter(filters, UserPropertyFilter.ORGANIZATIONALUNIT_SYMBOL, mappingFilters.getOrganizationalUnitSymbol());
        MappingsController.addFilter(filters, UserPropertyFilter.ROLEID, mappingFilters.getRoleId());
        return filters;
    }

    private static void addFilter(List<HibernateFilter> filters, UserPropertyFilter property, Object value) {
        if (!(value instanceof String) && value != null) {
            filters.add((HibernateFilter)new SimpleHibernateUserFilter(property, value, FilterOperator.EQ));
            return;
        }
        String sValue = (String)value;
        if (StringUtils.isBlank((String)sValue)) {
            return;
        }
        if (DBUtils.isExactQuery((String)sValue)) {
            filters.add((HibernateFilter)new SimpleHibernateUserFilter(property, (Object)DBUtils.getExactQueryValue((String)sValue), FilterOperator.EQ));
            return;
        }
        if (DBUtils.isConjunctionSearch((String)sValue)) {
            GroupHibernateFilter conjunctionFilter = new GroupHibernateFilter(LogicOperator.AND);
            List searchValues = DBUtils.searchCriteriaForConjunctionLike((List)DBUtils.conjunctionValuesForLike((String)sValue));
            List searchFilters = searchValues.stream().map(filterValue -> new SimpleHibernateUserFilter(property, filterValue, FilterOperator.ILIKE)).collect(Collectors.toList());
            conjunctionFilter.setFilters(searchFilters);
            filters.add((HibernateFilter)conjunctionFilter);
            return;
        }
        filters.add((HibernateFilter)new SimpleHibernateUserFilter(property, (Object)DBUtils.searchCriteriaForLike((String)sValue), FilterOperator.ILIKE));
    }

    @ExceptionHandler(value={NotFullRightsException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public RestResult handleNotFullRightsException(NotFullRightsException e) {
        return new RestResult(false, this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
    }
}

