/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.struts.action.reports;

import com.plusmpm.database.DBManagement;
import com.plusmpm.database.ReportVariableTable;
import com.plusmpm.database.ReportsTable;
import com.plusmpm.struts.form.ReportVariableForm;
import com.plusmpm.util.reports.ReportPermissions;
import com.suncode.pwfl.database.DBUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.export.JRHtmlExporter;
import net.sf.jasperreports.engine.export.JRHtmlExporterParameter;
import net.sf.jasperreports.engine.export.JRXlsExporterParameter;
import net.sf.jasperreports.engine.export.ooxml.JRXlsxExporter;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;

public class ShowJasperRaportResultAction
extends Action {
    public static Logger log = Logger.getLogger(ShowJasperRaportResultAction.class);
    public static Logger performanceLog = Logger.getLogger((String)"PerformanceLog");

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        log.info((Object)"******************************ShowJasperRaportResultAction********************");
        try {
            String userName;
            HttpSession session = request.getSession(false);
            if (session == null || (userName = (String)session.getAttribute("username")) == null) {
                return mapping.findForward("welcome");
            }
            String external = request.getParameter("external");
            String source = request.getParameter("source");
            String reportId = request.getParameter("reportId");
            String reportType = request.getParameter("reportType");
            HashMap<String, String> hmParameters = (HashMap<String, String>)request.getAttribute("params");
            if (source != null && source.compareTo("params") == 0 && (StringUtils.isEmpty((CharSequence)reportType) || reportType.compareTo("html") == 0)) {
                return mapping.findForward("showJasperRaportParams");
            }
            DynaActionForm reportDefinitionForm = (DynaActionForm)form;
            ReportVariableForm[] reportVariables = (ReportVariableForm[])reportDefinitionForm.get("variable");
            if (external != null && external.compareTo("true") == 0) {
                DBManagement dbm = new DBManagement();
                ArrayList alReportVariable = (ArrayList)dbm.GetAllVariableInReport(reportId);
                if (hmParameters == null) {
                    hmParameters = new HashMap();
                }
                for (ReportVariableTable reportVariableTable : alReportVariable) {
                    String paramName = reportVariableTable.getName();
                    String paramValue = request.getParameter(paramName);
                    if (paramValue == null) {
                        paramValue = "";
                    }
                    hmParameters.put(paramName, paramValue);
                }
            } else if (hmParameters == null) {
                hmParameters = new HashMap<String, String>();
                boolean bReadParams = true;
                int iLoop = 0;
                do {
                    if (reportVariables[iLoop] != null) {
                        if (reportVariables[iLoop].getName() != null) {
                            String sValue = reportVariables[iLoop].getValue();
                            String sParameterType = reportVariables[iLoop].getSortType();
                            if (sParameterType != null && sParameterType.compareToIgnoreCase("USERNAME") == 0) {
                                sValue = userName;
                            }
                            hmParameters.put(reportVariables[iLoop].getName(), sValue);
                        } else {
                            bReadParams = false;
                        }
                    }
                    ++iLoop;
                } while (bReadParams);
            }
            if (!ReportPermissions.reportPermissions((String)userName, (String)reportId)) {
                return mapping.findForward("welcome");
            }
            return this.createJasperReport(mapping, request, response, hmParameters);
        }
        catch (Exception e) {
            log.error((Object)("Exception:" + e.getLocalizedMessage()), (Throwable)e);
            return mapping.findForward("showResult");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public ActionForward createJasperReport(ActionMapping mapping, HttpServletRequest request, HttpServletResponse response, HashMap<String, String> hmParameters) throws ServletException, IOException {
        log.info((Object)"createJasperReport");
        String sReportName = "";
        Connection con = null;
        try {
            String reportId = request.getParameter("reportId");
            String reportType = request.getParameter("reportType");
            DBManagement dbm = new DBManagement();
            ReportsTable reportTable = dbm.getReport(reportId);
            String sJrxml = "";
            if (StringUtils.isEmpty((CharSequence)reportType)) {
                reportType = "html";
            }
            log.info((Object)"Pr\u00f3ba po\u0142\u0105czenia do bazydanych");
            con = DBUtils.connectToDB();
            log.info((Object)"Nawi\u0105zano po\u0142\u0105czenie do bazy bazydanych");
            Date dt = new Date();
            if (reportTable.getReportType() != null && reportTable.getReportType().compareTo(ReportsTable.REPORT_TYPE_JASPER) == 0) {
                sJrxml = reportTable.getReportDefinitionPath();
                sReportName = reportTable.getReportName();
                HashMap<String, String> map = new HashMap<String, String>();
                map.putAll(hmParameters);
                JasperReport jr = JasperCompileManager.compileReport((String)sJrxml);
                log.info((Object)("map:" + ((Object)map).toString()));
                log.info((Object)("map2:" + map.values().toString()));
                for (String sKey : map.keySet()) {
                    log.info((Object)("key:" + sKey + " value" + map.get(sKey)));
                }
                JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jr, map, (Connection)con);
                if (reportType.compareTo("html") == 0) {
                    PrintWriter servletOutputStream = response.getWriter();
                    JRHtmlExporter exporter = new JRHtmlExporter();
                    exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.HTML_HEADER, (Object)" ");
                    request.getSession().setAttribute("net.sf.jasperreports.j2ee.jasper_print", (Object)jasperPrint);
                    exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, (Object)Boolean.TRUE);
                    exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_USING_IMAGES_TO_ALIGN, (Object)Boolean.TRUE);
                    exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)Boolean.FALSE);
                    exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
                    exporter.setParameter(JRExporterParameter.OUTPUT_WRITER, (Object)servletOutputStream);
                    exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_URI, (Object)"servlets/image?image=");
                    exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.HTML_FOOTER, (Object)" ");
                    exporter.exportReport();
                } else if (reportType.compareTo("pdf") == 0) {
                    byte[] bytes = JasperExportManager.exportReportToPdf((JasperPrint)jasperPrint);
                    ServletOutputStream output = response.getOutputStream();
                    response.setContentType("application/pdf");
                    response.addHeader("Content-Disposition", "filename=raport.pdf");
                    IOUtils.write((byte[])bytes, (OutputStream)output);
                } else if (reportType.compareTo("xls") == 0) {
                    response.setContentType("application/xls");
                    response.addHeader("Content-Disposition", "filename=raport.xlsx");
                    JRXlsxExporter exporterXLS = new JRXlsxExporter();
                    ServletOutputStream output = response.getOutputStream();
                    exporterXLS.setParameter(JRXlsExporterParameter.JASPER_PRINT, (Object)jasperPrint);
                    exporterXLS.setParameter(JRXlsExporterParameter.OUTPUT_STREAM, (Object)output);
                    exporterXLS.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_ONE_PAGE_PER_SHEET, (Object)Boolean.FALSE);
                    exporterXLS.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, (Object)Boolean.TRUE);
                    exporterXLS.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_DETECT_CELL_TYPE, (Object)Boolean.TRUE);
                    exporterXLS.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)Boolean.FALSE);
                    exporterXLS.exportReport();
                }
            }
            Date dt2 = new Date();
            performanceLog.info((Object)("|Report|" + sReportName + "|" + (dt2.getTime() - dt.getTime())));
            request.setAttribute("auditSuccess", (Object)true);
            DBUtils.closeConnection((Connection)con);
        }
        catch (JRException e) {
            log.error((Object)("Error in createJasperReport:" + e.getMessage()), (Throwable)e);
            request.setAttribute("reportName", (Object)sReportName);
            request.setAttribute("errorMessage", (Object)e.getLocalizedMessage());
            ActionForward actionForward = mapping.findForward("showReportError");
            DBUtils.closeConnection((Connection)con);
            return actionForward;
        }
        catch (Exception e2) {
            log.error((Object)e2.getMessage(), (Throwable)e2);
            request.setAttribute("reportName", (Object)sReportName);
            request.setAttribute("errorMessage", (Object)e2.getLocalizedMessage());
            ActionForward actionForward = mapping.findForward("showReportError");
            return actionForward;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            DBUtils.closeConnection(con);
        }
        return null;
    }
}

