/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.struts.action;

import com.plusmpm.database.DBManagement;
import com.plusmpm.i18n.I18N;
import com.plusmpm.struts.action.AdvanceProcessSearchAction;
import com.plusmpm.struts.form.AdvanceVariableForm;
import com.plusmpm.util.AdvanceSearchResult;
import com.plusmpm.util.AdvanceVariableListComp;
import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.elastic.search.ElasticValueSearchModelConverter;
import com.suncode.pwfl.elastic.search.model.ElasticSearchModel;
import com.suncode.pwfl.experimental.Experimental;
import com.suncode.pwfl.experimental.ExperimentalFeature;
import com.suncode.pwfl.search.AdvanceVariableFormBuilder;
import com.suncode.pwfl.search.elastic.ElasticAdvanceProcessSearchResults;
import com.suncode.pwfl.search.elastic.ElasticAdvanceProcessSearchService;
import com.suncode.pwfl.search.elastic.ElasticResultConverterParameters;
import com.suncode.pwfl.search.elastic.ElasticResultConverterParametersProvider;
import com.suncode.pwfl.search.elastic.ElasticResultToAdvanceSearchResultConverter;
import com.suncode.pwfl.util.SharkUtils;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.web.search.model.SearchFormModelDto;
import com.suncode.pwfl.web.support.form.cache.SearchFormCache;
import com.suncode.pwfl.workflow.activity.indexer.ActivityIndexingWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Vector;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.enhydra.shark.api.client.wfmodel.WfActivity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuspendAdvanceSearchedProcessesAction
extends Action {
    private static final Logger log = LoggerFactory.getLogger(SuspendAdvanceSearchedProcessesAction.class);
    private static final SearchFormCache searchFormCache = (SearchFormCache)SpringContext.getBean(SearchFormCache.class);
    private static final AdvanceVariableFormBuilder advanceVariableFormBuilder = (AdvanceVariableFormBuilder)SpringContext.getBean(AdvanceVariableFormBuilder.class);
    private static final Experimental experimental = (Experimental)SpringContext.getBean(Experimental.class);
    private static final ElasticAdvanceProcessSearchService elasticAdvanceProcessSearchService = (ElasticAdvanceProcessSearchService)SpringContext.getBean(ElasticAdvanceProcessSearchService.class);
    private static final ElasticResultToAdvanceSearchResultConverter elasticResultToAdvanceSearchResultConverter = (ElasticResultToAdvanceSearchResultConverter)SpringContext.getBean(ElasticResultToAdvanceSearchResultConverter.class);
    private static final ElasticValueSearchModelConverter elasticValueSearchModelConverter = (ElasticValueSearchModelConverter)SpringContext.getBean(ElasticValueSearchModelConverter.class);
    private static final ElasticResultConverterParametersProvider elasticResultConverterParametersProvider = (ElasticResultConverterParametersProvider)SpringContext.getBean(ElasticResultConverterParametersProvider.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        log.info("******************************AbortAdvanceSearchedProcessesAction********************");
        HttpSession session = request.getSession(false);
        I18N oMessage = new I18N(request);
        try {
            if (session == null || session.getAttribute("username") == null) {
                return mapping.findForward("welcome");
            }
            String userName = (String)session.getAttribute("username");
            String amount = request.getParameter("amount");
            String searchId = request.getParameter("searchId");
            if (StringUtils.isNotBlank((CharSequence)searchId)) {
                List alResult;
                boolean isElasticFeatureEnabled = experimental.hasFeature(ExperimentalFeature.ELASTIC) && SystemProperties.getBoolean((DefinedSystemParameter)DefinedSystemParameter.ELASTIC_ENABLED) != false;
                Optional<SearchFormModelDto> searchForm = searchFormCache.getSearchFormFromCache(searchId);
                ElasticSearchModel elasticSearchModel = null;
                SearchFormModelDto searchFormModelDto = null;
                ElasticAdvanceProcessSearchResults elasticAdvanceProcessSearchResults = null;
                if (!searchForm.isPresent()) {
                    throw new IllegalArgumentException("Search form is not cached");
                }
                searchFormModelDto = searchForm.get();
                AdvanceVariableForm[] searchVariable = advanceVariableFormBuilder.buildAdvanceFormVariables(searchFormModelDto);
                ArrayList<AdvanceVariableForm> alVariableList = new ArrayList<AdvanceVariableForm>();
                for (int i = 0; i < searchVariable.length && searchVariable[i] != null; ++i) {
                    alVariableList.add(searchVariable[i]);
                    log.info(searchVariable[i].getName() + ", " + searchVariable[i].getActive() + ", " + searchVariable[i].getValue() + ", " + searchVariable[i].getValue2() + ", " + searchVariable[i].getSortType() + ", " + searchVariable[i].getPosition());
                }
                AdvanceVariableListComp avc = new AdvanceVariableListComp();
                Collections.sort(alVariableList, avc);
                int iMaxPageSize = 0;
                DBManagement dbm = new DBManagement();
                Vector vCountQuery = new Vector();
                if (isElasticFeatureEnabled) {
                    try {
                        elasticSearchModel = elasticValueSearchModelConverter.fromSearchModel(searchFormModelDto, "", "ASC");
                        iMaxPageSize = (int)elasticAdvanceProcessSearchService.getCount(elasticSearchModel);
                        elasticAdvanceProcessSearchResults = elasticAdvanceProcessSearchService.search(elasticSearchModel, 0, iMaxPageSize);
                        iMaxPageSize = (int)elasticAdvanceProcessSearchResults.getCount();
                        ElasticResultConverterParameters.ElasticResultConverterParametersBuilder elasticResultConverterParametersBuilder = elasticResultConverterParametersProvider.getParameters(searchFormModelDto, null, null, alVariableList, false, null, false, searchId, null, userName);
                        elasticResultConverterParametersBuilder.elasticAdvanceProcessSearchResults(elasticAdvanceProcessSearchResults);
                        alResult = elasticResultToAdvanceSearchResultConverter.convert(elasticResultConverterParametersBuilder.build());
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                        alResult = null;
                        iMaxPageSize = 0;
                    }
                } else {
                    alResult = dbm.AdavanceProcessSearch(searchVariable, userName, 0, 0, 0, "", vCountQuery, true, request, null);
                }
                if (alResult != null && !isElasticFeatureEnabled) {
                    String sCountQuery = (String)vCountQuery.get(0);
                    iMaxPageSize = dbm.getSizeAdavanceProcessSearch(searchVariable, userName, sCountQuery);
                }
                if (iMaxPageSize == 0) {
                    session.setAttribute("processaction", (Object)"error");
                    session.setAttribute("message", (Object)oMessage.getString("Zaden_proces_nie_zostal_usuniety"));
                } else if (iMaxPageSize != Integer.parseInt(amount)) {
                    session.setAttribute("processaction", (Object)"error");
                    session.setAttribute("message", (Object)(oMessage.getString("Wykryto_tryb_wielooknowy") + " " + oMessage.getString("Zaden_proces_nie_zostal_usuniety")));
                } else {
                    int iCnt = 0;
                    for (int i = 0; i < alResult.size(); ++i) {
                        AdvanceSearchResult result = (AdvanceSearchResult)alResult.get(i);
                        String sProcessId = result.getProcessId();
                        String sActivityId = result.getActivityId();
                        try {
                            WfActivity wfActivity = SharkUtils.getExecutionAdministration().getActivity(sProcessId, sActivityId);
                            String sProcessName = wfActivity.container().name();
                            String sActivityName = wfActivity.name();
                            log.info("Suspending activity:" + sActivityName + " in process:" + sProcessName);
                            if (wfActivity.state().startsWith("open")) {
                                log.info("Suspending activity.");
                                wfActivity.suspend();
                                ++iCnt;
                                continue;
                            }
                            log.info("Nie mo\u017cna zawiesic zadania kt\u00f3ry nie jest uruchommione lub si\u0119 zako\u0144czy\u0142o.");
                            continue;
                        }
                        catch (Exception e1) {
                            log.warn("Can't suspend activity." + e1.getLocalizedMessage(), (Throwable)e1);
                        }
                    }
                    Map activitiesToIndex = alResult.stream().collect(Collectors.groupingBy(AdvanceSearchResult::getProcessId, Collectors.mapping(AdvanceSearchResult::getActivityId, Collectors.toList())));
                    ActivityIndexingWrapper.get().indexSync(activitiesToIndex, true);
                    session.setAttribute("processaction", (Object)"success");
                    session.setAttribute("message", (Object)("" + oMessage.getString("Liczba_zawieszonych_zadan") + ": " + iCnt));
                }
            }
        }
        catch (Exception e) {
            log.error("Exception:" + e.getLocalizedMessage());
            session.setAttribute("processaction", (Object)"error");
            session.setAttribute("message", (Object)("" + oMessage.getString("Wystapil_blad_podczas_zawieszania_zadan") + ": " + e.getLocalizedMessage()));
        }
        AdvanceProcessSearchAction advanceProcessSearchAction = new AdvanceProcessSearchAction();
        return advanceProcessSearchAction.execute(mapping, form, request, response);
    }
}

