/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.struts.action;

import com.plusmpm.database.SessionAwareTransactionCallbackWithoutResult;
import com.plusmpm.database.authorization.RightTreeBuilder;
import com.plusmpm.i18n.I18N;
import com.plusmpm.struts.action.RightsAdminAction;
import com.plusmpm.struts.form.SystemProtectionForm;
import com.plusmpm.util.Authorization;
import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.archive.DocumentProtectionService;
import com.suncode.pwfl.archive.DocumentSearchCache;
import com.suncode.pwfl.dashboard.internal.UserSystemDashboardCache;
import com.suncode.pwfl.transaction.TransactionManagerFactory;
import com.suncode.pwfl.util.SpringContext;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.client.wfservice.UserGroupAdministration;
import org.hibernate.Session;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class AddSystemProtectionAction
extends Action {
    public static final Logger LOG = Logger.getLogger(AddSystemProtectionAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String message = "";
        String messageType = "";
        I18N oMessage = new I18N(request);
        LOG.trace((Object)"******************** AddSystemProtectionAction ********************");
        SystemProtectionForm systemProtectionForm = (SystemProtectionForm)form;
        HttpSession session = request.getSession(false);
        if (session == null || session.getAttribute("username") == null) {
            return mapping.findForward("disconnect");
        }
        String loggedUserName = (String)session.getAttribute("username");
        try {
            int rights = Authorization.checkRight((String)RightTreeBuilder.builder().system().admin().build(), (String)loggedUserName, (boolean)false, (boolean)false);
            if (rights == 0) {
                final boolean bGroup = systemProtectionForm.getIsGroup();
                final String username = systemProtectionForm.getUserName();
                final String systemModule = systemProtectionForm.getSystemModule();
                if (StringUtils.isNotBlank((CharSequence)username)) {
                    if (StringUtils.isNotBlank((CharSequence)systemModule)) {
                        try {
                            UserGroupAdministration userGroupAdministration = Shark.getInstance().getAdminInterface().getUserGroupAdministration();
                            if (false == bGroup && userGroupAdministration.doesUserExist(username) || true == bGroup && userGroupAdministration.doesGroupExist(username) || username.compareTo("*") == 0) {
                                TransactionTemplate tt = new TransactionTemplate(TransactionManagerFactory.getHibernateTransactionManager());
                                tt.execute((TransactionCallback)new SessionAwareTransactionCallbackWithoutResult(){

                                    public void doWithSession(Session session) {
                                        Authorization.addRight((Session)session, (String)systemModule, (String)username, (boolean)bGroup);
                                        String rightLevel = RightTreeBuilder.builder().system().archive().docClasses().build();
                                        if (rightLevel.contains(systemModule.toLowerCase())) {
                                            DocumentProtectionService dps = (DocumentProtectionService)SpringContext.getBean(DocumentProtectionService.class);
                                            dps.deleteByResource(username, bGroup);
                                        }
                                    }
                                });
                                ((DocumentSearchCache)SpringContext.getBean(DocumentSearchCache.class)).invalidateAll();
                                ((UserSystemDashboardCache)SpringContext.getBean(UserSystemDashboardCache.class)).invalidateForResource(username, bGroup);
                                message = oMessage.getString("Dodano_uprawnienie");
                                messageType = "success";
                                request.setAttribute("auditSuccess", (Object)true);
                            }
                        }
                        catch (BaseException be) {
                            LOG.error((Object)be.getMessage(), (Throwable)be);
                        }
                    } else {
                        message = oMessage.getString("Nie_podano_modulu_systemu");
                        messageType = "error";
                    }
                } else {
                    message = oMessage.getString("Nie_podano_nazwy_uzytkownika");
                    messageType = "error";
                }
            } else {
                LOG.info((Object)"Nie mo\u017cna doda\u0107 uprawnie\u0144 z powodu braku uprawnie\u0144");
                return mapping.findForward("welcome");
            }
            RightsAdminAction rightsAdminAction = new RightsAdminAction();
            ArrayList alSystemProtection = rightsAdminAction.GetFlatSystemRightList();
            Boolean showViewRights = SystemProperties.getBoolean((DefinedSystemParameter)DefinedSystemParameter.OPTIONAL_VIEWS_RIGHT);
            request.setAttribute("showViewRights", (Object)showViewRights);
            Boolean showUserAccountRights = SystemProperties.getBoolean((DefinedSystemParameter)DefinedSystemParameter.OPTIONAL_USER_ACCOUNT_RIGHT);
            request.setAttribute("showUserAccountRights", (Object)showUserAccountRights);
            Boolean showCalendarRight = SystemProperties.getBoolean((DefinedSystemParameter)DefinedSystemParameter.SHOW_CALENDAR_CART);
            request.setAttribute("showCalendarRight", (Object)showCalendarRight);
            Boolean showStatisticsRight = SystemProperties.getBoolean((DefinedSystemParameter)DefinedSystemParameter.SHOW_STATISTICS);
            request.setAttribute("showStatisticsRight", (Object)showStatisticsRight);
            request.setAttribute("messageType", (Object)messageType);
            request.setAttribute("message", (Object)message);
            request.setAttribute("showMessage", (Object)true);
            request.setAttribute("alSystemProtection", (Object)alSystemProtection);
            request.setAttribute("continueAdd", (Object)request.getParameter("continueAdd"));
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return mapping.findForward("showNewSystemProtections");
    }
}

