/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.ui;

import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.web.ui.DebugAwareGroupExtractor;
import com.suncode.pwfl.web.ui.TryCatchProcessor;
import com.suncode.pwfl.web.ui.UrlUriLocator;
import com.suncode.pwfl.web.ui.WebScriptsCache;
import com.suncode.pwfl.web.ui.WebScriptsRegistry;
import javax.servlet.FilterConfig;
import javax.servlet.annotation.WebFilter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import ro.isdc.wro.cache.CacheStrategy;
import ro.isdc.wro.config.jmx.WroConfiguration;
import ro.isdc.wro.http.WroFilter;
import ro.isdc.wro.manager.factory.BaseWroManagerFactory;
import ro.isdc.wro.manager.factory.WroManagerFactory;
import ro.isdc.wro.model.factory.WroModelFactory;
import ro.isdc.wro.model.group.GroupExtractor;
import ro.isdc.wro.model.resource.locator.UriLocator;
import ro.isdc.wro.model.resource.locator.factory.SimpleUriLocatorFactory;
import ro.isdc.wro.model.resource.locator.factory.UriLocatorFactory;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.model.resource.processor.factory.ProcessorsFactory;
import ro.isdc.wro.model.resource.processor.factory.SimpleProcessorsFactory;
import ro.isdc.wro.model.resource.processor.impl.js.JSMinProcessor;
import ro.isdc.wro.model.resource.processor.impl.js.SemicolonAppenderPreProcessor;
import ro.isdc.wro.util.ObjectFactory;

@WebFilter(value={"/resources/fragments/*"})
public class WebScriptsFilter
extends WroFilter {
    @Autowired
    private WebScriptsCache cache;
    @Autowired
    private WebScriptsRegistry webScripts;
    @Autowired
    private UrlUriLocator uriLocator;

    protected ObjectFactory<WroConfiguration> newWroConfigurationFactory(FilterConfig filterConfig) {
        return new ObjectFactory<WroConfiguration>(){

            public WroConfiguration create() {
                WroConfiguration config = new WroConfiguration();
                config.setJmxEnabled(false);
                config.setDebug(false);
                config.setIgnoreEmptyGroup(true);
                config.setIgnoreMissingResources(true);
                return config;
            }
        };
    }

    protected WroManagerFactory newWroManagerFactory() {
        SpringContext.getInstance().getAutowireCapableBeanFactory().autowireBean((Object)this);
        Assert.notNull((Object)this.cache);
        Assert.notNull((Object)this.webScripts);
        Assert.notNull((Object)this.uriLocator);
        BaseWroManagerFactory factory = new BaseWroManagerFactory();
        SimpleProcessorsFactory processorsFactory = new SimpleProcessorsFactory();
        processorsFactory.addPreProcessor((ResourcePreProcessor)new TryCatchProcessor());
        processorsFactory.addPreProcessor((ResourcePreProcessor)new SemicolonAppenderPreProcessor());
        processorsFactory.addPreProcessor((ResourcePreProcessor)new JSMinProcessor());
        factory.setProcessorsFactory((ProcessorsFactory)processorsFactory);
        factory.setCacheStrategy((CacheStrategy)this.cache);
        SimpleUriLocatorFactory locatorFactory = new SimpleUriLocatorFactory();
        locatorFactory.addLocator(new UriLocator[]{this.uriLocator});
        factory.setUriLocatorFactory((UriLocatorFactory)locatorFactory);
        factory.setModelFactory((WroModelFactory)this.webScripts);
        factory.setGroupExtractor((GroupExtractor)new DebugAwareGroupExtractor());
        return factory;
    }
}

