/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.support;

import com.suncode.pwfl.administration.archive.AssociatedIndexes;
import com.suncode.pwfl.administration.archive.DisplayedIndex;
import com.suncode.pwfl.administration.archive.DocumentClassAssociation;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassAssociationService;
import com.suncode.pwfl.archive.DocumentClassIndex;
import com.suncode.pwfl.archive.DocumentClassIndexFinder;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.translation.configElements.TranslatedFieldType;
import com.suncode.pwfl.web.dto.archive.AssociatedDocumentsDto;
import com.suncode.pwfl.web.dto.archive.AssociatedIndexesDto;
import com.suncode.pwfl.web.dto.archive.DisplayedIndexDto;
import com.suncode.pwfl.web.dto.archive.DocumentClassAssociationDto;
import com.suncode.pwfl.web.dto.archive.DocumentDto;
import com.suncode.pwfl.web.dto.archive.UpsertDocumentClassAssociationDto;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DocumentClassAssociationMapper {
    @Autowired
    private DocumentClassService documentClassService;
    @Autowired
    private DocumentClassIndexFinder documentClassIndexFinder;
    @Autowired
    private DocumentClassAssociationService documentClassAssociationService;

    public DocumentClassAssociation toDocumentClassAssociation(UpsertDocumentClassAssociationDto documentClassAssociationDto) {
        DocumentClass parentClass = (DocumentClass)this.documentClassService.get((Serializable)documentClassAssociationDto.getParentClassId(), new String[]{"indexes"});
        DocumentClass childClass = (DocumentClass)this.documentClassService.get((Serializable)documentClassAssociationDto.getChildClassId(), new String[]{"indexes"});
        DocumentClassAssociation documentClassAssociation = DocumentClassAssociation.builder().id(documentClassAssociationDto.getId()).parentClass(parentClass).childClass(childClass).separator(documentClassAssociationDto.getSeparator()).associateOnEmptyValues(documentClassAssociationDto.isAssociateOnEmptyValues()).build();
        List associatedIndexes = documentClassAssociationDto.getAssociatedIndexes().stream().map(dto -> this.mapAssociatedIndexesFromDto((AssociatedIndexesDto)dto, parentClass, childClass, documentClassAssociation)).collect(Collectors.toList());
        List displayedIndexes = documentClassAssociationDto.getDisplayedIndexes().stream().map(dto -> this.toDisplayedIndex((DisplayedIndexDto)dto, documentClassAssociation)).collect(Collectors.toList());
        documentClassAssociation.setAssociatedIndexes(associatedIndexes);
        documentClassAssociation.setDisplayedChildIndexes(displayedIndexes);
        return documentClassAssociation;
    }

    public DocumentClassAssociationDto toDocumentClassAssociationDto(DocumentClassAssociation documentClassAssociation) {
        List<AssociatedIndexesDto> associatedIndexes = documentClassAssociation.getAssociatedIndexes().stream().map(AssociatedIndexesDto::fromEntity).collect(Collectors.toList());
        List<DisplayedIndexDto> displayedIndexes = documentClassAssociation.getDisplayedChildIndexes().stream().map(this::toDisplayedIndexDto).collect(Collectors.toList());
        String translatedParentClassName = this.documentClassService.getDocumentClassTranslation(documentClassAssociation.getParentClass().getId(), TranslatedFieldType.NAME);
        String translatedChildClassName = this.documentClassService.getDocumentClassTranslation(documentClassAssociation.getChildClass().getId(), TranslatedFieldType.NAME);
        return DocumentClassAssociationDto.builder().id(documentClassAssociation.getId()).parentClassId(documentClassAssociation.getParentClass().getId()).parentClassName(translatedParentClassName).childClassId(documentClassAssociation.getChildClass().getId()).childClassName(translatedChildClassName).associatedIndexes(associatedIndexes).displayedIndexes(displayedIndexes).separator(documentClassAssociation.getSeparator()).associateOnEmptyValues(documentClassAssociation.isAssociateOnEmptyValues()).build();
    }

    public AssociatedDocumentsDto getParentSideAssociatedDocumentsDto(DocumentClassAssociation association, Long documentId, Long parentDocumentClassId, String userName) {
        Long associatedDocumentClassId = association.getChildClass().getId();
        int documentsCount = (int)this.documentClassAssociationService.getAssociatedDocumentsFromClass(parentDocumentClassId, documentId, associatedDocumentClassId, null, null, null, null, userName).getTotal();
        String associatedDocumentClassName = this.documentClassService.getDocumentClassTranslation(associatedDocumentClassId, TranslatedFieldType.NAME);
        List<DisplayedIndexDto> displayedIndexes = association.getDisplayedChildIndexes().stream().map(displayedIndex -> this.toDisplayedIndexDto((DisplayedIndex)displayedIndex)).collect(Collectors.toList());
        return AssociatedDocumentsDto.builder().documentClassId(associatedDocumentClassId).documentClassName(associatedDocumentClassName).documentsCount(documentsCount).displayedIndexes(displayedIndexes).build();
    }

    public AssociatedDocumentsDto getChildSideAssociatedDocumentsDto(DocumentClassAssociation association, Long documentId, Long childDocumentClassId, String userName, List<AssociatedDocumentsDto> parentDtos) {
        Long associatedDocumentClassId = association.getParentClass().getId();
        int documentsCount = (int)this.documentClassAssociationService.getAssociatedDocumentsFromClass(childDocumentClassId, documentId, associatedDocumentClassId, null, null, null, null, userName).getTotal();
        String associatedDocumentClassName = this.documentClassService.getDocumentClassTranslation(associatedDocumentClassId, TranslatedFieldType.NAME);
        Optional<AssociatedDocumentsDto> parentAssociatedDocumentsDtoOptional = parentDtos.stream().filter(parentDto -> parentDto.getDocumentClassId().equals(associatedDocumentClassId)).findFirst();
        List<DisplayedIndexDto> displayedIndexes = parentAssociatedDocumentsDtoOptional.isPresent() ? parentAssociatedDocumentsDtoOptional.get().getDisplayedIndexes() : this.documentClassIndexFinder.findByDocumentClass(associatedDocumentClassId).stream().map(index -> this.toDisplayedIndexDto((DocumentClassIndex)index)).collect(Collectors.toList());
        return AssociatedDocumentsDto.builder().documentClassId(associatedDocumentClassId).documentClassName(associatedDocumentClassName).documentsCount(documentsCount).displayedIndexes(displayedIndexes).build();
    }

    public DocumentDto toDocumentDto(WfDocument wfDocument, String userName) {
        DocumentDto dto = DocumentDto.fromDocument(wfDocument);
        int docCount = this.documentClassAssociationService.getAllAssociatedDocumentsForClass(wfDocument.getDocumentClassId(), Long.valueOf(wfDocument.getFile().getId()), userName).size();
        dto.setAssociatedDocumentsCount(docCount);
        return dto;
    }

    private AssociatedIndexes mapAssociatedIndexesFromDto(AssociatedIndexesDto associatedIndextesDto, DocumentClass parentClass, DocumentClass childClass, DocumentClassAssociation documentClassAssociation) {
        DocumentClassIndex parentClassIndex = parentClass.getIndexes().stream().filter(index -> index.getId().equals(associatedIndextesDto.getParentIndexId())).findAny().get();
        DocumentClassIndex childClassIndex = childClass.getIndexes().stream().filter(index -> index.getId().equals(associatedIndextesDto.getChildIndexId())).findAny().get();
        return AssociatedIndexes.builder().id(associatedIndextesDto.getId()).parentIndex(parentClassIndex).childIndex(childClassIndex).documentClassAssociation(documentClassAssociation).build();
    }

    private DisplayedIndex toDisplayedIndex(DisplayedIndexDto displayedIndexDto, DocumentClassAssociation documentClassAssociation) {
        return DisplayedIndex.builder().id(displayedIndexDto.getId()).index((DocumentClassIndex)this.documentClassIndexFinder.get((Serializable)displayedIndexDto.getIndexId())).ordinalNumber(displayedIndexDto.getOrdinalNumber()).documentClassAssociation(documentClassAssociation).build();
    }

    private DisplayedIndexDto toDisplayedIndexDto(DocumentClassIndex index) {
        return DisplayedIndexDto.builder().id(null).indexId(index.getId()).ordinalNumber(index.getOrderId().intValue()).indexName(this.documentClassService.getDocumentClassIndexTranslation(index.getId(), TranslatedFieldType.NAME)).build();
    }

    private DisplayedIndexDto toDisplayedIndexDto(DisplayedIndex displayedIndex) {
        return DisplayedIndexDto.builder().id(displayedIndex.getId()).indexId(displayedIndex.getIndex().getId()).ordinalNumber(displayedIndex.getOrdinalNumber()).indexName(this.documentClassService.getDocumentClassIndexTranslation(displayedIndex.getIndex().getId(), TranslatedFieldType.NAME)).build();
    }
}

