/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.dto.workflow.summary;

import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.translation.configElements.TranslatedFieldType;
import com.suncode.pwfl.util.ServiceFactory;
import java.beans.ConstructorProperties;

public class DocumentClassDto {
    private long id;
    private String translatedName;

    public static DocumentClassDto fromEntity(DocumentClass documentClass) {
        DocumentClassService documentClassService = ServiceFactory.getDocumentClassService();
        return DocumentClassDto.builder().id(documentClass.getId()).translatedName(documentClassService.getDocumentClassTranslation(documentClass.getId(), TranslatedFieldType.NAME)).build();
    }

    public static DocumentClassDtoBuilder builder() {
        return new DocumentClassDtoBuilder();
    }

    public long getId() {
        return this.id;
    }

    public String getTranslatedName() {
        return this.translatedName;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setTranslatedName(String translatedName) {
        this.translatedName = translatedName;
    }

    public DocumentClassDto() {
    }

    @ConstructorProperties(value={"id", "translatedName"})
    public DocumentClassDto(long id, String translatedName) {
        this.id = id;
        this.translatedName = translatedName;
    }

    public static class DocumentClassDtoBuilder {
        private long id;
        private String translatedName;

        DocumentClassDtoBuilder() {
        }

        public DocumentClassDtoBuilder id(long id) {
            this.id = id;
            return this;
        }

        public DocumentClassDtoBuilder translatedName(String translatedName) {
            this.translatedName = translatedName;
            return this;
        }

        public DocumentClassDto build() {
            return new DocumentClassDto(this.id, this.translatedName);
        }

        public String toString() {
            return "DocumentClassDto.DocumentClassDtoBuilder(id=" + this.id + ", translatedName=" + this.translatedName + ")";
        }
    }
}

