/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.dto.archive;

import com.suncode.pwfl.archive.Directory;
import java.beans.ConstructorProperties;
import org.apache.commons.lang.StringEscapeUtils;

public class RootDirectoryDto {
    private Long id;
    private String directoryName;

    public static RootDirectoryDto fromEntity(Directory directory) {
        if (directory == null) {
            return null;
        }
        return RootDirectoryDto.builder().id(directory.getId()).directoryName(StringEscapeUtils.escapeHtml((String)directory.getDirectoryName())).build();
    }

    @ConstructorProperties(value={"id", "directoryName"})
    RootDirectoryDto(Long id, String directoryName) {
        this.id = id;
        this.directoryName = directoryName;
    }

    public static RootDirectoryDtoBuilder builder() {
        return new RootDirectoryDtoBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public String getDirectoryName() {
        return this.directoryName;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setDirectoryName(String directoryName) {
        this.directoryName = directoryName;
    }

    public static class RootDirectoryDtoBuilder {
        private Long id;
        private String directoryName;

        RootDirectoryDtoBuilder() {
        }

        public RootDirectoryDtoBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public RootDirectoryDtoBuilder directoryName(String directoryName) {
            this.directoryName = directoryName;
            return this;
        }

        public RootDirectoryDto build() {
            return new RootDirectoryDto(this.id, this.directoryName);
        }

        public String toString() {
            return "RootDirectoryDto.RootDirectoryDtoBuilder(id=" + this.id + ", directoryName=" + this.directoryName + ")";
        }
    }
}

