/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.dto.activity;

import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.form.dto.user.UserDto;
import com.suncode.pwfl.form.dto.user.builder.UserDtoBuilder;
import com.suncode.pwfl.web.dto.activity.DelegatedActivityDto;
import com.suncode.pwfl.workflow.activity.DelegatedActivity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DelegatedActivityDtoConverter {
    @Autowired
    private UserDtoBuilder userDtoBuilder;
    @Autowired
    private UserService userService;

    public DelegatedActivityDto convertToDto(DelegatedActivity delegatedActivity) {
        DelegatedActivityDto delegatedDto = new DelegatedActivityDto();
        delegatedDto.setId(delegatedActivity.getId());
        delegatedDto.setUser(this.createUserDto(delegatedActivity.getUserId()));
        delegatedDto.setDelegatedUser(this.createUserDto(delegatedActivity.getDelegatedUser()));
        delegatedDto.setActivityId(delegatedActivity.getActivityId());
        delegatedDto.setTransferType(delegatedActivity.getTransferType());
        return delegatedDto;
    }

    private UserDto createUserDto(String username) {
        User user = this.userService.getUser(username, false, new String[0]);
        if (user != null) {
            return this.userDtoBuilder.build(user);
        }
        UserDto userDto = new UserDto();
        userDto.setUserName(username);
        return userDto;
    }
}

