/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.workflow.archive;

import com.google.common.collect.ImmutableMap;
import com.suncode.cuf.archive.exception.DocumentClassNotFound;
import com.suncode.pwfl.archive.CipherAlgorithm;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentUploadSource;
import com.suncode.pwfl.archive.ExpirationType;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.export.extension.ExportExtension;
import com.suncode.pwfl.export.model.ExportColumn;
import com.suncode.pwfl.export.model.ExportColumnBuilder;
import com.suncode.pwfl.export.model.ExportModel;
import com.suncode.pwfl.export.service.ExportService;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.translation.configElements.TranslatedFieldType;
import com.suncode.pwfl.util.DtoComparator;
import com.suncode.pwfl.util.Paginator;
import com.suncode.pwfl.util.exception.ServiceException;
import com.suncode.pwfl.web.dto.archive.CipherAlgorithmDto;
import com.suncode.pwfl.web.dto.archive.CreateDocumentClassDto;
import com.suncode.pwfl.web.dto.archive.DocumentClassDto;
import com.suncode.pwfl.web.dto.archive.ExpirationTypeDto;
import com.suncode.pwfl.web.dto.archive.ReadDocumentClassDto;
import com.suncode.pwfl.web.dto.archive.UpdateDocumentClassDto;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.security.exception.NotFullRightsException;
import com.suncode.pwfl.web.support.DocumentClassMapper;
import com.suncode.pwfl.web.support.ajax.RestResult;
import com.suncode.pwfl.web.util.SessionUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"documents"})
public class DocumentClassController {
    private static final Logger log = LoggerFactory.getLogger(DocumentClassController.class);
    @Autowired
    private DocumentClassService documentClassService;
    @Autowired
    private DocumentClassMapper documentClassMapper;
    @Autowired
    private ExportService exportService;
    @Autowired
    private AuthorizationHelper authorizationHelper;
    @Autowired
    private MessageHelperBean messageHelper;
    private Map<UUID, List<ReadDocumentClassDto>> exportCache = new HashMap<UUID, List<ReadDocumentClassDto>>();

    @ResponseBody
    @RequestMapping(value={"classes"})
    public List<DocumentClass> getDocumentClasses(@RequestParam(required=false, defaultValue="ALL") DocumentUploadSource rightType) {
        List docClasses = this.documentClassService.getDocumentClassesForUser(SessionUtils.getLoggedUserName(), rightType);
        List<DocumentClass> translatedDocClasses = docClasses.stream().map(documentClass -> {
            TranslatedDocumentClass translatedDocumentClass = new TranslatedDocumentClass();
            BeanUtils.copyProperties((Object)documentClass, (Object)((Object)translatedDocumentClass));
            String translatedName = this.documentClassService.getDocumentClassTranslation(documentClass.getId(), TranslatedFieldType.NAME);
            translatedDocumentClass.setNameTranslated(translatedName);
            String translatedDescription = this.documentClassService.getDocumentClassTranslation(documentClass.getId(), TranslatedFieldType.DESCRIPTION);
            translatedDocumentClass.setDescriptionTranslated(translatedDescription);
            return translatedDocumentClass;
        }).collect(Collectors.toList());
        return translatedDocClasses;
    }

    @RequestMapping(value={"classes/all"})
    @ResponseBody
    public CountedResult<ReadDocumentClassDto> getAllDocumentClasses(@RequestParam(required=false, defaultValue="false") boolean withAddingRight, @RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit, @RequestParam(required=false, defaultValue="orderId") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) {
        List documentClasses = this.documentClassService.getDocumentClassesForUser(SessionUtils.getLoggedUserName(), withAddingRight).stream().map(this.documentClassMapper::toReadDocumentClassDto).sorted((Comparator<ReadDocumentClassDto>)DtoComparator.of(ReadDocumentClassDto.class, (String)sortBy, (SortDirection)sortDirection).withIgnoreCase(true)).collect(Collectors.toList());
        return Paginator.forAll(documentClasses).viewPageByOffset(start, limit);
    }

    @RequestMapping(value={"classes/export/{extension}"})
    @ResponseBody
    public void exportDocumentClasses(HttpServletResponse response, @PathVariable String extension, @RequestParam(required=false, defaultValue="orderId") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection, @RequestParam(required=false) UUID id) throws IOException {
        List<ReadDocumentClassDto> documentClasses;
        if (id != null) {
            documentClasses = this.exportCache.get(id);
            this.exportCache.remove(id);
        } else {
            documentClasses = this.documentClassService.getDocumentClassesForUser(SessionUtils.getLoggedUserName(), false).stream().map(this.documentClassMapper::toReadDocumentClassDto).sorted((Comparator<ReadDocumentClassDto>)DtoComparator.of(ReadDocumentClassDto.class, (String)sortBy, (SortDirection)sortDirection).withIgnoreCase(true)).collect(Collectors.toList());
        }
        List<ExportColumn> columns = Arrays.asList(ExportColumnBuilder.create().name(this.messageHelper.getMessage("Nazwa_klasy")).data(documentClasses).by(ReadDocumentClassDto::getTranslatedName).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Opis_klasy")).data(documentClasses).by(ReadDocumentClassDto::getTranslatedDescription).build());
        ExportModel model = ExportModel.builder().title(this.messageHelper.getMessage("Klasy_dokumentow")).columns(columns).build();
        ExportExtension extensionEnum = ExportExtension.valueOf((String)extension.toUpperCase());
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"export.%s\"", extensionEnum.getExtension()));
        this.exportService.export(model, extensionEnum, (OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"classes/export/{extension}"}, method={RequestMethod.POST})
    @ResponseBody
    public URI exportFilteredDocumentClasses(HttpServletRequest request, @RequestBody List<ReadDocumentClassDto> documentClasses, @PathVariable String extension) throws URISyntaxException {
        UUID id;
        while (this.exportCache.containsKey(id = UUID.randomUUID())) {
        }
        this.exportCache.put(id, documentClasses);
        URI redirectUri = URI.create(request.getRequestURI());
        redirectUri = redirectUri.getQuery() != null ? URI.create(request.getRequestURI() + String.format("&id=%s", id)) : URI.create(request.getRequestURI() + String.format("?id=%s", id));
        return redirectUri;
    }

    @RequestMapping(value={"classes/{documentClassId}"})
    @ResponseBody
    public DocumentClassDto getDocumentClass(@PathVariable Long documentClassId) throws DocumentClassNotFound {
        this.authorizationHelper.assertFullAdministrationRights(() -> {
            throw new NotFullRightsException(this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
        });
        DocumentClass documentClass = (DocumentClass)this.documentClassService.get((Serializable)documentClassId, new String[]{"directory", "directory.device"});
        if (documentClass == null) {
            throw new IllegalArgumentException(this.messageHelper.getMessage("Nie_znaleziono_klasy_dokumentow", new Object[]{documentClassId}));
        }
        return this.documentClassMapper.toDocumentClassDto(documentClass);
    }

    @RequestMapping(value={"classes/{documentClassId}/moveUp"})
    @ResponseBody
    public void moveUpDocumentClass(@PathVariable Long documentClassId) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {
            throw new NotFullRightsException(this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
        });
        this.documentClassService.moveUpDocumentClass(documentClassId);
    }

    @RequestMapping(value={"expirationTypes"})
    @ResponseBody
    public List<ExpirationTypeDto> getExpirationTypes() {
        return Arrays.asList(ExpirationType.values()).stream().map(ExpirationTypeDto::from).collect(Collectors.toList());
    }

    @RequestMapping(value={"cipherAlgorithms"})
    @ResponseBody
    public List<CipherAlgorithmDto> getCipherAlgorithms() {
        return Arrays.asList(CipherAlgorithm.values()).stream().map(CipherAlgorithmDto::from).collect(Collectors.toList());
    }

    @RequestMapping(value={"classes"}, method={RequestMethod.POST})
    @ResponseBody
    public RestResult createDocumentClass(HttpServletRequest request, @RequestBody CreateDocumentClassDto createDocumentClassDto) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {
            log.info("Nie mo\u017cna doda\u0107 klasy dokumentu z powodu braku uprawnie\u0144");
            throw new NotFullRightsException(this.messageHelper.getMessage("Brak_uprawnien_aby_dodac_klase_dokumentow"));
        });
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_ADD_DOCCLASS);
        DocumentClass documentClass = this.documentClassMapper.toEntity(createDocumentClassDto);
        this.documentClassService.createDocumentClass(documentClass);
        auditBuilder.params(this.createAddDocClassAuditParams(createDocumentClassDto, this.documentClassService.getDocumentClass(documentClass.getName(), new String[0]).getId()));
        request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
        return new RestResult(true);
    }

    @RequestMapping(value={"classes/{documentClassId}"}, method={RequestMethod.PATCH})
    @ResponseBody
    public void updateDocumentClass(HttpServletRequest request, @PathVariable Long documentClassId, @RequestBody UpdateDocumentClassDto updateDocumentClassDto) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {
            log.info("Nie mo\u017cna zmieni\u0107 klasy dokumentu z powodu braku uprawnie\u0144");
            throw new NotFullRightsException(this.messageHelper.getMessage("Brak_uprawnien_aby_zmienic_klase_dokumentow"));
        });
        DocumentClass documentClassToUpdate = (DocumentClass)this.documentClassService.get((Serializable)documentClassId, new String[]{"directory"});
        this.documentClassService.updateDocumentClass(this.documentClassMapper.toEntity(updateDocumentClassDto, documentClassId));
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_UPDATE_DOCCLASS);
        auditBuilder.params(this.createUpdateDocClassAuditParams(documentClassToUpdate, updateDocumentClassDto));
        request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
    }

    @RequestMapping(value={"classes/{documentClassId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public RestResult deleteDocumentClass(HttpServletRequest request, @PathVariable Long documentClassId) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {
            log.info("Nie mo\u017cna usun\u0105\u0107 klasy dokumentu z powodu braku uprawnie\u0144");
            throw new NotFullRightsException(this.messageHelper.getMessage("Brak_uprawnien_aby_usunac_klase_dokumentow"));
        });
        this.documentClassService.deleteDocumentClass(documentClassId);
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_DOCCLASS);
        auditBuilder.params((Map)ImmutableMap.of((Object)"docClassId", (Object)documentClassId));
        request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
        return new RestResult(true);
    }

    @ResponseBody
    @RequestMapping(value={"classes/haveFiles"})
    public boolean doDocumentClassesHaveFiles(@RequestParam List<String> documentClassesIds) {
        for (String id : documentClassesIds) {
            File documentClassIndexDirectory;
            DocumentClass documentClass = (DocumentClass)this.documentClassService.get((Serializable)Long.valueOf(id));
            if (StringUtils.isBlank((CharSequence)documentClass.getIndexPath()) || !(documentClassIndexDirectory = new File(documentClass.getIndexPath())).exists() || documentClassIndexDirectory.listFiles().length <= 0) continue;
            return true;
        }
        return false;
    }

    private Map<String, Object> createAddDocClassAuditParams(CreateDocumentClassDto createDocumentClassDto, Long docClassId) {
        String keyLength;
        String dayCountExpiration = "";
        String endDayExpiration = "";
        String periodExpiration = "";
        ExpirationType expirationType = createDocumentClassDto.getExpirationType();
        String string = keyLength = createDocumentClassDto.getKeyLength() != null && createDocumentClassDto.getKeyLength() > 0L ? createDocumentClassDto.getKeyLength().toString() : "";
        if (createDocumentClassDto.getExpiration() == null) {
            expirationType = null;
        }
        if (expirationType != null) {
            dayCountExpiration = expirationType.equals((Object)ExpirationType.DAY_COUNT) ? createDocumentClassDto.getExpiration() : "";
            endDayExpiration = expirationType.equals((Object)ExpirationType.END_DAY) ? createDocumentClassDto.getExpiration() : "";
            periodExpiration = expirationType.equals((Object)ExpirationType.PERIOD) ? createDocumentClassDto.getExpiration() : "";
        }
        return ImmutableMap.builder().put((Object)"docClassId", (Object)docClassId).put((Object)"docclassName", (Object)StringUtils.defaultString((String)createDocumentClassDto.getName())).put((Object)"docclassDescr", (Object)StringUtils.defaultString((String)createDocumentClassDto.getDescription())).put((Object)"maxFileSize", Objects.nonNull(createDocumentClassDto.getMaxFileSizeMb()) ? createDocumentClassDto.getMaxFileSizeMb() : "").put((Object)"expireDocumentType", Objects.nonNull(expirationType) ? expirationType : "on").put((Object)"docclassExpiretion", (Object)dayCountExpiration).put((Object)"docclassExpiretion2", (Object)endDayExpiration).put((Object)"docclassExpiretion3", (Object)periodExpiration).put((Object)"directoryName", (Object)createDocumentClassDto.getDirectoryId()).put((Object)"docclassComperssing", (Object)createDocumentClassDto.isCompressing()).put((Object)"docclassEncoding", (Object)createDocumentClassDto.isEncoding()).put((Object)"cipherAlgorithm", (Object)(Objects.nonNull(createDocumentClassDto.getCipherAlgorithm()) ? createDocumentClassDto.getCipherAlgorithm().name() : "")).put((Object)"keyLenght", (Object)keyLength).put((Object)"docclassIndexing", (Object)createDocumentClassDto.isIndexing()).put((Object)"icon", (Object)createDocumentClassDto.getIconName()).put((Object)"iconColor", (Object)createDocumentClassDto.getIconColor()).build();
    }

    private Map<String, Object> createUpdateDocClassAuditParams(DocumentClass oldDocumentClass, UpdateDocumentClassDto updateDocumentClassDto) {
        String oldDayCountExpiration = oldDocumentClass.getExpirationType().equals(ExpirationType.DAY_COUNT.getValue()) ? oldDocumentClass.getExpiration() : "";
        String oldEndDayExpiration = oldDocumentClass.getExpirationType().equals(ExpirationType.END_DAY.getValue()) ? oldDocumentClass.getExpiration() : "";
        String oldPeriodExpiration = oldDocumentClass.getExpirationType().equals(ExpirationType.PERIOD.getValue()) ? oldDocumentClass.getExpiration() : "";
        String dayCountExpiration = "";
        String endDayExpiration = "";
        String periodExpiration = "";
        ExpirationType expirationType = updateDocumentClassDto.getExpirationType();
        if (updateDocumentClassDto.getExpiration() == null) {
            expirationType = null;
        }
        if (expirationType != null) {
            dayCountExpiration = expirationType.equals((Object)ExpirationType.DAY_COUNT) ? updateDocumentClassDto.getExpiration() : "";
            endDayExpiration = expirationType.equals((Object)ExpirationType.END_DAY) ? updateDocumentClassDto.getExpiration() : "";
            periodExpiration = expirationType.equals((Object)ExpirationType.PERIOD) ? updateDocumentClassDto.getExpiration() : "";
        }
        Long oldMaxFileSize = Objects.nonNull(oldDocumentClass.getMaxFileSize()) ? Long.valueOf(oldDocumentClass.getMaxFileSize() / 1024L) : null;
        String oldCipherAlgorithm = oldDocumentClass.getCipherAlgorithm() != null && oldDocumentClass.isEncoding() ? oldDocumentClass.getCipherAlgorithm() : "";
        String cipherAlgorithm = Objects.nonNull(updateDocumentClassDto.getCipherAlgorithm()) ? updateDocumentClassDto.getCipherAlgorithm().name() : "";
        String oldKeyLength = !oldDocumentClass.getKeyLength().equals(0L) ? oldDocumentClass.getKeyLength().toString() : "";
        String keyLength = !updateDocumentClassDto.getKeyLength().equals(0L) ? updateDocumentClassDto.getKeyLength().toString() : "";
        return ImmutableMap.builder().put((Object)"docclassId", (Object)oldDocumentClass.getId()).put((Object)"docclassName", (Object)(oldDocumentClass.getName() + ";" + StringUtils.defaultString((String)updateDocumentClassDto.getName()))).put((Object)"docclassDescr", (Object)(Objects.toString(oldDocumentClass.getDescription(), "") + ";" + StringUtils.defaultString((String)updateDocumentClassDto.getDescription()))).put((Object)"maxFileSize", (Object)(Objects.toString(oldMaxFileSize, "") + " > " + Objects.toString(updateDocumentClassDto.getMaxFileSizeMb(), ""))).put((Object)"expireDocumentType", (Object)(oldDocumentClass.getExpirationType() + ";" + Objects.toString(expirationType, "on"))).put((Object)"docclassExpiretion", (Object)(oldDayCountExpiration + " > " + dayCountExpiration)).put((Object)"docclassExpiretion2", (Object)(oldEndDayExpiration + " > " + endDayExpiration)).put((Object)"docclassExpiretion3", (Object)(oldPeriodExpiration + " > " + periodExpiration)).put((Object)"directoryName", (Object)(oldDocumentClass.getDirectory().getId() + " > " + updateDocumentClassDto.getDirectoryId())).put((Object)"docclassComperssing", (Object)(oldDocumentClass.isCompressing() + ";" + updateDocumentClassDto.isCompressing())).put((Object)"docclassEncoding", (Object)(oldDocumentClass.isEncoding() + ";" + updateDocumentClassDto.isEncoding())).put((Object)"cipherAlgorithm", (Object)(oldCipherAlgorithm + " > " + cipherAlgorithm)).put((Object)"keyLenght", (Object)(oldKeyLength + " > " + keyLength)).put((Object)"docclassIndexing", (Object)(oldDocumentClass.isIndexing() + ";" + updateDocumentClassDto.isIndexing())).put((Object)"logicalConnection", (Object)(oldDocumentClass.getLogicalConnection() + " > " + updateDocumentClassDto.getLogicalConnection())).put((Object)"icon", (Object)(oldDocumentClass.getIconName() + ";" + updateDocumentClassDto.getIconName())).put((Object)"iconColor", (Object)(oldDocumentClass.getIconColor() + ";" + updateDocumentClassDto.getIconColor())).build();
    }

    @ExceptionHandler(value={IllegalArgumentException.class, ServiceException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public RestResult handleBadRequests(Exception e) {
        log.error("", (Throwable)e);
        return new RestResult(false, e.getMessage());
    }

    @ExceptionHandler(value={NotFullRightsException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    @ResponseBody
    public RestResult handleUnauthorizedRequests(NotFullRightsException e) {
        return new RestResult(false, e.getMessage());
    }

    private class TranslatedDocumentClass
    extends DocumentClass {
        private String nameTranslated;
        private String descriptionTranslated;

        private TranslatedDocumentClass() {
        }

        public String getNameTranslated() {
            return this.nameTranslated;
        }

        public void setNameTranslated(String nameTranslated) {
            this.nameTranslated = nameTranslated;
        }

        public String getDescriptionTranslated() {
            return this.descriptionTranslated;
        }

        public void setDescriptionTranslated(String descriptionTranslated) {
            this.descriptionTranslated = descriptionTranslated;
        }
    }
}

