/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.translations;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.configuration.dto.translations.TranslationType;
import com.suncode.pwfl.export.extension.ExportExtension;
import com.suncode.pwfl.export.model.ExportColumn;
import com.suncode.pwfl.export.model.ExportColumnBuilder;
import com.suncode.pwfl.export.model.ExportModel;
import com.suncode.pwfl.export.service.ExportService;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.translation.ConfigElementTranslationProvider;
import com.suncode.pwfl.translation.ConfigElementTranslationService;
import com.suncode.pwfl.translation.ImportConfigElementTranslationsService;
import com.suncode.pwfl.translation.ImportTranslationsResult;
import com.suncode.pwfl.translation.dto.ConfigElementModifiedTranslationDto;
import com.suncode.pwfl.translation.dto.ConfigElementTranslationDto;
import com.suncode.pwfl.util.exception.LocalizedServiceException;
import com.suncode.pwfl.util.exception.ServiceException;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.security.exception.NotFullRightsException;
import com.suncode.pwfl.web.support.ajax.RestResult;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/i18n/types/config_element", "/i18n/types/CONFIG_ELEMENT"})
public class ConfigElementTranslationsController {
    private static final Logger log = LoggerFactory.getLogger(ConfigElementTranslationsController.class);
    private final AuthorizationHelper authorizationHelper;
    private final ConfigElementTranslationProvider translationProvider;
    private final ConfigElementTranslationService translationService;
    private final ExportService exportService;
    private final ImportConfigElementTranslationsService importTranslationsService;
    private final MessageHelperBean messageHelper;

    @ResponseBody
    @RequestMapping(value={"sources"}, method={RequestMethod.GET})
    public List<String> getTranslationTypeSources() {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        return this.translationService.getTranslationSources();
    }

    @ResponseBody
    @RequestMapping(value={"locales"}, method={RequestMethod.GET})
    public List<String> getTypeLocales() {
        return this.translationService.getLocales();
    }

    @ResponseBody
    @RequestMapping(value={"locales/{locale}/translations"}, method={RequestMethod.GET})
    public List<ConfigElementTranslationDto> getDefaultTranslations(@PathVariable String locale) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        return this.translationProvider.getDefaultTranslations();
    }

    @ResponseBody
    @RequestMapping(value={"locales/{locale}/translations/custom"}, method={RequestMethod.GET})
    public List<ConfigElementTranslationDto> getModifiedTranslations(@PathVariable String locale) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        return this.translationProvider.getModifiedTranslations(Locale.forLanguageTag(locale));
    }

    @ResponseBody
    @RequestMapping(value={"locales/{locale}/translations/custom"}, method={RequestMethod.PUT})
    public void updateTranslations(@PathVariable String locale, @RequestBody List<ConfigElementModifiedTranslationDto> modifiedTranslations) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        this.translationService.updateTranslations(modifiedTranslations, Locale.forLanguageTag(locale));
    }

    @RequestMapping(value={"locales/{locale}/translations/custom"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.OK)
    public void resetAllTranslations(@PathVariable String locale, @RequestBody(required=false) List<String> sources) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        if (sources == null) {
            sources = Collections.emptyList();
        }
        this.translationService.resetTranslations(sources, Locale.forLanguageTag(locale));
    }

    @RequestMapping(value={"export/excel"}, method={RequestMethod.POST})
    @ResponseBody
    public void exportConfigElementTranslationsToExcel(HttpServletResponse response, @RequestBody List<ConfigElementTranslationDto> translationsToExport) throws IOException {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        List locales = this.translationService.getLocales();
        ArrayList allDefaultConfigElementTranslations = new ArrayList();
        for (Object locale : locales) {
            allDefaultConfigElementTranslations.addAll(this.translationProvider.getDefaultTranslations());
        }
        ArrayList allModifiedConfigElementTranslations = new ArrayList();
        for (Object locale : locales) {
            allModifiedConfigElementTranslations.addAll(this.translationProvider.getModifiedTranslations(Locale.forLanguageTag((String)locale)));
        }
        ArrayList<ExportColumn> columns = new ArrayList<ExportColumn>(Arrays.asList(ExportColumnBuilder.create().name(this.messageHelper.getMessage("Zrodlo")).data(translationsToExport).by(configElementTranslation -> configElementTranslation.getSource().name()).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Identyfikator")).data(translationsToExport).by(configElementTranslationDto -> configElementTranslationDto.getTranslatedEntityId().toString()).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Typ_pola")).data(translationsToExport).by(configElementTranslation -> configElementTranslation.getTranslatedFieldType().name()).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Klucz")).data(translationsToExport).by(configElementTranslation -> String.format("%s -> %s -> %s", this.messageHelper.getMessage("TranslatedConfigElementType_" + configElementTranslation.getSource().name()), configElementTranslation.getTranslatedEntityName(), this.messageHelper.getMessage("TranslatedFieldType_" + configElementTranslation.getTranslatedFieldType().name()))).build()));
        for (String locale : locales) {
            columns.add(ExportColumnBuilder.create().name(String.format("%s_%s", this.messageHelper.getMessage("Wartosc"), locale)).data(translationsToExport).by(translationToExport -> this.getTranslatedValueForLocale(allDefaultConfigElementTranslations, allModifiedConfigElementTranslations, (ConfigElementTranslationDto)translationToExport, locale)).build());
        }
        ExportModel model = ExportModel.builder().title(this.messageHelper.getMessage("Elementy_konfiguracyjne_systemu")).columns(columns).build();
        ExportExtension extensionEnum = ExportExtension.EXCEL;
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", String.format("attachment; filename=export_config-element-translations.%s", extensionEnum.getExtension()));
        this.exportService.export(model, extensionEnum, (OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"export/json"}, method={RequestMethod.POST})
    @ResponseBody
    public void exportConfigElementTranslationsToJson(HttpServletResponse response, @RequestBody List<ConfigElementTranslationDto> translationsToExport) throws IOException {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        List locales = this.translationService.getLocales();
        ArrayList<ConfigElementTranslationDto> allDefaultConfigElementTranslations = new ArrayList<ConfigElementTranslationDto>();
        ArrayList<ConfigElementTranslationDto> allModifiedConfigElementTranslations = new ArrayList<ConfigElementTranslationDto>();
        for (String locale : locales) {
            allDefaultConfigElementTranslations.addAll(this.translationProvider.getDefaultTranslations());
            allModifiedConfigElementTranslations.addAll(this.translationProvider.getModifiedTranslations(Locale.forLanguageTag(locale)));
        }
        ObjectMapper objectMapper = new ObjectMapper();
        ArrayList<ObjectNode> translationNodes = new ArrayList<ObjectNode>();
        for (ConfigElementTranslationDto translation : translationsToExport) {
            ObjectNode translationNode = objectMapper.createObjectNode();
            translationNode.put("source", translation.getSource().name());
            translationNode.put("key", this.importTranslationsService.getConfigElementTranslationKey(translation));
            translationNode.put("translatedFieldType", translation.getTranslatedFieldType().name());
            for (String locale : locales) {
                translationNode.put("value_" + locale, this.getTranslatedValueForLocale(allDefaultConfigElementTranslations, allModifiedConfigElementTranslations, translation, locale));
            }
            translationNodes.add(translationNode);
        }
        String json = objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(translationNodes);
        response.setContentType("application/json");
        response.setHeader("Content-Disposition", "attachment; filename=export_config-element-translations.json");
        response.getOutputStream().write(json.getBytes());
        response.getOutputStream().flush();
    }

    private String getTranslatedValueForLocale(List<ConfigElementTranslationDto> defaultConfigElementTranslations, List<ConfigElementTranslationDto> modifiedConfigElementTranslations, ConfigElementTranslationDto translationToExport, String locale) {
        Optional<String> translatedValue = modifiedConfigElementTranslations.stream().filter(configElementTranslation -> configElementTranslation.getSource().equals((Object)translationToExport.getSource()) && configElementTranslation.getTranslatedEntityId().equals(translationToExport.getTranslatedEntityId()) && configElementTranslation.getTranslatedFieldType().equals((Object)translationToExport.getTranslatedFieldType()) && configElementTranslation.getLocale().equalsIgnoreCase(locale)).map(ConfigElementTranslationDto::getValue).findFirst();
        return translatedValue.isPresent() ? translatedValue.get() : defaultConfigElementTranslations.stream().filter(configElementTranslation -> configElementTranslation.getSource().equals((Object)translationToExport.getSource()) && configElementTranslation.getTranslatedEntityId().equals(translationToExport.getTranslatedEntityId()) && configElementTranslation.getTranslatedFieldType().equals((Object)translationToExport.getTranslatedFieldType())).map(ConfigElementTranslationDto::getValue).findFirst().orElse("");
    }

    @RequestMapping(value={"import/excel"}, method={RequestMethod.POST})
    @ResponseBody
    public ImportTranslationsResult importConfigElementTranslationsFromExcel(HttpServletRequest request, @RequestBody byte[] excelFileData) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_IMPORT_TRANSLATIONS);
        HashMap<String, Object> auditParams = new HashMap<String, Object>();
        auditParams.put("fileFormat", "Excel");
        auditParams.put("translationType", TranslationType.CONFIG_ELEMENT.name());
        try {
            ImportTranslationsResult result = this.importTranslationsService.importTranslationsFromExcel(excelFileData);
            auditParams.put("addedCount", result.getAddedCount());
            auditParams.put("modifiedCount", result.getModifiedCount());
            auditBuilder.params(auditParams);
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
            return result;
        }
        catch (Exception e) {
            auditBuilder.params(auditParams);
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    @RequestMapping(value={"import/json"}, method={RequestMethod.POST})
    @ResponseBody
    public ImportTranslationsResult importConfigElementTranslationsFromJson(HttpServletRequest request, @RequestBody JsonNode jsonData) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_IMPORT_TRANSLATIONS);
        HashMap<String, Object> auditParams = new HashMap<String, Object>();
        auditParams.put("fileFormat", "JSON");
        auditParams.put("translationType", TranslationType.CONFIG_ELEMENT.name());
        try {
            ImportTranslationsResult result = this.importTranslationsService.importTranslationsFromJson(jsonData);
            auditParams.put("addedCount", result.getAddedCount());
            auditParams.put("modifiedCount", result.getModifiedCount());
            auditBuilder.params(auditParams);
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
            return result;
        }
        catch (Exception e) {
            auditBuilder.params(auditParams);
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    @ExceptionHandler(value={IllegalArgumentException.class, ServiceException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public RestResult handleBadRequestExceptions(Exception e) {
        return new RestResult(false, e.getMessage());
    }

    @ExceptionHandler(value={LocalizedServiceException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public RestResult handleLocalizedServiceException(LocalizedServiceException e) {
        return new RestResult(false, e.getLocalizedMessage());
    }

    @ExceptionHandler(value={NotFullRightsException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    @ResponseBody
    public RestResult handleNotFullRightsException(NotFullRightsException e) {
        log.info(this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
        return new RestResult(false, this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
    }

    @ConstructorProperties(value={"authorizationHelper", "translationProvider", "translationService", "exportService", "importTranslationsService", "messageHelper"})
    @Autowired
    public ConfigElementTranslationsController(AuthorizationHelper authorizationHelper, ConfigElementTranslationProvider translationProvider, ConfigElementTranslationService translationService, ExportService exportService, ImportConfigElementTranslationsService importTranslationsService, MessageHelperBean messageHelper) {
        this.authorizationHelper = authorizationHelper;
        this.translationProvider = translationProvider;
        this.translationService = translationService;
        this.exportService = exportService;
        this.importTranslationsService = importTranslationsService;
        this.messageHelper = messageHelper;
    }
}

