/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.substitutions;

import com.google.common.collect.ImmutableMap;
import com.plusmpm.database.authorization.RightTreeBuilder;
import com.plusmpm.util.Authorization;
import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemPropertiesBean;
import com.suncode.pwfl.administration.substitution.Substitution;
import com.suncode.pwfl.administration.substitution.SubstitutionAddingType;
import com.suncode.pwfl.administration.substitution.SubstitutionDto;
import com.suncode.pwfl.administration.substitution.SubstitutionFormDto;
import com.suncode.pwfl.administration.substitution.SubstitutionHook;
import com.suncode.pwfl.administration.substitution.SubstitutionService;
import com.suncode.pwfl.administration.substitution.SubstitutionType;
import com.suncode.pwfl.administration.substitution.exception.SubstitutionException;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.export.extension.ExportExtension;
import com.suncode.pwfl.export.model.ExportColumn;
import com.suncode.pwfl.export.model.ExportColumnBuilder;
import com.suncode.pwfl.export.model.ExportModel;
import com.suncode.pwfl.export.service.ExportService;
import com.suncode.pwfl.hook.HookRegistry;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.util.exception.ServiceException;
import com.suncode.pwfl.web.controller.api.substitutions.SubstitutionMapper;
import com.suncode.pwfl.web.security.exception.NoRightsException;
import com.suncode.pwfl.web.support.ajax.RestResult;
import com.suncode.pwfl.workflow.process.ProcessService;
import com.suncode.pwfl.workflow.process.ProcessType;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"substitutions"})
public class SubstitutionController {
    private final SubstitutionService substitutionService;
    private final SystemPropertiesBean systemProperties;
    private final ExportService exportService;
    private final MessageHelperBean messageHelper;
    private final SubstitutionMapper substitutionMapper;
    private final HookRegistry hookRegistry;
    private final ProcessService processService;

    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<SubstitutionDto> getSubstitutions(HttpServletRequest request, SubstitutionFormDto substitutionFormDto, @RequestParam Integer start, @RequestParam Integer limit, @RequestParam(required=false, defaultValue="lStartDate") String sortBy, @RequestParam(required=false, defaultValue="DESC") SortDirection sortDirection) {
        String username = UserContext.current().getUser().getUserName();
        if (substitutionFormDto.getIsSearch().booleanValue()) {
            AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_SEARCH_SUBSTITUTIONS);
            ImmutableMap params = new ImmutableMap.Builder().put((Object)"processName", (Object)StringUtils.defaultString((String)substitutionFormDto.getProcessDefId(), (String)"*")).put((Object)"participantName", (Object)StringUtils.defaultString((String)substitutionFormDto.getRoleId(), (String)"*")).put((Object)"usernameId", (Object)StringUtils.defaultString((String)substitutionFormDto.getSubstitutedUsername())).put((Object)"delegatedUserName", (Object)StringUtils.defaultString((String)substitutionFormDto.getSubstituteUsername())).put((Object)"startDate", (Object)StringUtils.defaultIfEmpty((String)substitutionFormDto.getStartDate(), (String)"*")).put((Object)"finishDate", (Object)StringUtils.defaultIfEmpty((String)substitutionFormDto.getFinishDate(), (String)"*")).build();
            auditBuilder.params((Map)params).buildSuccess(request);
        }
        return this.substitutionService.findSubstitutionsByFilters(username, this.getDisplayType(username), substitutionFormDto, start, limit, sortBy, sortDirection, substitutionFormDto.getOnlyActive());
    }

    private String getDisplayType(String username) {
        String displayType = this.systemProperties.getString(DefinedSystemParameter.DELEGATION_TYPE);
        if (displayType == null || Authorization.checkIsUserAdmin((String)username)) {
            displayType = SubstitutionType.ALL.toString();
        }
        return displayType;
    }

    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    public RestResult addSubstitution(@RequestBody SubstitutionFormDto substitutionFormDto) throws ParseException {
        String username = UserContext.current().getUser().getUserName();
        if (!substitutionFormDto.getSubstitutedUsername().equals(username) && !this.loggedUserHasAdminRights()) {
            throw new NoRightsException(this.messageHelper.getMessage("Brak_uprawnien_do_dodania_zastepstwa_dla_innego_uzytkownika"));
        }
        if (this.hookRegistry.hasHooks(SubstitutionHook.class) && substitutionFormDto.getProcessDefId().equals("*")) {
            LinkedList<Substitution> substitutions = new LinkedList<Substitution>();
            Substitution substitution = this.substitutionMapper.toEntity(substitutionFormDto);
            List userProcessesTypes = ((SubstitutionHook)this.hookRegistry.invoke(SubstitutionHook.class)).filterProcesses(substitutionFormDto.getSubstitutedUsername(), this.processService.getAllProcessTypes(false));
            for (ProcessType processType : userProcessesTypes) {
                Substitution toAdd = new Substitution(null, processType.getProcessDefId(), substitution.getRole(), substitution.getSubstituted(), substitution.getSubstitute(), null, null);
                toAdd.setFinishDate(substitution.getFinishDate());
                toAdd.setStartDate(substitution.getStartDate());
                substitutions.add(toAdd);
            }
            this.substitutionService.addSubstitutions(substitutions);
            return new RestResult(true, SubstitutionAddingType.SUBSTITUTION_NEW.toString());
        }
        Substitution substitution = this.substitutionMapper.toEntity(substitutionFormDto);
        SubstitutionAddingType substitutionAddingType = this.substitutionService.addSubstitution(substitution);
        return new RestResult(true, substitutionAddingType.toString());
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public RestResult deleteSubstitution(@PathVariable Long id) {
        this.substitutionService.deleteSubstitution(id);
        return new RestResult(true);
    }

    @RequestMapping(value={"export/{extension}"}, method={RequestMethod.GET})
    public void exportSubstitutions(HttpServletResponse response, SubstitutionFormDto substitutionFormDto, @PathVariable String extension, @RequestParam(required=false, defaultValue="substitute") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) throws IOException {
        String username = UserContext.current().getUser().getUserName();
        List substitutions = substitutionFormDto != null ? this.substitutionService.findSubstitutionsByFilters(username, this.getDisplayType(username), substitutionFormDto, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE), sortBy, sortDirection, substitutionFormDto.getOnlyActive()).getData() : this.substitutionService.findSubstitutions(UserContext.current().getUser().getUserName(), this.getDisplayType(username), Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE), sortBy, sortDirection).getData();
        List<ExportColumn> columns = Arrays.asList(this.buildExportColumn(this.messageHelper.getMessage("Proces"), substitutions, SubstitutionDto::getProcessDefName), this.buildExportColumn(this.messageHelper.getMessage("Uczestnik"), substitutions, SubstitutionDto::getRoleName), this.buildExportColumn(this.messageHelper.getMessage("Uzytkownik"), substitutions, SubstitutionDto::getSubstitutedFullName), this.buildExportColumn(this.messageHelper.getMessage("Zastepca"), substitutions, SubstitutionDto::getSubstituteFullName), this.buildExportColumn(this.messageHelper.getMessage("Od"), substitutions, SubstitutionDto::getStartDate), this.buildExportColumn(this.messageHelper.getMessage("Do"), substitutions, SubstitutionDto::getFinishDate));
        ExportModel model = ExportModel.builder().title(this.messageHelper.getMessage("Zastepstwa")).columns(columns).build();
        ExportExtension extensionEnum = ExportExtension.valueOf((String)extension.toUpperCase());
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"export.%s\"", extensionEnum.getExtension()));
        this.exportService.export(model, extensionEnum, (OutputStream)response.getOutputStream());
    }

    private ExportColumn buildExportColumn(String name, List<SubstitutionDto> data, Function<SubstitutionDto, String> supplier) {
        return ExportColumnBuilder.create().name(name).data(data).by(supplier).build();
    }

    private boolean loggedUserHasAdminRights() {
        String username = UserContext.current().getUser().getUserName();
        try {
            return Authorization.checkRight((String)RightTreeBuilder.builder().system().admin().build(), (String)username, (boolean)false, (boolean)false) == 0;
        }
        catch (SQLException e) {
            throw new ServiceException(this.messageHelper.getMessage("Blad_przy_sprawdzaniu_uprawnien_dla_uzytkownika", new Object[]{username}), (Throwable)e);
        }
    }

    @ExceptionHandler(value={SubstitutionException.class, ServiceException.class, NoRightsException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public RestResult handleBadRequest(Exception e) {
        return new RestResult(false, e.getMessage());
    }

    @ConstructorProperties(value={"substitutionService", "systemProperties", "exportService", "messageHelper", "substitutionMapper", "hookRegistry", "processService"})
    @Autowired
    public SubstitutionController(SubstitutionService substitutionService, SystemPropertiesBean systemProperties, ExportService exportService, MessageHelperBean messageHelper, SubstitutionMapper substitutionMapper, HookRegistry hookRegistry, ProcessService processService) {
        this.substitutionService = substitutionService;
        this.systemProperties = systemProperties;
        this.exportService = exportService;
        this.messageHelper = messageHelper;
        this.substitutionMapper = substitutionMapper;
        this.hookRegistry = hookRegistry;
        this.processService = processService;
    }
}

