/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.plugin;

import com.plusmpm.database.authorization.RightTreeBuilder;
import com.plusmpm.util.Authorization;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.security.exception.NotFullRightsException;
import com.suncode.pwfl.web.support.ajax.RestResult;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/plugins"})
public class PluginPermissionController {
    private static final Logger log = LoggerFactory.getLogger(PluginPermissionController.class);
    private final AuthorizationHelper authorizationHelper;

    @RequestMapping(value={"/{key}/permissions"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Permission> getPluginPermissions(@PathVariable String key) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        String validKey = key.replace('.', '_');
        Set authorizedUsers = Authorization.listRights((String)RightTreeBuilder.builder().system().plugins().custom((Object)validKey).build(), (boolean)false);
        Set authorizedGroups = Authorization.listRights((String)RightTreeBuilder.builder().system().plugins().custom((Object)validKey).build(), (boolean)true);
        ArrayList<Permission> permissions = new ArrayList<Permission>();
        for (String user : authorizedUsers) {
            permissions.add(new Permission(user, false));
        }
        for (String group : authorizedGroups) {
            permissions.add(new Permission(group, true));
        }
        return permissions;
    }

    @ExceptionHandler(value={NotFullRightsException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    @ResponseBody
    public RestResult handleUnauthorizedRequests(NotFullRightsException e) {
        log.info(e.getMessage());
        return new RestResult(false, e.getMessage());
    }

    @ConstructorProperties(value={"authorizationHelper"})
    @Autowired
    public PluginPermissionController(AuthorizationHelper authorizationHelper) {
        this.authorizationHelper = authorizationHelper;
    }

    static class Permission {
        private final String resource;
        private final boolean group;

        public Permission(String resource, boolean group) {
            this.resource = resource;
            this.group = group;
        }

        public String getResource() {
            return this.resource;
        }

        public boolean isGroup() {
            return this.group;
        }
    }
}

